/*
 * KubeVirt API
 * This is KubeVirt API an add-on for Kubernetes.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: kubevirt-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package kubevirt.io;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * Port repesents a port to expose from the virtual machine. Default protocol TCP. The port field is mandatory
 */
@ApiModel(description = "Port repesents a port to expose from the virtual machine. Default protocol TCP. The port field is mandatory")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-11-10T14:44:51.030+02:00")
public class V1Port {
  @SerializedName("name")
  private String name = null;

  @SerializedName("port")
  private Integer port = null;

  @SerializedName("protocol")
  private String protocol = null;

  public V1Port name(String name) {
    this.name = name;
    return this;
  }

   /**
   * If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services. +optional
   * @return name
  **/
  @ApiModelProperty(value = "If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services. +optional")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public V1Port port(Integer port) {
    this.port = port;
    return this;
  }

   /**
   * Number of port to expose for the virtual machine. This must be a valid port number, 0 &lt; x &lt; 65536.
   * @return port
  **/
  @ApiModelProperty(required = true, value = "Number of port to expose for the virtual machine. This must be a valid port number, 0 < x < 65536.")
  public Integer getPort() {
    return port;
  }

  public void setPort(Integer port) {
    this.port = port;
  }

  public V1Port protocol(String protocol) {
    this.protocol = protocol;
    return this;
  }

   /**
   * Protocol for port. Must be UDP or TCP. Defaults to \&quot;TCP\&quot;. +optional
   * @return protocol
  **/
  @ApiModelProperty(value = "Protocol for port. Must be UDP or TCP. Defaults to \"TCP\". +optional")
  public String getProtocol() {
    return protocol;
  }

  public void setProtocol(String protocol) {
    this.protocol = protocol;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V1Port v1Port = (V1Port) o;
    return Objects.equals(this.name, v1Port.name) &&
        Objects.equals(this.port, v1Port.port) &&
        Objects.equals(this.protocol, v1Port.protocol);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, port, protocol);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V1Port {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    port: ").append(toIndentedString(port)).append("\n");
    sb.append("    protocol: ").append(toIndentedString(protocol)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

