#
# Copyright (c) 2014-2015 Red Hat, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

Name: ovirt-jboss-modules-maven-plugin
Version: 2.0.2
Release: 0.1.el8
Summary: oVirt JBoss Modules Maven Plugin
Group: Development/Libraries
License: ASL 2.0
URL: https://www.ovirt.org
Source: https://resources.ovirt.org/pub/src/%{name}/ovirt-jboss-modules-maven-plugin-2.0.2.tar.gz
BuildArch: noarch

BuildRequires: javapackages-tools
BuildRequires: maven-local
BuildRequires: mvn(org.apache.maven.plugin-tools:maven-plugin-annotations)
BuildRequires: mvn(org.apache.maven.plugins:maven-plugin-plugin)
BuildRequires: mvn(org.apache.maven.plugins:maven-source-plugin)
BuildRequires: mvn(org.apache.maven:maven-artifact)
BuildRequires: mvn(org.apache.maven:maven-core)
BuildRequires: mvn(org.apache.maven:maven-plugin-api)
BuildRequires: mvn(org.apache.maven:maven-project)
BuildRequires: mvn(org.codehaus.plexus:plexus-archiver)
BuildRequires: mvn(org.codehaus.plexus:plexus-utils)

%if 0%{?fedora} || 0%{?rhel} < 8
# Below plugins are provided within maven-local in EL8+
BuildRequires: mvn(org.apache.maven.plugins:maven-javadoc-plugin)
BuildRequires: mvn(org.apache.maven.plugins:maven-release-plugin)
%endif

%description
Maven Plugin used to generate and attach an artifact containing
JBoss modules.

%package javadoc
Summary: Javadoc for %{name}.

%description javadoc
This package contains the API documentation for %{name}.

%prep
%setup -q -n %{name}

%if 0%{?rhel} >= 8
# No need for maven-javadoc-plugin in RHEL 8, xmvn will take care of it.
%pom_remove_plugin -r :maven-javadoc-plugin pom.xml
%endif

%build
%mvn_build

%install
%mvn_install

%files -f .mfiles
%dir %{_javadir}/%{name}
%doc AUTHORS.md
%doc README.md
%license LICENSE.txt

%files javadoc -f .mfiles-javadoc
%license LICENSE.txt

%changelog
* Wed Apr 15 2020 Sandro Bonazzola <sbonazzo@redhat.com> - 2.0.2-1
- Rebase on 2.0.2

* Wed Oct  7 2015 Juan Hernandez <juan.hernandez@redhat.com> - 2.0.0-1
- Initial packaging.
