%global rolename infra
%global roleprefix ovirt.
%global roleprefix_legacy ovirt-
%global roleprefix_legacy_uppercase oVirt.
%global ansible_roles_dir ansible/roles

Name: ovirt-ansible-infra
Summary: Ansible role to deploy oVirt infrastructure.
Version: 1.2.2
Release: 1%{?release_suffix}%{?dist}
Source0: http://resources.ovirt.org/pub/src/ovirt-ansible-infra/ovirt-ansible-infra-1.2.2.tar.gz
License: ASL 2.0
Group:          Virtualization/Management
BuildArch:      noarch
Url:            http://www.ovirt.org

Requires: ansible >= 2.9.0

%description
This Ansible role provide funtionality to oVirt infrastructure.

%pretrans -p <lua>
-- Remove the legacy directory before installing the symlink. This is known issue in RPM:
-- https://fedoraproject.org/wiki/Packaging:Directory_Replacement
path_dash = "%{_datadir}/%{ansible_roles_dir}/%{roleprefix_legacy}%{rolename}"
path_uppercase = "%{_datadir}/%{ansible_roles_dir}/%{roleprefix_legacy_uppercase}%{rolename}"

st = posix.stat(path_dash)
if st and st.type == "directory" then
  os.execute('rm -rf "'..path_dash..'"')
end

st = posix.stat(path_uppercase)
if st and st.type == "directory" then
  os.execute('rm -rf "'..path_uppercase..'"')
end

%prep
%setup -c -q

%build

%install
export PKG_DATA_DIR_ORIG=%{_datadir}/%{ansible_roles_dir}/%{roleprefix}%{rolename}
export PKG_DATA_DIR=%{buildroot}$PKG_DATA_DIR_ORIG
export PKG_DOC_DIR=%{buildroot}%{_pkgdocdir}
export ROLENAME_LEGACY=%{buildroot}%{_datadir}/%{ansible_roles_dir}/%{roleprefix_legacy}%{rolename}
export ROLENAME_LEGACY_UPPERCASE=%{buildroot}%{_datadir}/%{ansible_roles_dir}/%{roleprefix_legacy_uppercase}%{rolename}
sh build.sh install

%files
%{_datadir}/%{ansible_roles_dir}/%{roleprefix}%{rolename}
%{_datadir}/%{ansible_roles_dir}/%{roleprefix_legacy}%{rolename}
%{_datadir}/%{ansible_roles_dir}/%{roleprefix_legacy_uppercase}%{rolename}

%doc README.md
%doc examples/

%license LICENSE

%changelog
* Thu Jul 30 2020 Martin Necas <mnecas@redhat.com> - 1.2.2-1
- Add localfs as storage type
- Add label option to logical networks
- Make hosts variable name dynamic

* Mon Dec 2 2019 Martin Necas <mnecas@redhat.com> - 1.2.1-1
- Add build for el8.

* Mon Nov 25 2019 Martin Necas <mnecas@redhat.com> - 1.2.0-1
- Bump ansible to version 2.9.0.

* Tue Nov 5 2019 Martin Necas <mnecas@redhat.com> - 1.1.13-1
- Add host power management.

* Tue Mar 12 2019 Ondra Machacek <omachace@redhat.com> - 1.1.12-1
- Wait for hosts to be added - add no_log.

* Wed Jan 16 2019 Ondra Machacek <omachace@redhat.com> - 1.1.11-1
- Document usage of users rhbz#1638380.
- Add no_log to manage users task.

* Wed Nov 21 2018 Ondra Machacek <omachace@redhat.com> - 1.1.10-1
- Require Ansible 2.7.2.
- Support ovirt.infra name.

* Tue Oct 16 2018 Ondra Machacek <omachace@redhat.com> - 1.1.9-1
- Workaround to fix async tasks of PR #44726. gh#46
- Add missing library dir to RPM. gh#45
- Adding authentication_keys option to os_volume EP. gh#33

* Tue Sep 18 2018 Ondra Machacek <omachace@redhat.com> - 1.1.8-1
- Support using engine_fqdn instead of url.
- Check for empty ovirt_auth dict.
- Support AWX credentials. gh#38

* Wed Jul 10 2018 Ondra Machacek <omachace@redhat.com> - 1.1.7-1
- Don't return ID as list rhbz#1599055.

* Tue Jun 19 2018 Ondra Machacek <omachace@redhat.com> - 1.1.6-1
- Add support to set external network providers rhbz#1509235.

* Tue Apr 10 2018 Ondra Machacek <omachace@redhat.com> - 1.1.5-1
- Require Ansible 2.5.
- Add hosted_engine parameter.

* Thu Mar 1 2018 Ondra Machacek <omachace@redhat.com> - 1.1.4-1
- Don't fail when hosts var is not passed.
- Add login support within role.

* Wed Jan 17 2018 Ondra Machacek <omachace@redhat.com> - 1.1.3-1
- Print only host names while looping hosts.
- oVirt.datacenters: use import_role instead of include_role.
- Use skip_missing flag for subelements in oVirt.storages.

* Mon Dec 04 2017 Ondra Machacek <omachace@redhat.com> - 1.1.2-1
- Add %pretrans scriplet to remove legacy role name.

* Mon Nov 27 2017 Ondra Machacek <omachace@redhat.com> - 1.1.1-1
- Fix role names to be in sync with Ansible Galaxy.

* Mon Nov 27 2017 Ondra Machacek <omachace@redhat.com> - 1.1.0-1
- Initial release
