/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.ovirt.engine.sdk4.builders.DiskBuilder;
import org.ovirt.engine.sdk4.builders.VmBuilder;
import org.ovirt.engine.sdk4.internal.containers.CheckpointContainer;
import org.ovirt.engine.sdk4.types.Checkpoint;
import org.ovirt.engine.sdk4.types.CheckpointState;
import org.ovirt.engine.sdk4.types.Disk;
import org.ovirt.engine.sdk4.types.Vm;

public class CheckpointBuilder {
    private String comment;
    private Date creationDate;
    private String description;
    private List<Disk> disks;
    private String href;
    private String id;
    private String name;
    private String parentId;
    private CheckpointState state;
    private Vm vm;

    public CheckpointBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public CheckpointBuilder creationDate(Date newCreationDate) {
        this.creationDate = newCreationDate == null ? null : new Date(newCreationDate.getTime());
        return this;
    }

    public CheckpointBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public CheckpointBuilder disks(List<Disk> newDisks) {
        if (newDisks != null) {
            if (this.disks == null) {
                this.disks = new ArrayList<Disk>(newDisks);
            } else {
                this.disks.addAll(newDisks);
            }
        }
        return this;
    }

    public CheckpointBuilder disks(Disk ... newDisks) {
        if (newDisks != null) {
            if (this.disks == null) {
                this.disks = new ArrayList<Disk>(newDisks.length);
            }
            Collections.addAll(this.disks, newDisks);
        }
        return this;
    }

    public CheckpointBuilder disks(DiskBuilder ... newDisks) {
        if (newDisks != null) {
            if (this.disks == null) {
                this.disks = new ArrayList<Disk>(newDisks.length);
            }
            for (DiskBuilder builder : newDisks) {
                this.disks.add(builder.build());
            }
        }
        return this;
    }

    public CheckpointBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public CheckpointBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public CheckpointBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public CheckpointBuilder parentId(String newParentId) {
        this.parentId = newParentId;
        return this;
    }

    public CheckpointBuilder state(CheckpointState newState) {
        this.state = newState;
        return this;
    }

    public CheckpointBuilder vm(Vm newVm) {
        this.vm = newVm;
        return this;
    }

    public CheckpointBuilder vm(VmBuilder newVm) {
        this.vm = newVm == null ? null : newVm.build();
        return this;
    }

    public Checkpoint build() {
        CheckpointContainer container = new CheckpointContainer();
        container.comment(this.comment);
        container.creationDate(this.creationDate);
        container.description(this.description);
        container.disks(this.disks);
        container.href(this.href);
        container.id(this.id);
        container.name(this.name);
        container.parentId(this.parentId);
        container.state(this.state);
        container.vm(this.vm);
        return container;
    }
}

