/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.CpuBuilder;
import org.ovirt.engine.sdk4.builders.HostBuilder;
import org.ovirt.engine.sdk4.builders.NumaNodePinBuilder;
import org.ovirt.engine.sdk4.builders.StatisticBuilder;
import org.ovirt.engine.sdk4.builders.VmBuilder;
import org.ovirt.engine.sdk4.internal.containers.VirtualNumaNodeContainer;
import org.ovirt.engine.sdk4.types.Cpu;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.NumaNodePin;
import org.ovirt.engine.sdk4.types.NumaTuneMode;
import org.ovirt.engine.sdk4.types.Statistic;
import org.ovirt.engine.sdk4.types.VirtualNumaNode;
import org.ovirt.engine.sdk4.types.Vm;

public class VirtualNumaNodeBuilder {
    private String comment;
    private Cpu cpu;
    private String description;
    private Host host;
    private String href;
    private String id;
    private BigInteger index;
    private BigInteger memory;
    private String name;
    private String nodeDistance;
    private List<NumaNodePin> numaNodePins;
    private NumaTuneMode numaTuneMode;
    private List<Statistic> statistics;
    private Vm vm;

    public VirtualNumaNodeBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public VirtualNumaNodeBuilder cpu(Cpu newCpu) {
        this.cpu = newCpu;
        return this;
    }

    public VirtualNumaNodeBuilder cpu(CpuBuilder newCpu) {
        this.cpu = newCpu == null ? null : newCpu.build();
        return this;
    }

    public VirtualNumaNodeBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public VirtualNumaNodeBuilder host(Host newHost) {
        this.host = newHost;
        return this;
    }

    public VirtualNumaNodeBuilder host(HostBuilder newHost) {
        this.host = newHost == null ? null : newHost.build();
        return this;
    }

    public VirtualNumaNodeBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public VirtualNumaNodeBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public VirtualNumaNodeBuilder index(int newIndex) {
        this.index = BigInteger.valueOf(newIndex);
        return this;
    }

    public VirtualNumaNodeBuilder index(Integer newIndex) {
        this.index = newIndex == null ? null : BigInteger.valueOf(newIndex.longValue());
        return this;
    }

    public VirtualNumaNodeBuilder index(long newIndex) {
        this.index = BigInteger.valueOf(newIndex);
        return this;
    }

    public VirtualNumaNodeBuilder index(Long newIndex) {
        this.index = newIndex == null ? null : BigInteger.valueOf(newIndex);
        return this;
    }

    public VirtualNumaNodeBuilder index(BigInteger newIndex) {
        this.index = newIndex;
        return this;
    }

    public VirtualNumaNodeBuilder memory(int newMemory) {
        this.memory = BigInteger.valueOf(newMemory);
        return this;
    }

    public VirtualNumaNodeBuilder memory(Integer newMemory) {
        this.memory = newMemory == null ? null : BigInteger.valueOf(newMemory.longValue());
        return this;
    }

    public VirtualNumaNodeBuilder memory(long newMemory) {
        this.memory = BigInteger.valueOf(newMemory);
        return this;
    }

    public VirtualNumaNodeBuilder memory(Long newMemory) {
        this.memory = newMemory == null ? null : BigInteger.valueOf(newMemory);
        return this;
    }

    public VirtualNumaNodeBuilder memory(BigInteger newMemory) {
        this.memory = newMemory;
        return this;
    }

    public VirtualNumaNodeBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public VirtualNumaNodeBuilder nodeDistance(String newNodeDistance) {
        this.nodeDistance = newNodeDistance;
        return this;
    }

    public VirtualNumaNodeBuilder numaNodePins(List<NumaNodePin> newNumaNodePins) {
        if (newNumaNodePins != null) {
            if (this.numaNodePins == null) {
                this.numaNodePins = new ArrayList<NumaNodePin>(newNumaNodePins);
            } else {
                this.numaNodePins.addAll(newNumaNodePins);
            }
        }
        return this;
    }

    public VirtualNumaNodeBuilder numaNodePins(NumaNodePin ... newNumaNodePins) {
        if (newNumaNodePins != null) {
            if (this.numaNodePins == null) {
                this.numaNodePins = new ArrayList<NumaNodePin>(newNumaNodePins.length);
            }
            Collections.addAll(this.numaNodePins, newNumaNodePins);
        }
        return this;
    }

    public VirtualNumaNodeBuilder numaNodePins(NumaNodePinBuilder ... newNumaNodePins) {
        if (newNumaNodePins != null) {
            if (this.numaNodePins == null) {
                this.numaNodePins = new ArrayList<NumaNodePin>(newNumaNodePins.length);
            }
            for (NumaNodePinBuilder builder : newNumaNodePins) {
                this.numaNodePins.add(builder.build());
            }
        }
        return this;
    }

    public VirtualNumaNodeBuilder numaTuneMode(NumaTuneMode newNumaTuneMode) {
        this.numaTuneMode = newNumaTuneMode;
        return this;
    }

    public VirtualNumaNodeBuilder statistics(List<Statistic> newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics);
            } else {
                this.statistics.addAll(newStatistics);
            }
        }
        return this;
    }

    public VirtualNumaNodeBuilder statistics(Statistic ... newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics.length);
            }
            Collections.addAll(this.statistics, newStatistics);
        }
        return this;
    }

    public VirtualNumaNodeBuilder statistics(StatisticBuilder ... newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics.length);
            }
            for (StatisticBuilder builder : newStatistics) {
                this.statistics.add(builder.build());
            }
        }
        return this;
    }

    public VirtualNumaNodeBuilder vm(Vm newVm) {
        this.vm = newVm;
        return this;
    }

    public VirtualNumaNodeBuilder vm(VmBuilder newVm) {
        this.vm = newVm == null ? null : newVm.build();
        return this;
    }

    public VirtualNumaNode build() {
        VirtualNumaNodeContainer container = new VirtualNumaNodeContainer();
        container.comment(this.comment);
        container.cpu(this.cpu);
        container.description(this.description);
        container.host(this.host);
        container.href(this.href);
        container.id(this.id);
        container.index(this.index);
        container.memory(this.memory);
        container.name(this.name);
        container.nodeDistance(this.nodeDistance);
        container.numaNodePins(this.numaNodePins);
        container.numaTuneMode(this.numaTuneMode);
        container.statistics(this.statistics);
        container.vm(this.vm);
        return container;
    }
}

