/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import org.ovirt.engine.sdk4.builders.BackupBuilder;
import org.ovirt.engine.sdk4.builders.DiskBuilder;
import org.ovirt.engine.sdk4.builders.DiskSnapshotBuilder;
import org.ovirt.engine.sdk4.builders.HostBuilder;
import org.ovirt.engine.sdk4.builders.ImageBuilder;
import org.ovirt.engine.sdk4.internal.containers.ImageTransferContainer;
import org.ovirt.engine.sdk4.types.Backup;
import org.ovirt.engine.sdk4.types.Disk;
import org.ovirt.engine.sdk4.types.DiskFormat;
import org.ovirt.engine.sdk4.types.DiskSnapshot;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.Image;
import org.ovirt.engine.sdk4.types.ImageTransfer;
import org.ovirt.engine.sdk4.types.ImageTransferDirection;
import org.ovirt.engine.sdk4.types.ImageTransferPhase;
import org.ovirt.engine.sdk4.types.ImageTransferTimeoutPolicy;

public class ImageTransferBuilder {
    private Boolean active;
    private Backup backup;
    private String comment;
    private String description;
    private ImageTransferDirection direction;
    private Disk disk;
    private DiskFormat format;
    private Host host;
    private String href;
    private String id;
    private Image image;
    private BigInteger inactivityTimeout;
    private String name;
    private ImageTransferPhase phase;
    private String proxyUrl;
    private Boolean shallow;
    private DiskSnapshot snapshot;
    private ImageTransferTimeoutPolicy timeoutPolicy;
    private String transferUrl;
    private BigInteger transferred;

    public ImageTransferBuilder active(boolean newActive) {
        this.active = newActive;
        return this;
    }

    public ImageTransferBuilder active(Boolean newActive) {
        this.active = newActive;
        return this;
    }

    public ImageTransferBuilder backup(Backup newBackup) {
        this.backup = newBackup;
        return this;
    }

    public ImageTransferBuilder backup(BackupBuilder newBackup) {
        this.backup = newBackup == null ? null : newBackup.build();
        return this;
    }

    public ImageTransferBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public ImageTransferBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public ImageTransferBuilder direction(ImageTransferDirection newDirection) {
        this.direction = newDirection;
        return this;
    }

    public ImageTransferBuilder disk(Disk newDisk) {
        this.disk = newDisk;
        return this;
    }

    public ImageTransferBuilder disk(DiskBuilder newDisk) {
        this.disk = newDisk == null ? null : newDisk.build();
        return this;
    }

    public ImageTransferBuilder format(DiskFormat newFormat) {
        this.format = newFormat;
        return this;
    }

    public ImageTransferBuilder host(Host newHost) {
        this.host = newHost;
        return this;
    }

    public ImageTransferBuilder host(HostBuilder newHost) {
        this.host = newHost == null ? null : newHost.build();
        return this;
    }

    public ImageTransferBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public ImageTransferBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public ImageTransferBuilder image(Image newImage) {
        this.image = newImage;
        return this;
    }

    public ImageTransferBuilder image(ImageBuilder newImage) {
        this.image = newImage == null ? null : newImage.build();
        return this;
    }

    public ImageTransferBuilder inactivityTimeout(int newInactivityTimeout) {
        this.inactivityTimeout = BigInteger.valueOf(newInactivityTimeout);
        return this;
    }

    public ImageTransferBuilder inactivityTimeout(Integer newInactivityTimeout) {
        this.inactivityTimeout = newInactivityTimeout == null ? null : BigInteger.valueOf(newInactivityTimeout.longValue());
        return this;
    }

    public ImageTransferBuilder inactivityTimeout(long newInactivityTimeout) {
        this.inactivityTimeout = BigInteger.valueOf(newInactivityTimeout);
        return this;
    }

    public ImageTransferBuilder inactivityTimeout(Long newInactivityTimeout) {
        this.inactivityTimeout = newInactivityTimeout == null ? null : BigInteger.valueOf(newInactivityTimeout);
        return this;
    }

    public ImageTransferBuilder inactivityTimeout(BigInteger newInactivityTimeout) {
        this.inactivityTimeout = newInactivityTimeout;
        return this;
    }

    public ImageTransferBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public ImageTransferBuilder phase(ImageTransferPhase newPhase) {
        this.phase = newPhase;
        return this;
    }

    public ImageTransferBuilder proxyUrl(String newProxyUrl) {
        this.proxyUrl = newProxyUrl;
        return this;
    }

    public ImageTransferBuilder shallow(boolean newShallow) {
        this.shallow = newShallow;
        return this;
    }

    public ImageTransferBuilder shallow(Boolean newShallow) {
        this.shallow = newShallow;
        return this;
    }

    public ImageTransferBuilder snapshot(DiskSnapshot newSnapshot) {
        this.snapshot = newSnapshot;
        return this;
    }

    public ImageTransferBuilder snapshot(DiskSnapshotBuilder newSnapshot) {
        this.snapshot = newSnapshot == null ? null : newSnapshot.build();
        return this;
    }

    public ImageTransferBuilder timeoutPolicy(ImageTransferTimeoutPolicy newTimeoutPolicy) {
        this.timeoutPolicy = newTimeoutPolicy;
        return this;
    }

    public ImageTransferBuilder transferUrl(String newTransferUrl) {
        this.transferUrl = newTransferUrl;
        return this;
    }

    public ImageTransferBuilder transferred(int newTransferred) {
        this.transferred = BigInteger.valueOf(newTransferred);
        return this;
    }

    public ImageTransferBuilder transferred(Integer newTransferred) {
        this.transferred = newTransferred == null ? null : BigInteger.valueOf(newTransferred.longValue());
        return this;
    }

    public ImageTransferBuilder transferred(long newTransferred) {
        this.transferred = BigInteger.valueOf(newTransferred);
        return this;
    }

    public ImageTransferBuilder transferred(Long newTransferred) {
        this.transferred = newTransferred == null ? null : BigInteger.valueOf(newTransferred);
        return this;
    }

    public ImageTransferBuilder transferred(BigInteger newTransferred) {
        this.transferred = newTransferred;
        return this;
    }

    public ImageTransfer build() {
        ImageTransferContainer container = new ImageTransferContainer();
        container.active(this.active);
        container.backup(this.backup);
        container.comment(this.comment);
        container.description(this.description);
        container.direction(this.direction);
        container.disk(this.disk);
        container.format(this.format);
        container.host(this.host);
        container.href(this.href);
        container.id(this.id);
        container.image(this.image);
        container.inactivityTimeout(this.inactivityTimeout);
        container.name(this.name);
        container.phase(this.phase);
        container.proxyUrl(this.proxyUrl);
        container.shallow(this.shallow);
        container.snapshot(this.snapshot);
        container.timeoutPolicy(this.timeoutPolicy);
        container.transferUrl(this.transferUrl);
        container.transferred(this.transferred);
        return container;
    }
}

