/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.SshPublicKeyBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlSshPublicKeyReader;
import org.ovirt.engine.sdk4.internal.xml.XmlSshPublicKeyWriter;
import org.ovirt.engine.sdk4.services.SshPublicKeyService;
import org.ovirt.engine.sdk4.types.SshPublicKey;

public class SshPublicKeyServiceImpl
extends ServiceImpl
implements SshPublicKeyService {
    public SshPublicKeyServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public SshPublicKeyService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public SshPublicKeyService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public SshPublicKeyService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "SshPublicKeyService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements SshPublicKeyService.UpdateResponse {
        private SshPublicKey key;

        private UpdateResponseImpl() {
        }

        public void key(SshPublicKey key) {
            this.key = key;
        }

        @Override
        public SshPublicKey key() {
            return this.key;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<SshPublicKeyService.UpdateRequest, SshPublicKeyService.UpdateResponse>
    implements SshPublicKeyService.UpdateRequest {
        private Boolean async;
        private SshPublicKey key;

        private UpdateRequestImpl() {
        }

        @Override
        public SshPublicKeyService.UpdateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public SshPublicKeyService.UpdateRequest key(SshPublicKey key) {
            this.key = key;
            return this;
        }

        @Override
        public SshPublicKeyService.UpdateRequest key(SshPublicKeyBuilder key) {
            this.key = key.build();
            return this;
        }

        @Override
        public SshPublicKeyService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(SshPublicKeyServiceImpl.this.getConnection().getUrl() + SshPublicKeyServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlSshPublicKeyWriter.writeOne(this.key, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = SshPublicKeyServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.key(XmlSshPublicKeyReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            SshPublicKeyServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements SshPublicKeyService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<SshPublicKeyService.RemoveRequest, SshPublicKeyService.RemoveResponse>
    implements SshPublicKeyService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public SshPublicKeyService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public SshPublicKeyService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(SshPublicKeyServiceImpl.this.getConnection().getUrl() + SshPublicKeyServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = SshPublicKeyServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            SshPublicKeyServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements SshPublicKeyService.GetResponse {
        private SshPublicKey key;

        private GetResponseImpl() {
        }

        public void key(SshPublicKey key) {
            this.key = key;
        }

        @Override
        public SshPublicKey key() {
            return this.key;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<SshPublicKeyService.GetRequest, SshPublicKeyService.GetResponse>
    implements SshPublicKeyService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public SshPublicKeyService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public SshPublicKeyService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(SshPublicKeyServiceImpl.this.getConnection().getUrl() + SshPublicKeyServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = SshPublicKeyServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.key(XmlSshPublicKeyReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            SshPublicKeyServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

