/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlExternalHostReader;
import org.ovirt.engine.sdk4.services.ExternalHostService;
import org.ovirt.engine.sdk4.types.ExternalHost;

public class ExternalHostServiceImpl
extends ServiceImpl
implements ExternalHostService {
    public ExternalHostServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public ExternalHostService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "ExternalHostService:" + this.getPath();
    }

    private class GetResponseImpl
    implements ExternalHostService.GetResponse {
        private ExternalHost host;

        private GetResponseImpl() {
        }

        public void host(ExternalHost host) {
            this.host = host;
        }

        @Override
        public ExternalHost host() {
            return this.host;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<ExternalHostService.GetRequest, ExternalHostService.GetResponse>
    implements ExternalHostService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public ExternalHostService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public ExternalHostService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ExternalHostServiceImpl.this.getConnection().getUrl() + ExternalHostServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ExternalHostServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.host(XmlExternalHostReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            ExternalHostServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

