/*
 * KubeVirt API
 * This is KubeVirt API an add-on for Kubernetes.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: kubevirt-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package kubevirt.io;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kubevirt.io.V1VirtualMachineInstanceTemplateSpec;
import kubevirt.io.V1alpha1DataVolume;

/**
 * VirtualMachineSpec describes how the proper VirtualMachine should look like
 */
@ApiModel(description = "VirtualMachineSpec describes how the proper VirtualMachine should look like")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-11-10T14:44:51.030+02:00")
public class V1VirtualMachineSpec {
  @SerializedName("dataVolumeTemplates")
  private List<V1alpha1DataVolume> dataVolumeTemplates = null;

  @SerializedName("runStrategy")
  private String runStrategy = null;

  @SerializedName("running")
  private Boolean running = null;

  @SerializedName("template")
  private V1VirtualMachineInstanceTemplateSpec template = null;

  public V1VirtualMachineSpec dataVolumeTemplates(List<V1alpha1DataVolume> dataVolumeTemplates) {
    this.dataVolumeTemplates = dataVolumeTemplates;
    return this;
  }

  public V1VirtualMachineSpec addDataVolumeTemplatesItem(V1alpha1DataVolume dataVolumeTemplatesItem) {
    if (this.dataVolumeTemplates == null) {
      this.dataVolumeTemplates = new ArrayList<>();
    }
    this.dataVolumeTemplates.add(dataVolumeTemplatesItem);
    return this;
  }

   /**
   * dataVolumeTemplates is a list of dataVolumes that the VirtualMachineInstance template can reference. DataVolumes in this list are dynamically created for the VirtualMachine and are tied to the VirtualMachine&#39;s life-cycle.
   * @return dataVolumeTemplates
  **/
  @ApiModelProperty(value = "dataVolumeTemplates is a list of dataVolumes that the VirtualMachineInstance template can reference. DataVolumes in this list are dynamically created for the VirtualMachine and are tied to the VirtualMachine's life-cycle.")
  public List<V1alpha1DataVolume> getDataVolumeTemplates() {
    return dataVolumeTemplates;
  }

  public void setDataVolumeTemplates(List<V1alpha1DataVolume> dataVolumeTemplates) {
    this.dataVolumeTemplates = dataVolumeTemplates;
  }

  public V1VirtualMachineSpec runStrategy(String runStrategy) {
    this.runStrategy = runStrategy;
    return this;
  }

   /**
   * Running state indicates the requested running state of the VirtualMachineInstance mutually exclusive with Running
   * @return runStrategy
  **/
  @ApiModelProperty(value = "Running state indicates the requested running state of the VirtualMachineInstance mutually exclusive with Running")
  public String getRunStrategy() {
    return runStrategy;
  }

  public void setRunStrategy(String runStrategy) {
    this.runStrategy = runStrategy;
  }

  public V1VirtualMachineSpec running(Boolean running) {
    this.running = running;
    return this;
  }

   /**
   * Running controls whether the associatied VirtualMachineInstance is created or not Mutually exclusive with RunStrategy
   * @return running
  **/
  @ApiModelProperty(value = "Running controls whether the associatied VirtualMachineInstance is created or not Mutually exclusive with RunStrategy")
  public Boolean isRunning() {
    return running;
  }

  public void setRunning(Boolean running) {
    this.running = running;
  }

  public V1VirtualMachineSpec template(V1VirtualMachineInstanceTemplateSpec template) {
    this.template = template;
    return this;
  }

   /**
   * Template is the direct specification of VirtualMachineInstance
   * @return template
  **/
  @ApiModelProperty(required = true, value = "Template is the direct specification of VirtualMachineInstance")
  public V1VirtualMachineInstanceTemplateSpec getTemplate() {
    return template;
  }

  public void setTemplate(V1VirtualMachineInstanceTemplateSpec template) {
    this.template = template;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V1VirtualMachineSpec v1VirtualMachineSpec = (V1VirtualMachineSpec) o;
    return Objects.equals(this.dataVolumeTemplates, v1VirtualMachineSpec.dataVolumeTemplates) &&
        Objects.equals(this.runStrategy, v1VirtualMachineSpec.runStrategy) &&
        Objects.equals(this.running, v1VirtualMachineSpec.running) &&
        Objects.equals(this.template, v1VirtualMachineSpec.template);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dataVolumeTemplates, runStrategy, running, template);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V1VirtualMachineSpec {\n");
    
    sb.append("    dataVolumeTemplates: ").append(toIndentedString(dataVolumeTemplates)).append("\n");
    sb.append("    runStrategy: ").append(toIndentedString(runStrategy)).append("\n");
    sb.append("    running: ").append(toIndentedString(running)).append("\n");
    sb.append("    template: ").append(toIndentedString(template)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

