# Packages names
%global vdsm_name vdsm

# Required users and groups
%global vdsm_user vdsm
%global vdsm_group kvm
%global qemu_user qemu
%global qemu_group qemu
%global snlk_group sanlock
%global snlk_user sanlock
%global cdrom_group cdrom

# Features
%global with_ovirt_imageio 1
%global with_ovirt_vmconsole 1
%global with_gluster_mgmt 1
%global with_hooks 1
%global with_vhostmd 1
%global with_python3 0

%ifarch ppc64le
%global with_openvswitch 0
%global arch_ppc64le 1
%else
%global with_openvswitch 1
%global arch_ppc64le 0
%endif

%if 0%{?centos} || 0%{?fedora}
%global gluster_version 3.12
%else #rhel
%global gluster_version 3.8
%endif

# Default to skipping autoreconf.  Distros can change just this one line
# (or provide a command-line override) if they backport any patches that
# touch configure.ac or Makefile.am.
%{!?enable_autotools:%global enable_autotools 0}

# Required paths
%if 0%{?fedora}
%global _polkitdir %{_datadir}/polkit-1/rules.d
%else
%global _polkitdir %{_localstatedir}/lib/polkit-1/localauthority/10-vendor.d
%endif
%global _vdsm_log_dir %{_localstatedir}/log/%{vdsm_name}

# Disable debuginfo package, since vdsm is a meta-package
%global debug_package %{nil}

Name:           %{vdsm_name}
Version:        4.30.39
Release:        1%{?dist}%{?extra_release}
Summary:        Virtual Desktop Server Manager

Group:          Applications/System
License:        GPLv2+
Url:            http://www.ovirt.org/develop/developer-guide/vdsm/vdsm/
Source0:        %{vdsm_name}-%{version}.tar.gz

%{!?_licensedir:%global license %%doc}

BuildRequires: openssl
BuildRequires: python
BuildRequires: python-six >= 1.9.0
BuildRequires: python-dateutil
BuildRequires: python-subprocess32
BuildRequires: python2-devel
BuildRequires: rpm-build
BuildRequires: systemd-units

# Autotools BuildRequires
%if 0%{?enable_autotools}
BuildRequires: autoconf
BuildRequires: automake
BuildRequires: gettext-devel
BuildRequires: libtool
BuildRequires: util-linux
%endif

%if 0%{?rhel}
BuildRequires: python-enum34
%endif

%if 0%{?fedora}
BuildRequires: python2-enum34
%endif

# Numactl is not available on s390[x] and ARM
%ifnarch s390 s390x %{arm}
Requires: numactl
%endif

%ifarch x86_64
Requires: python-dmidecode
Requires: dmidecode
Requires: virt-v2v
%endif

Requires: chrony
Requires: which
Requires: sudo >= 1.7.3
Requires: logrotate
Requires: lshw
Requires: xz
Requires: python-netaddr
Requires: python-pthreading >= 0.1.3-3
Requires: python-six >= 1.9.0
Requires: python-requests
Requires: rpm-python
Requires: abrt-cli
Requires: abrt-addon-vmcore
Requires: abrt-addon-ccpp
Requires: abrt-addon-python
Requires: curl
Requires: %{name}-http = %{version}-%{release}
Requires: %{name}-jsonrpc = %{version}-%{release}
Requires: safelease >= 1.0-7
Requires: mom >= 0.5.12
Requires: util-linux
Requires(pre): shadow-utils

Obsoletes: %{name}-infra < 4.19

%if 0%{?rhel}
# Required for supporting minorversion mount option
# See https://bugzilla.redhat.com/1547681 for details.
Requires: nfs-utils >= 1.3.0-0.48.el7_4.2
%else # fedora
Requires: nfs-utils
%endif

%if 0%{?with_ovirt_imageio}
Requires: ovirt-imageio-common
# For GET /tickets/*
Requires: ovirt-imageio-daemon >= 1.2.0
%endif

%if 0%{?with_ovirt_vmconsole}
Requires: ovirt-vmconsole >= 1.0.0-0
%endif

# Python
# For https://bugzilla.redhat.com/1518676
%if 0%{?rhel}
Requires: python >= 2.7.5-65.el7
%else
Requires: python >= 2.7.14-4
%endif

Requires: libvirt-client
Requires: libvirt-daemon-config-nwfilter
Requires: libvirt-lock-sanlock

%if 0%{?rhel}
# 7.6 baseline
Requires: libvirt-python >= 4.5.0-1.el7
# CVE-2018-12126, CVE-2018-12127, CVE-2018-12130, CVE-2019-11091
Requires: libvirt-daemon-kvm >= 4.5.0-10.el7_6.9
%else # fedora
# Required for preventing an HotPlug disk failure due to cgroups.
# See https://bugzilla.redhat.com/1540872 for details.
Requires: libvirt-python >= 3.7.0
# Required to fix order of VM life cycle events.
# See https://bugzilla.redhat.com/1612943 for details.
%ifnarch s390 s390x
# virt-preview is not available for s390
Requires: libvirt-daemon-kvm >= 4.9.0-1
%else
Requires: libvirt-daemon-kvm
%endif
%endif

# iscsi-intiator versions
Requires: iscsi-initiator-utils >= 6.2.0.873-21

# Adding 4k support.
%ifarch ppc64le
Requires: sanlock-python >= 3.6.0
%else
Requires: sanlock-python >= 3.7.3
%endif

# device-mapper-multipath

%if 0%{?rhel}
# Required for blacklisting multipath devices by protocol.
# See https://bugzilla.redhat.com/1016535 for more details.
Requires: device-mapper-multipath >= 0.4.9-119.el7_5.1
%endif #rhel

%if 0%{?fedora}
Requires: device-mapper-multipath >= 0.7.4-3
%endif

# augeas

%if 0%{?rhel}
Requires: python-augeas
%endif

%if 0%{?fedora}
Requires: python2-augeas
%endif

Requires: policycoreutils-python
Requires: fence-agents-all
Requires: systemd >= 219-11
Requires: initscripts >= 9.49.31
Requires: cyrus-sasl-scram
%if 0%{?fedora}
# Required for solving bug 1575762
Requires: lvm2 >= 2.02.177-5
%else
Requires: lvm2 >= 2.02.145
%endif

%if 0%{?rhel}
%if 0%{?centos}
# CVE-2018-12126, CVE-2018-12127, CVE-2018-12130, CVE-2019-11091
Requires: kernel >= 3.10.0-957.12.2.el7
%else # rhel
%ifarch ppc64le
# CVE-2019-14835
Requires: kernel >= 3.10.0-957.35.2.el7
%else # x86_64
# CVE-2019-14835
Requires: kernel >= 3.10.0-1062.1.2.el7
%endif
%endif
Requires: e2fsprogs
Requires: selinux-policy-targeted >= 3.13.1-166.el7_4.3
%else # fedora
# CVE-2018-12126, CVE-2018-12127, CVE-2018-12130, CVE-2019-11091
Requires: kernel >=  5.0.16-100
Requires: e2fsprogs >= 1.41.14
Requires: policycoreutils-python-utils
Requires: sed >= 4.2.1-10
Requires: ed
Requires: selinux-policy-targeted >= 3.13-1
# In order to avoid a policycoreutils bug (rhbz 889698) when selinux is
# disabled we now require the version 2.1.13-55 (or newer) of Fedora.
Requires: policycoreutils >= 2.1.13-55
%endif

# qemu-kvm

%if 0%{?rhel}
%if 0%{?centos} || %{arch_ppc64le}
# 4k not supported yet on centos, and on ppc64le we are limited to rhel 7.6.
# CVE-2018-12126, CVE-2018-12127, CVE-2018-12130, CVE-2019-11091
Requires: qemu-kvm-rhev >= 10:2.12.0-18.el7_6.5
%else
# For 4k support
# https://bugzilla.redhat.com/1745443
Requires: qemu-kvm-rhev >= 10:2.12.0-33.el7_7.3
%endif # centos or ppc64le
%endif

%if 0%{?fedora}
%ifarch s390 s390x
# virt-preview is not available on s390 arch.
Requires: qemu-kvm >= 2:2.11.2
%else
# For 4k support:
# - https://bugzilla.redhat.com/1737256
# - https://bugzilla.redhat.com/1738657
Requires: qemu-kvm >= 2:4.1.0-2
%endif # s390
%endif # fedora

# GlusterFS client-side RPMs needed for Gluster SD
%ifnarch ppc64le
Requires: glusterfs-cli >= %{gluster_version}
Requires: glusterfs-fuse >= %{gluster_version}
%endif

Requires: psmisc >= 22.6-15

# Make sure we require sos version which includes VDSM plugin
%ifarch ppc64le
# Currently we are without sos VDSM plugin on power, because power8 is going
# to be using RHEL 7.7, but power9 is going to stay on RHEL 7.6-ALT.
Requires: sos
%else
%if 0%{?centos} || 0%{?fedora}
# Currently we are without sos VDSM plugin on CentOS/Fedora:
#  - CentOS: When 7.7 is released, we also need to require 3.7-3+
#  - Fedora: When sos 3.7.1/3.8 is relased, we need to require it
Requires: sos
%else
# RHEL
Requires: sos >= 3.7-3
%endif
%endif

Requires: tree
Requires: dosfstools
Requires: genisoimage
Requires: libselinux-python >= 2.5-2
Requires: %{name}-python = %{version}-%{release}
Requires: %{name}-hook-vmfex-dev = %{version}-%{release}
Requires: libguestfs-tools-c

Requires(post): /usr/sbin/saslpasswd2

%if 0%{?fedora}
Requires(post): hostname
%else
Requires(post): /bin/hostname
%endif

# SecureBoot & q35, supported by x86_64 and aarch64; no ppc64le support at
# the moment.
%ifarch x86_64 %{arm}
%if 0%{?rhel}
Requires: OVMF
%else # fedora
Requires: edk2-ovmf
%endif
%endif

Requires: python-pyudev

Conflicts: ovirt-hosted-engine-ha < 2.3.6

Conflicts: vdsm-hook-sriov
Obsoletes: vdsm-hook-vfio-mdev
Provides: vdsm-hook-vfio-mdev

%description
The VDSM service is required by a Virtualization Manager to manage the
Linux hosts. VDSM manages and monitors the host's storage, memory and
networks as well as virtual machine creation, other host administration
tasks, statistics gathering, and log collection.

%package http
Summary:        VDSM http API
BuildArch:      noarch
Provides: %{name}-xmlrpc = %{version}-%{release}
Requires: %{name}-python = %{version}-%{release}
Obsoletes: %{name}-xmlrpc < %{version}-%{release}

%description http
A http interface for interacting with vdsmd when using OVF store image
download or upload.

%package client
Summary:        VDSM client
BuildArch:      noarch
# A hack for unbreaking external packages that expect vdsm-cli.
Provides: %{name}-cli = %{version}-%{release}
Requires: %{name}-api = %{version}-%{release}
Requires: %{name}-yajsonrpc = %{version}-%{release}
Requires: %{name}-python = %{version}-%{release}
Obsoletes: %{name}-cli < %{version}-%{release}

%description client
Access vdsm API from the command line.

%package api
Summary:        VDSM API
BuildArch:      noarch
BuildRequires:  PyYAML

%description api
Contains api schema files

%package jsonrpc
Summary:        VDSM API Server
BuildArch:      noarch
Requires:       %{name}-python = %{version}-%{release}
Requires:       %{name}-api = %{version}-%{release}
Requires:       %{name}-yajsonrpc = %{version}-%{release}
Obsoletes:      %{name}-api < 4.16

%description jsonrpc
A Json-based RPC interface that serves as the protocol for libvdsm.

%package yajsonrpc
Summary:        JSON RPC server and client implementation
BuildArch:      noarch
Requires:       python >= 2.6

%description yajsonrpc
A JSON RPC server and client implementation.

%package common
Summary:        common VDSM python libraries, required by all subsystems
BuildArch:      noarch
Requires:       systemd
Requires:       glibc
Requires:       python-dateutil
Requires:       python-six >= 1.9.0
Requires:       python-subprocess32
%if 0%{?rhel}
Requires:       python-decorator
Requires:       python-enum34
Requires:       libvirt-python >= 3.2.0-3.el7_4.1
%endif
%if 0%{?fedora}
Requires:       python2-decorator
Requires:       python2-enum34
Requires:       libvirt-python >= 3.7.0
%endif

%description common
VDSM libraries that are imported by all subsystems

%package network
Summary:        VDSM network python libraries
Requires:       NetworkManager-config-server
Requires:       dbus-python
Requires:       dhclient
Requires:       ethtool
Requires:       initscripts
Requires:       iproute
%if 0%{?fedora} >= 25
Requires:       iproute-tc
%endif
Requires:       libnl3
Requires:       libselinux-python
Requires:       lldpad
%if 0%{?with_openvswitch}
Requires:       openvswitch >= 2.7.0
%endif
Requires:       python-inotify
Requires:       python-ipaddress
Requires:       python-netaddr
Requires:       python-six
Requires:       systemd
Requires:       %{name}-common = %{version}-%{release}

%description network
VDSM network python libraries

%package python
Summary:        VDSM python libraries
Requires:       %{name}-api = %{version}-%{release}
BuildArch:      noarch
# Provides probe_block_size(), see https://bugzilla.redhat.com/1753898
Requires:       python2-ioprocess >= 1.3.0
Requires:       %{name}-common = %{version}-%{release}
Requires:       %{name}-network = %{version}-%{release}

%description python
Shared libraries between the various VDSM packages.

%post python
# REQUIRED_FOR: Upgrade from 4.14 to 4.17
# HACK: Remove vdsm python lib __init__ file if installed on old location
# https://bugzilla.redhat.com/show_bug.cgi?id=1279167
if [ "$1" -ge 2 ]; then
    if [ -d "%{python2_sitearch}/%{vdsm_name}" ]; then
        logger -t '%{vdsm_name}' \
            'Disabling old vdsm package in %{python2_sitearch}/%{vdsm_name}.' \
            'Removing %{python2_sitearch}/%{vdsm_name}/init.py*'
        rm -f %{python2_sitearch}/%{vdsm_name}/__init__.py*
    fi
fi

%package tests
Summary:        VDSM Test Suite
BuildArch:      noarch
Requires:       %{name} = %{version}-%{release}
Requires:       %{name}-common = %{version}-%{release}
Requires:       %{name}-network = %{version}-%{release}
Requires:       dracut
Requires:       python-nose python-ipaddress
Requires:       PyYAML

%description tests
A test suite for verifying the functionality of a running vdsm instance

%package hook-allocate_net
Summary:        random_network allocation hook for VDSM
BuildArch:      noarch
Requires:       %{name}

%description hook-allocate_net
VDSM hook used to allocate networks for vms in a random fashion

%package hook-boot_hostdev
Summary:        allows setting boot order for hostdev
BuildArch:      noarch
Requires:       %{name}

%description hook-boot_hostdev
VDSM hook used to boot vms from passthrough devices via custom property

%package hook-checkimages
Summary:        Qcow2 disk image format check hook for VDSM
BuildArch:      noarch
Requires:       %{name}

%description hook-checkimages
VDSM hook used to perform consistency check on a qcow2 format disk image
using the QEMU disk image utility.

%package hook-checkips
Summary:        Check connectivity from the host to designated IPs
Requires:       %{name} = %{version}-%{release}

%description hook-checkips
VDSM hook used to check connectivity from the host network to designated IPs

%post hook-checkips
%systemd_post vdsm-checkips.service

%preun hook-checkips
%systemd_preun vdsm-checkips.service

%package hook-diskunmap
Summary:        Activate UNMAP for disk/lun devices
BuildArch:      noarch
Requires:       qemu-kvm >= 1.5

%description hook-diskunmap
VDSM hooks which allow to activate disk UNMAP.

%package hook-ethtool-options
Summary:        Allow setting custom ethtool options for vdsm controlled nics
BuildArch:      noarch
Requires:       %{name} = %{version}-%{release}

%description hook-ethtool-options
VDSM hook used for applying custom network properties that define ethtool
options for vdsm network nics

%package hook-extra-ipv4-addrs
Summary:        Set extra ipv4 addresses for vdsm networks.

%description hook-extra-ipv4-addrs
This hook allows the user to set extra ipv4
addresses for vdsm networks.

%if 0%{?with_vhostmd}
%package hook-vhostmd
Summary:        VDSM hook set for interaction with vhostmd
BuildArch:      noarch
Requires:       vhostmd

%description hook-vhostmd
VDSM hook to use vhostmd per VM according to Virtualization Manager requests.
%endif

%package hook-faqemu
Summary:        Fake qemu process for VDSM quality assurance
BuildArch:      noarch
Requires:       %{name}

%description hook-faqemu
VDSM hook used for testing VDSM with multiple fake virtual machines without
running real guests.
To enable this hook on your host, set vars.fake_kvm_support=True in your
/etc/vdsm/vdsm.conf before adding the host to ovirt-Engine.

%package hook-localdisk
Summary:        Use a local image instead of a shared storage image
BuildArch:      noarch
Requires:       %{name} == %{version}

%description hook-localdisk
This hook adds the ability to use fast local storage instead of shared
storage, while using shared storage for managing VM templates.
To enable this hook, the VM should have a custom property of 'localdisk=lvm'.
The system administrator will be responsible for creating the host "ovirt-local"
volume group and extending it with new devices if needed.
The VM must be pinned to the host.

%package hook-macbind
Summary:        Bind a vNIC to a Bridge
BuildArch:      noarch
Requires:       %{name} >= 4.14

%description hook-macbind
VDSM hooks which allow to bind a vNIC to a Bridge, managed or not by engine.

%package hook-macspoof
Summary:        Disables MAC spoofing filtering
BuildArch:      noarch

%description hook-macspoof
VDSM hooks which allow to disable mac spoof filtering
either on all the of the VM's interfaces or on
specific vnics.

%package hook-extnet
Summary:        Force a vNIC to connect to a specific libvirt network
BuildArch:      noarch
Requires:       %{name} = %{version}-%{release}

%description hook-extnet
VDSM hook which allows to connect a vNIC to a libvirt network that is managed
outside of oVirt, such as an openvswitch network.

%package hook-fakevmstats
Summary:        Generate random VM statistics
BuildArch:      noarch
Requires:       %{name}

%description hook-fakevmstats
Hook intercepts VM's stats and randomizes various fields.
To enable this hook on your host, set vars.fake_vmstats_enable=true in your
/etc/vdsm/vdsm.conf.

%package hook-fileinject
Summary:        Allow uploading file to VMs disk
BuildArch:      noarch
Requires:       python-libguestfs

%description hook-fileinject
Hook is getting target file name and its content and
create that file in target machine.

%package hook-floppy
Summary:        Allow adding floppy to VM
BuildArch:      noarch

%description hook-floppy
Allow adding floppy to VM

%package hook-httpsisoboot
Summary:        Allow directly booting from an https available ISO
BuildArch:      noarch
%if 0%{?rhel}
Requires:       qemu-kvm-rhev >= 10:2.1.2-3
%endif

%description hook-httpsisoboot
Let the VM boot from an ISO image made available via an https URL without
the need to import the ISO into an ISO storage domain.
It doesn't support plain http.

%package hook-nestedvt
Summary:        Nested Virtualization support for VDSM
BuildArch:      noarch

%description hook-nestedvt
If the nested virtualization is enabled in your kvm module
this hook will expose it to the guests.

%package hook-numa
Summary:        NUMA support for VDSM
BuildArch:      noarch

%description hook-numa
Hooks is getting number/rage of NUMA nodes and NUMA mode,
and update the VM xml.

%package hook-openstacknet
Summary:        OpenStack Network vNICs support for VDSM
BuildArch:      noarch

%description hook-openstacknet
Hook for OpenStack Network vNICs.

%package hook-pincpu
Summary:        Hook pin VM so specific CPUs
BuildArch:      noarch

%description hook-pincpu
pincpu is hook for VDSM.
pincpu enable to pin virtual machine to a specific CPUs.

%package hook-promisc
Summary:        Network interface promiscuous mode support for VDSM
BuildArch:      noarch

%description hook-promisc
VDSM promiscuous mode let user define a VM interface that will capture
all network traffic.

%package hook-qemucmdline
Summary:        QEMU cmdline hook for VDSM
BuildArch:      noarch
Requires:       %{name}

%description hook-qemucmdline
Provides support for injecting QEMU cmdline via VDSM hook.
It exploits libvirt's qemu:commandline facility available in the
qemu xml namespace.

%package hook-scratchpad
Summary:        One time disk creation for VDSM
BuildArch:      noarch

%description hook-scratchpad
scratchpad hook for VDSM
Hook creates a disk for a VM onetime usage,
the disk will be erased when the VM destroyed.
VM cannot be migrated when using scratchpad hook

%package hook-smbios
Summary:        Adding custom smbios entries to libvirt domain via VDSM
BuildArch:      noarch

%description hook-smbios
Adding custom smbios entries to libvirt domain via VDSM
such as: vendor, version, date and release

%package hook-spiceoptions
Summary:        To configure spice options for vm
BuildArch:      noarch

%description hook-spiceoptions
This vdsm hook can be used to configure some of
the spice optimization attributes and values..

%package hook-vmfex-dev
Summary:        VM-FEX vNIC support for VDSM
BuildArch:      noarch
Requires:       %{name} = %{version}-%{release}
Conflicts:      hook-vmfex

%description hook-vmfex-dev
Allows to use custom device properties to connect a guest vNIC to a host
VM-FEX Virtual Function (SR-IOV with macvtap mode).

%package hook-vmdisk
Summary:        External disk support for VDSM
BuildArch:      noarch

%description hook-vmdisk
Hook adds additional disk image for a VM (raw or qcow2)

%package hook-fcoe
Summary:        Hook to enable FCoE support
BuildArch:      noarch
Requires:       %{name} = %{version}-%{release}
Requires:       fcoe-utils

%description hook-fcoe
VDSM hook used for configure specified NICs as FCoE interface through custom
network properties

%post hook-fcoe
%systemd_post lldpad.service
%systemd_post fcoe.service

%package hook-cpuflags
Summary:        Hook that modifies guest's CPU flags
BuildArch:      noarch

%description hook-cpuflags
Hook that modifies guest's CPU flags using custom properties.

%package hook-hostdev-scsi
Summary:        Hook to optimize hostdev SCSI devices translating their config.
BuildArch:      noarch

%description hook-hostdev-scsi
Hook to optimizet hostdev SCSI generic devices translating their configuration
into more specific one.

%if 0%{?with_gluster_mgmt}
%package gluster
Summary:        Gluster Plugin for VDSM
Requires: %{name} = %{version}-%{release}
Requires: glusterfs-server >= %{gluster_version}
Requires: glusterfs-api >= %{gluster_version}
Requires: glusterfs-geo-replication >= %{gluster_version}
Requires: glusterfs-events >= %{gluster_version}
Requires: python-magic
Requires: PyYAML
%if 0%{?fedora}
Requires: python-blivet1 >= 1.20.4-1
%else
Requires: python-blivet
%endif
Requires: xfsprogs
%ifarch x86_64
Requires: vdo
Requires: kmod-kvdo
%endif


%description gluster
Gluster plugin enables VDSM to serve Gluster functionalities.
%endif

%prep
%setup -q

%build
%if 0%{?enable_autotools}
autoreconf -if
%endif

%configure --with-data-center=/rhev/data-center --with-smbios-manufacturer=oVirt '--with-smbios-osname=oVirt Node' --with-polkitdir=/var/lib/polkit-1/localauthority/10-vendor.d --enable-hooks --disable-python3 --with-ovirt-vmconsole-user=ovirt-vmconsole     --with-ovirt-vmconsole-group=ovirt-vmconsole
make

%install
make DESTDIR=%{buildroot} install

%pre
# Force standard locale behavior (English)
export LC_ALL=C

/usr/bin/getent passwd %{vdsm_user} >/dev/null || \
    /usr/sbin/useradd -r -u 36 -g %{vdsm_group} -d /var/lib/vdsm \
        -s /sbin/nologin -c "Node Virtualization Manager" %{vdsm_user}
/usr/sbin/usermod -a -G %{qemu_group},%{snlk_group} %{vdsm_user}
/usr/sbin/usermod -a -G %{cdrom_group} %{qemu_user}

# We keep the previous rpm version number in a file for managing upgrade flow
if [ "$1" -gt 1 ]; then
    rpm -q %{vdsm_name} > "%{_localstatedir}/lib/%{vdsm_name}/upgraded_version"
    # Both vdsm and supervdsm should be managed here and must be restarted if
    # ran before the upgrade
    if /bin/systemctl status vdsmd >/dev/null 2>&1; then
        /usr/bin/touch "%{_localstatedir}/lib/%{vdsm_name}/vdsmd_start_required"
    fi
    if /bin/systemctl status supervdsmd >/dev/null 2>&1; then
        /usr/bin/touch "%{_localstatedir}/lib/%{vdsm_name}/supervdsmd_start_required"
    fi

fi

%post
# After vdsm install we should create the logs files.
# In the install session we create it but since we use
# the ghost macro (in files session) the files are not included
touch %{_vdsm_log_dir}/{mom.log,supervdsm.log,vdsm.log}
chmod 0644 %{_vdsm_log_dir}/{mom.log,supervdsm.log,vdsm.log}
chown vdsm:kvm %{_vdsm_log_dir}/{mom.log,vdsm.log}
chown root:root %{_vdsm_log_dir}/supervdsm.log

systemd-tmpfiles --create %{vdsm_name}.conf

# Have moved vdsm section in /etc/sysctl.conf to /etc/sysctl.d/vdsm.conf.
# So Remove them if it is played with /etc/sysctl.conf.
if grep -q "# VDSM section begin" /etc/sysctl.conf; then
    /bin/sed -i '/# VDSM section begin/,/# VDSM section end/d' \
        /etc/sysctl.conf
fi

# VDSM installs vdsm-modules-load.d.conf file - the following command will
# refresh vdsm kernel modules requirements to start on boot
/bin/systemctl restart systemd-modules-load.service >/dev/null 2>&1 || :

# The following triggers vdsmd.preset file and enables vdsm required services
%systemd_post dev-hugepages1G.mount
%systemd_post vdsmd.service
%systemd_post supervdsmd.service
%systemd_post vdsm-network.service
%systemd_post vdsm-network-init.service
%systemd_post mom-vdsm.service
%systemd_post ksmtuned.service

# VDSM installs unit files - daemon-reload will refresh systemd
/bin/systemctl daemon-reload >/dev/null 2>&1 || :
exit 0

%preun
if [ "$1" -eq 0 ]; then
        %{_bindir}/vdsm-tool remove-config
fi
%systemd_preun dev-hugepages1G.mount
%systemd_preun vdsmd.service
%systemd_preun vdsm-network.service
%systemd_preun vdsm-network-init.service
%systemd_preun supervdsmd.service
%systemd_preun mom-vdsm.service
%systemd_preun ksmtuned.service
exit 0

%posttrans
if  [ -f "%{_localstatedir}/lib/%{vdsm_name}/upgraded_version" ]; then
    # removing temporary files at first to avoid leaving upgrade leftovers
    /bin/rm -f "%{_localstatedir}/lib/%{vdsm_name}/upgraded_version"
    if [ -f "%{_localstatedir}/lib/%{vdsm_name}/vdsmd_start_required" ]; then
        vdsmd_start_required='yes'
        /bin/rm -f "%{_localstatedir}/lib/%{vdsm_name}/vdsmd_start_required"
        /bin/systemctl stop vdsmd >/dev/null 2>&1 || :
    fi

    if [ -f "%{_localstatedir}/lib/%{vdsm_name}/supervdsmd_start_required" ]; then
        supervdsmd_start_required='yes'
        /bin/rm -f "%{_localstatedir}/lib/%{vdsm_name}/supervdsmd_start_required"
        /bin/systemctl stop supervdsmd >/dev/null 2>&1 || :
    fi

    if /bin/systemctl status vdsm-network >/dev/null 2>&1; then
        /bin/systemctl stop vdsm-network >/dev/null 2>&1 || :
    fi

    if ! %{_bindir}/vdsm-tool is-configured >/dev/null 2>&1; then
        %{_bindir}/vdsm-tool configure --force >/dev/null 2>&1
    fi

    if [ "${supervdsmd_start_required}" = 'yes' ]; then
        /bin/systemctl start supervdsmd >/dev/null 2>&1 || :
    fi
    if [ "${vdsmd_start_required}" = 'yes' ]; then
        /bin/systemctl start vdsmd >/dev/null 2>&1 || :
    fi
fi
exit 0

%files
%doc README.md
%doc lib/vdsm/vdsm.conf.sample
%doc README.logging
%doc ChangeLog
%license COPYING
%{_presetdir}/85-vdsmd.preset
%{_unitdir}/dev-hugepages1G.mount
%{_unitdir}/vdsmd.service
%{_unitdir}/vdsm-network.service
%{_unitdir}/vdsm-network-init.service
%{_unitdir}/supervdsmd.service
%{_unitdir}/mom-vdsm.service
%{_sysconfdir}/systemd/system/libvirtd.service.d/unlimited-core.conf

%dir %attr(-, %{vdsm_user}, %{vdsm_group}) /rhev/data-center
%ghost %config %attr(0644, %{vdsm_user}, %{vdsm_group}) %{_vdsm_log_dir}/mom.log
%ghost %config %attr(0644, root, root) %{_vdsm_log_dir}/supervdsm.log
%ghost %config %attr(0644, %{vdsm_user}, %{vdsm_group}) %{_vdsm_log_dir}/vdsm.log
%ghost %dir %attr(-, %{vdsm_user}, %{vdsm_group}) /rhev/data-center/hsm-tasks
%ghost %dir %attr(-, %{vdsm_user}, %{vdsm_group}) /rhev/data-center/mnt
%dir %{_libexecdir}/%{vdsm_name}
%dir %{_sysconfdir}/%{vdsm_name}/vdsm.conf.d
%dir %{_sysconfdir}/modprobe.d/
%dir %{_sysconfdir}/NetworkManager
%dir %{_sysconfdir}/NetworkManager/conf.d
%dir %{_sysconfdir}/%{vdsm_name}
%dir %{_sysconfdir}/%{vdsm_name}/mom.d
%dir %{_datadir}/%{vdsm_name}
%{_datadir}/%{vdsm_name}/daemonAdapter
%{_datadir}/%{vdsm_name}/sitecustomize.py*
%{_datadir}/%{vdsm_name}/supervdsmd
%{_datadir}/%{vdsm_name}/vdsmd

%config(noreplace) %{_sysconfdir}/%{vdsm_name}/vdsm.conf
%config(noreplace) %{_sysconfdir}/%{vdsm_name}/logger.conf
%config(noreplace) %{_sysconfdir}/%{vdsm_name}/svdsm.logger.conf
%config(noreplace) %{_sysconfdir}/%{vdsm_name}/mom.conf
%config(noreplace) %{_sysconfdir}/%{vdsm_name}/mom.d/*.policy
%config(noreplace) %{_sysconfdir}/%{vdsm_name}/logrotate/vdsm
%config(noreplace) %{_sysconfdir}/sysctl.d/vdsm.conf
%config(noreplace) %{_sysconfdir}/modules-load.d/vdsm.conf
%{_tmpfilesdir}/%{vdsm_name}.conf
%{_sysconfdir}/dhcp/dhclient.d/dhclientmon.sh
%{_sysconfdir}/modprobe.d/vdsm-bonding-modprobe.conf
%{_sysconfdir}/NetworkManager/conf.d/vdsm.conf
%{_sysconfdir}/sudoers.d/50_vdsm
%{_sysconfdir}/cron.hourly/vdsm-logrotate
%{_sysconfdir}/libvirt/hooks/qemu
%{_exec_prefix}/lib/dracut/dracut.conf.d/99-vdsm_protect_ifcfg.conf
%{_libexecdir}/%{vdsm_name}/curl-img-wrap
%{_libexecdir}/%{vdsm_name}/fc-scan
%{_libexecdir}/%{vdsm_name}/managedvolume-helper
%{_libexecdir}/%{vdsm_name}/vdsm-gencerts.sh
%{_libexecdir}/%{vdsm_name}/vdsmd_init_common.sh
%{_libexecdir}/%{vdsm_name}/vm_libvirt_hook.py*
%{_libexecdir}/%{vdsm_name}/kvm2ovirt
%{_libexecdir}/%{vdsm_name}/fallocate
%{_libexecdir}/%{vdsm_name}/wait_for_ipv4s
%{_libexecdir}/%{vdsm_name}/spmprotect.sh
%{_libexecdir}/%{vdsm_name}/spmstop.sh
%dir %{_libexecdir}/%{vdsm_name}/hooks
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_device_create
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_device_create
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_device_destroy
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_device_destroy
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vm_start
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vm_start
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vm_cont
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vm_cont
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vm_pause
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vm_pause
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vm_hibernate
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vm_hibernate
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vm_dehibernate
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vm_dehibernate
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_device_migrate_source
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_device_migrate_source
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_device_migrate_destination
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_device_migrate_destination
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vm_migrate_source
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vm_migrate_source
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vm_migrate_destination
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vm_migrate_destination
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vm_destroy
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vm_destroy
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vm_set_ticket
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vm_set_ticket
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_update_device
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_update_device
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_update_device_fail
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_nic_hotplug
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_nic_hotplug
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_nic_hotunplug
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_nic_hotunplug
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_nic_hotplug_fail
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_nic_hotunplug_fail
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_disk_prepare
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_disk_hotplug
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_disk_hotplug
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_disk_hotunplug
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_disk_hotunplug
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vdsm_start
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vdsm_stop
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_network_setup
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_network_setup
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_network_setup_fail
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_set_num_of_cpus
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_set_num_of_cpus
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_memory_hotplug
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_memory_hotplug
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_get_vm_stats
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_get_vm_stats
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_get_all_vm_stats
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_get_all_vm_stats
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_get_caps
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_get_caps
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_get_stats
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_get_stats
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_hostdev_list_by_caps
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_ifcfg_write
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_ifcfg_write

%{_libexecdir}/%{vdsm_name}/get-conf-item
%{_udevrulesdir}/12-vdsm-lvm.rules
/etc/security/limits.d/99-vdsm.conf
%{_mandir}/man8/vdsmd.8*
%{_polkitdir}/10-vdsm-libvirt-access.rules

%defattr(-, %{vdsm_user}, %{qemu_group}, -)
%dir %{_localstatedir}/lib/libvirt/qemu/channels

%defattr(-, %{vdsm_user}, %{vdsm_group}, -)
%dir %{_sysconfdir}/pki/%{vdsm_name}
%dir %{_sysconfdir}/pki/%{vdsm_name}/keys
%dir %{_sysconfdir}/pki/%{vdsm_name}/certs
%dir %{_sysconfdir}/pki/%{vdsm_name}/libvirt-spice
%config(noreplace) %{_sysconfdir}/pki/%{vdsm_name}/keys/libvirt_password
%dir %{_localstatedir}/lib/%{vdsm_name}
%dir %{_localstatedir}/lib/%{vdsm_name}/netconfback
%dir %{_localstatedir}/lib/%{vdsm_name}/persistence
%dir %{_localstatedir}/lib/%{vdsm_name}/staging
%dir %{_localstatedir}/lib/%{vdsm_name}/storage
%dir %{_localstatedir}/lib/%{vdsm_name}/upgrade
%dir %{_localstatedir}/log/%{vdsm_name}
%dir %{_localstatedir}/log/%{vdsm_name}/backup
%dir %{_localstatedir}/log/%{vdsm_name}/import
%defattr(644, %{vdsm_user}, %{vdsm_group}, -)
%{_datadir}/%{vdsm_name}/lvmlocal.conf
%{_datadir}/%{vdsm_name}/autounattend/Win7.xml
%{_datadir}/%{vdsm_name}/autounattend/Win8.xml
%{_datadir}/%{vdsm_name}/autounattend/Win8.1.xml
%{_datadir}/%{vdsm_name}/autounattend/Win10.xml
%{_datadir}/%{vdsm_name}/autounattend/Win2008.xml
%{_datadir}/%{vdsm_name}/autounattend/Win2008R2.xml
%{_datadir}/%{vdsm_name}/autounattend/Win2012.xml
%{_datadir}/%{vdsm_name}/autounattend/Win2012R2.xml
%{_datadir}/%{vdsm_name}/autounattend/Win2016.xml

%{_sysconfdir}/yum/pluginconf.d/vdsmupgrade.conf
%{_datadir}/yum-plugins/*.py*

%files common
%dir %{python_sitelib}/%{vdsm_name}
%dir %{python_sitelib}/%{vdsm_name}/common
%dir %{python_sitelib}/%{vdsm_name}/common/network
%{python_sitelib}/%{vdsm_name}/__init__.py*
%{python_sitelib}/%{vdsm_name}/common/*.py*
%{python_sitelib}/%{vdsm_name}/common/network/*.py*

%files network
%dir %{python_sitelib}/%{vdsm_name}/network
%dir %{python_sitelib}/%{vdsm_name}/network/configurators
%dir %{python_sitelib}/%{vdsm_name}/network/ip
%dir %{python_sitelib}/%{vdsm_name}/network/ip/address
%dir %{python_sitelib}/%{vdsm_name}/network/ip/route
%dir %{python_sitelib}/%{vdsm_name}/network/ip/rule
%dir %{python_sitelib}/%{vdsm_name}/network/link
%dir %{python_sitelib}/%{vdsm_name}/network/link/bond
%dir %{python_sitelib}/%{vdsm_name}/network/lldp
%dir %{python_sitelib}/%{vdsm_name}/network/lldpad
%dir %{python_sitelib}/%{vdsm_name}/network/netinfo
%dir %{python_sitelib}/%{vdsm_name}/network/netlink
%dir %{python_sitelib}/%{vdsm_name}/network/netswitch
%dir %{python_sitelib}/%{vdsm_name}/network/nm
%dir %{python_sitelib}/%{vdsm_name}/network/nm/nmdbus
%dir %{python_sitelib}/%{vdsm_name}/network/ovs
%dir %{python_sitelib}/%{vdsm_name}/network/ovs/driver
%dir %{python_sitelib}/%{vdsm_name}/network/tc
%{python_sitelib}/%{vdsm_name}/network/*.py*
%{python_sitelib}/%{vdsm_name}/network/*/*.py*
%{python_sitelib}/%{vdsm_name}/network/*/*/*.py*

%files python
%{_mandir}/man1/vdsm-tool.1*
%{_bindir}/vdsm-tool
%dir %{python_sitelib}/%{vdsm_name}/gluster
%dir %{python_sitelib}/%{vdsm_name}/host
%dir %{python_sitelib}/%{vdsm_name}/metrics
%dir %{python_sitelib}/%{vdsm_name}/tool
%dir %{python_sitelib}/%{vdsm_name}/tool/configurators
%dir %{python_sitelib}/%{vdsm_name}/profiling
%dir %{python_sitelib}/%{vdsm_name}/storage
%dir %{python_sitelib}/%{vdsm_name}/supervdsm_api
%dir %{python_sitelib}/%{vdsm_name}/virt
%dir %{python_sitelib}/%{vdsm_name}/virt/vmdevices
%{python_sitelib}/%{vdsm_name}/alignmentScan.py*
%{python_sitelib}/%{vdsm_name}/API.py*
%{python_sitelib}/%{vdsm_name}/client.py*
%{python_sitelib}/%{vdsm_name}/clientIF.py*
%{python_sitelib}/%{vdsm_name}/hook/*.py*
%{python_sitelib}/%{vdsm_name}/host/*.py*
%{python_sitelib}/%{vdsm_name}/config.py*
%{python_sitelib}/%{vdsm_name}/constants.py*
%{python_sitelib}/%{vdsm_name}/cpuinfo.py*
%{python_sitelib}/%{vdsm_name}/dmidecodeUtil.py*
%{python_sitelib}/%{vdsm_name}/executor.py*
# gluster.exception is used in many places like Bridge.py. So it is required
# even without vdsm-gluster package
%{python_sitelib}/%{vdsm_name}/gluster/__init__.py*
%{python_sitelib}/%{vdsm_name}/gluster/cli.py*
%{python_sitelib}/%{vdsm_name}/gluster/exception.py*
%{python_sitelib}/%{vdsm_name}/health.py*
%{python_sitelib}/%{vdsm_name}/hugepages.py*
%{python_sitelib}/%{vdsm_name}/jobs.py*
%{python_sitelib}/%{vdsm_name}/jsonrpcvdscli.py*
%{python_sitelib}/%{vdsm_name}/kvm2ovirt.py*
%{python_sitelib}/%{vdsm_name}/logUtils.py*
%{python_sitelib}/%{vdsm_name}/machinetype.py*
%{python_sitelib}/%{vdsm_name}/metrics/*.py*
%{python_sitelib}/%{vdsm_name}/moduleloader.py*
%{python_sitelib}/%{vdsm_name}/momIF.py*
%{python_sitelib}/%{vdsm_name}/mkimage.py*
%{python_sitelib}/%{vdsm_name}/numa.py*
%{python_sitelib}/%{vdsm_name}/osinfo.py*
%{python_sitelib}/%{vdsm_name}/ppc64HardwareInfo.py*
%{python_sitelib}/%{vdsm_name}/profiling/__init__.py*
%{python_sitelib}/%{vdsm_name}/profiling/cpu.py*
%{python_sitelib}/%{vdsm_name}/profiling/errors.py*
%{python_sitelib}/%{vdsm_name}/profiling/memory.py*
%{python_sitelib}/%{vdsm_name}/profiling/profile.py*
%{python_sitelib}/%{vdsm_name}/storage/__init__.py*
%{python_sitelib}/%{vdsm_name}/storage/asyncevent.py*
%{python_sitelib}/%{vdsm_name}/storage/asyncutils.py*
%{python_sitelib}/%{vdsm_name}/storage/backends.py*
%{python_sitelib}/%{vdsm_name}/storage/blkdiscard.py*
%{python_sitelib}/%{vdsm_name}/storage/blockdev.py*
%{python_sitelib}/%{vdsm_name}/storage/blockSD.py*
%{python_sitelib}/%{vdsm_name}/storage/blockVolume.py*
%{python_sitelib}/%{vdsm_name}/storage/check.py*
%{python_sitelib}/%{vdsm_name}/storage/clusterlock.py*
%{python_sitelib}/%{vdsm_name}/storage/compat.py*
%{python_sitelib}/%{vdsm_name}/storage/constants.py*
%{python_sitelib}/%{vdsm_name}/storage/curlImgWrap.py*
%{python_sitelib}/%{vdsm_name}/storage/devicemapper.py*
%{python_sitelib}/%{vdsm_name}/storage/directio.py*
%{python_sitelib}/%{vdsm_name}/storage/dispatcher.py*
%{python_sitelib}/%{vdsm_name}/storage/exception.py*
%{python_sitelib}/%{vdsm_name}/storage/fallocate.py*
%{python_sitelib}/%{vdsm_name}/storage/fileSD.py*
%{python_sitelib}/%{vdsm_name}/storage/fileUtils.py*
%{python_sitelib}/%{vdsm_name}/storage/fileVolume.py*
%{python_sitelib}/%{vdsm_name}/storage/formatconverter.py*
%{python_sitelib}/%{vdsm_name}/storage/fuser.py*
%{python_sitelib}/%{vdsm_name}/storage/fsutils.py*
%{python_sitelib}/%{vdsm_name}/storage/glusterSD.py*
%{python_sitelib}/%{vdsm_name}/storage/glusterVolume.py*
%{python_sitelib}/%{vdsm_name}/storage/guarded.py*
%{python_sitelib}/%{vdsm_name}/storage/hba.py*
%{python_sitelib}/%{vdsm_name}/storage/hsm.py*
%{python_sitelib}/%{vdsm_name}/storage/image.py*
%{python_sitelib}/%{vdsm_name}/storage/imageSharing.py*
%{python_sitelib}/%{vdsm_name}/storage/imagetickets.py*
%{python_sitelib}/%{vdsm_name}/storage/iscsi.py*
%{python_sitelib}/%{vdsm_name}/storage/iscsiadm.py*
%{python_sitelib}/%{vdsm_name}/storage/localFsSD.py*
%{python_sitelib}/%{vdsm_name}/storage/lvm.env
%{python_sitelib}/%{vdsm_name}/storage/lvm.py*
%{python_sitelib}/%{vdsm_name}/storage/lvmconf.py*
%{python_sitelib}/%{vdsm_name}/storage/lvmfilter.py*
%{python_sitelib}/%{vdsm_name}/storage/mailbox.py*
%{python_sitelib}/%{vdsm_name}/storage/managedvolume.py*
%{python_sitelib}/%{vdsm_name}/storage/managedvolumedb.py*
%{python_sitelib}/%{vdsm_name}/storage/merge.py*
%{python_sitelib}/%{vdsm_name}/storage/misc.py*
%{python_sitelib}/%{vdsm_name}/storage/monitor.py*
%{python_sitelib}/%{vdsm_name}/storage/mount.py*
%{python_sitelib}/%{vdsm_name}/storage/mpathhealth.py*
%{python_sitelib}/%{vdsm_name}/storage/multipath.py*
%{python_sitelib}/%{vdsm_name}/storage/nbd.py*
%{python_sitelib}/%{vdsm_name}/storage/nfsSD.py*
%{python_sitelib}/%{vdsm_name}/storage/nos_brick.py*
%{python_sitelib}/%{vdsm_name}/storage/operation.py*
%{python_sitelib}/%{vdsm_name}/storage/outOfProcess.py*
%{python_sitelib}/%{vdsm_name}/storage/persistent.py*
%{python_sitelib}/%{vdsm_name}/storage/qemuimg.py*
%{python_sitelib}/%{vdsm_name}/storage/resourceFactories.py*
%{python_sitelib}/%{vdsm_name}/storage/resourceManager.py*
%{python_sitelib}/%{vdsm_name}/storage/rwlock.py*
%{python_sitelib}/%{vdsm_name}/storage/sd.py*
%{python_sitelib}/%{vdsm_name}/storage/sdc.py*
%{python_sitelib}/%{vdsm_name}/storage/securable.py*
%{python_sitelib}/%{vdsm_name}/storage/sp.py*
%{python_sitelib}/%{vdsm_name}/storage/spbackends.py*
%{python_sitelib}/%{vdsm_name}/storage/storageServer.py*
%{python_sitelib}/%{vdsm_name}/storage/sysfs.py*
%{python_sitelib}/%{vdsm_name}/storage/task.py*
%{python_sitelib}/%{vdsm_name}/storage/taskManager.py*
%{python_sitelib}/%{vdsm_name}/storage/threadPool.py*
%{python_sitelib}/%{vdsm_name}/storage/types.py*
%{python_sitelib}/%{vdsm_name}/storage/udev.py*
%{python_sitelib}/%{vdsm_name}/storage/volume.py*
%{python_sitelib}/%{vdsm_name}/storage/volumemetadata.py*
%{python_sitelib}/%{vdsm_name}/storage/workarounds.py*
%{python_sitelib}/%{vdsm_name}/storage/xlease.py*
%{python_sitelib}/%{vdsm_name}/storage/sdm/__init__.py*
%{python_sitelib}/%{vdsm_name}/storage/sdm/volume_info.py*
%{python_sitelib}/%{vdsm_name}/storage/sdm/api/__init__.py*
%{python_sitelib}/%{vdsm_name}/storage/sdm/api/amend_volume.py*
%{python_sitelib}/%{vdsm_name}/storage/sdm/api/base.py*
%{python_sitelib}/%{vdsm_name}/storage/sdm/api/copy_data.py*
%{python_sitelib}/%{vdsm_name}/storage/sdm/api/merge.py*
%{python_sitelib}/%{vdsm_name}/storage/sdm/api/move_device.py*
%{python_sitelib}/%{vdsm_name}/storage/sdm/api/reduce_domain.py*
%{python_sitelib}/%{vdsm_name}/storage/sdm/api/sparsify_volume.py*
%{python_sitelib}/%{vdsm_name}/storage/sdm/api/update_volume.py*
%{python_sitelib}/%{vdsm_name}/supervdsm_api/__init__.py*
%{python_sitelib}/%{vdsm_name}/supervdsm_api/managedvolume.py*
%{python_sitelib}/%{vdsm_name}/supervdsm_api/hwinfo.py*
%{python_sitelib}/%{vdsm_name}/supervdsm_api/mkimage.py*
%{python_sitelib}/%{vdsm_name}/supervdsm_api/ksm.py*
%{python_sitelib}/%{vdsm_name}/supervdsm_api/nbd.py*
%{python_sitelib}/%{vdsm_name}/supervdsm_api/network.py*
%{python_sitelib}/%{vdsm_name}/supervdsm_api/saslpasswd2.py*
%{python_sitelib}/%{vdsm_name}/supervdsm_api/systemctl.py*
%{python_sitelib}/%{vdsm_name}/supervdsm_api/test.py*
%{python_sitelib}/%{vdsm_name}/supervdsm_api/udev.py*
%{python_sitelib}/%{vdsm_name}/supervdsm_api/virt.py*
%{python_sitelib}/%{vdsm_name}/protocoldetector.py*
%{python_sitelib}/%{vdsm_name}/schedule.py*
%{python_sitelib}/%{vdsm_name}/sslutils.py*
%{python_sitelib}/%{vdsm_name}/supervdsm_server.py*
%{python_sitelib}/%{vdsm_name}/taskset.py*
%{python_sitelib}/%{vdsm_name}/throttledlog.py*
%{python_sitelib}/%{vdsm_name}/utils.py*
%{python_sitelib}/%{vdsm_name}/v2v.py*
%{python_sitelib}/%{vdsm_name}/vdsmd.py*
%{python_sitelib}/%{vdsm_name}/virtsparsify.py*
%{python_sitelib}/%{vdsm_name}/virtsysprep.py*
%{python_sitelib}/%{vdsm_name}/tool/__init__.py*
%{python_sitelib}/%{vdsm_name}/tool/common.py*
%{python_sitelib}/%{vdsm_name}/tool/check_volume_leases.py*
%{python_sitelib}/%{vdsm_name}/tool/config_lvm_filter.py*
%{python_sitelib}/%{vdsm_name}/tool/configfile.py*
%{python_sitelib}/%{vdsm_name}/tool/confmeta.py*
%{python_sitelib}/%{vdsm_name}/tool/confutils.py*
%{python_sitelib}/%{vdsm_name}/tool/dummybr.py*
%{python_sitelib}/%{vdsm_name}/tool/nwfilter.py*
%{python_sitelib}/%{vdsm_name}/tool/configurator.py*
%{python_sitelib}/%{vdsm_name}/tool/configurators/__init__*
%{python_sitelib}/%{vdsm_name}/tool/configurators/abrt.py*
%{python_sitelib}/%{vdsm_name}/tool/configurators/bond_defaults.py*
%{python_sitelib}/%{vdsm_name}/tool/configurators/certificates.py*
%{python_sitelib}/%{vdsm_name}/tool/configurators/libvirt.py*
%{python_sitelib}/%{vdsm_name}/tool/configurators/lvm.py*
%{python_sitelib}/%{vdsm_name}/tool/configurators/managedvolumedb.py*
%{python_sitelib}/%{vdsm_name}/tool/configurators/multipath.py*
%{python_sitelib}/%{vdsm_name}/tool/configurators/passwd.py*
%{python_sitelib}/%{vdsm_name}/tool/configurators/sanlock.py*
%{python_sitelib}/%{vdsm_name}/tool/configurators/sebool.py*
%{python_sitelib}/%{vdsm_name}/tool/dump_volume_chains.py*
%{python_sitelib}/%{vdsm_name}/tool/network.py*
%{python_sitelib}/%{vdsm_name}/tool/register.py*
%{python_sitelib}/%{vdsm_name}/tool/service.py*
%{python_sitelib}/%{vdsm_name}/tool/transient.py*
%{python_sitelib}/%{vdsm_name}/tool/upgrade.py*
%{python_sitelib}/%{vdsm_name}/tool/vdsm-id.py*
%{python_sitelib}/%{vdsm_name}/tool/xleases.py*
%{python_sitelib}/%{vdsm_name}/virt/__init__.py*
%{python_sitelib}/%{vdsm_name}/virt/collectd.py*
%{python_sitelib}/%{vdsm_name}/virt/displaynetwork.py*
%{python_sitelib}/%{vdsm_name}/virt/drivemonitor.py*
%{python_sitelib}/%{vdsm_name}/virt/domain_descriptor.py*
%{python_sitelib}/%{vdsm_name}/virt/domxml_preprocess.py*
%{python_sitelib}/%{vdsm_name}/virt/events.py*
%{python_sitelib}/%{vdsm_name}/virt/guestagent.py*
%{python_sitelib}/%{vdsm_name}/virt/guestagenthelpers.py*
%{python_sitelib}/%{vdsm_name}/virt/libvirtnetwork.py*
%{python_sitelib}/%{vdsm_name}/virt/libvirtxml.py*
%{python_sitelib}/%{vdsm_name}/virt/metadata.py*
%{python_sitelib}/%{vdsm_name}/virt/migration.py*
%{python_sitelib}/%{vdsm_name}/virt/periodic.py*
%{python_sitelib}/%{vdsm_name}/virt/qemuguestagent.py*
%{python_sitelib}/%{vdsm_name}/virt/recovery.py*
%{python_sitelib}/%{vdsm_name}/virt/sampling.py*
%{python_sitelib}/%{vdsm_name}/virt/saslpasswd2.py*
%{python_sitelib}/%{vdsm_name}/virt/secret.py*
%{python_sitelib}/%{vdsm_name}/virt/utils.py*
%{python_sitelib}/%{vdsm_name}/virt/virdomain.py*
%{python_sitelib}/%{vdsm_name}/virt/vm.py*
%{python_sitelib}/%{vdsm_name}/virt/jobs/__init__.py*
%{python_sitelib}/%{vdsm_name}/virt/jobs/seal.py*
%{python_sitelib}/%{vdsm_name}/virt/vmdevices/__init__.py*
%{python_sitelib}/%{vdsm_name}/virt/vmdevices/common.py*
%{python_sitelib}/%{vdsm_name}/virt/vmdevices/compat.py*
%{python_sitelib}/%{vdsm_name}/virt/vmdevices/core.py*
%{python_sitelib}/%{vdsm_name}/virt/vmdevices/drivename.py*
%{python_sitelib}/%{vdsm_name}/virt/vmdevices/graphics.py*
%{python_sitelib}/%{vdsm_name}/virt/vmdevices/hostdevice.py*
%{python_sitelib}/%{vdsm_name}/virt/vmdevices/hwclass.py*
%{python_sitelib}/%{vdsm_name}/virt/vmdevices/lease.py*
%{python_sitelib}/%{vdsm_name}/virt/vmdevices/lookup.py*
%{python_sitelib}/%{vdsm_name}/virt/vmdevices/network.py*
%{python_sitelib}/%{vdsm_name}/virt/vmdevices/storage.py*
%{python_sitelib}/%{vdsm_name}/virt/vmdevices/storagexml.py*
%{python_sitelib}/%{vdsm_name}/virt/vmchannels.py*
%{python_sitelib}/%{vdsm_name}/virt/vmexitreason.py*
%{python_sitelib}/%{vdsm_name}/virt/vmpowerdown.py*
%{python_sitelib}/%{vdsm_name}/virt/vmstats.py*
%{python_sitelib}/%{vdsm_name}/virt/vmstatus.py*
%{python_sitelib}/%{vdsm_name}/virt/vmtune.py*
%{python_sitelib}/%{vdsm_name}/virt/vmxml.py*
%{python_sitelib}/%{vdsm_name}/virt/xmlconstants.py*

%files tests
%doc %{_datadir}/%{vdsm_name}/tests/README
%dir %{_datadir}/%{vdsm_name}
%dir %{_datadir}/%{vdsm_name}/tests
%dir %{_datadir}/%{vdsm_name}/tests/common
%dir %{_datadir}/%{vdsm_name}/tests/cpuinfo
%dir %{_datadir}/%{vdsm_name}/tests/functional
%dir %{_datadir}/%{vdsm_name}/tests/devices
%dir %{_datadir}/%{vdsm_name}/tests/devices/data
%dir %{_datadir}/%{vdsm_name}/tests/devices/parsing
%dir %{_datadir}/%{vdsm_name}/tests/integration
%dir %{_datadir}/%{vdsm_name}/tests/network
%dir %{_datadir}/%{vdsm_name}/tests/network/functional
%dir %{_datadir}/%{vdsm_name}/tests/network/integration
%dir %{_datadir}/%{vdsm_name}/tests/network/integration/ovs
%dir %{_datadir}/%{vdsm_name}/tests/network/unit
%dir %{_datadir}/%{vdsm_name}/tests/network/unit/ovs
%dir %{_datadir}/%{vdsm_name}/tests/network/static
%dir %{_datadir}/%{vdsm_name}/tests/storage
%{_datadir}/%{vdsm_name}/tests/*.py*
%{_datadir}/%{vdsm_name}/tests/cpu_info.out
%{_datadir}/%{vdsm_name}/tests/caps_libvirt_intel_E5649.out
%{_datadir}/%{vdsm_name}/tests/caps_libvirt_amd_6274.out
%{_datadir}/%{vdsm_name}/tests/caps_libvirt_ibm_S822L.out
%{_datadir}/%{vdsm_name}/tests/caps_libvirt_ibm_S822L_le.out
%{_datadir}/%{vdsm_name}/tests/caps_libvirt_intel_E31220.out
%{_datadir}/%{vdsm_name}/tests/caps_libvirt_intel_E5606.out
%{_datadir}/%{vdsm_name}/tests/caps_libvirt_intel_i73770.out
%{_datadir}/%{vdsm_name}/tests/caps_libvirt_intel_i73770_nosnap.out
%{_datadir}/%{vdsm_name}/tests/caps_libvirt_multiqemu.out
%{_datadir}/%{vdsm_name}/tests/caps_libvirt_s390x.out
%{_datadir}/%{vdsm_name}/tests/caps_numactl_4_nodes.out
%{_datadir}/%{vdsm_name}/tests/domcaps_libvirt_ppc64le.out
%{_datadir}/%{vdsm_name}/tests/domcaps_libvirt_s390x.out
%{_datadir}/%{vdsm_name}/tests/domcaps_libvirt_x86_64.out
%{_datadir}/%{vdsm_name}/tests/common/*.py*
%{_datadir}/%{vdsm_name}/tests/cpuinfo/*.out
%{_datadir}/%{vdsm_name}/tests/check_distpkg.sh
%{_datadir}/%{vdsm_name}/tests/check_rpms.sh
%{_datadir}/%{vdsm_name}/tests/fake-ssh-add
%{_datadir}/%{vdsm_name}/tests/fake-ssh-agent
%{_datadir}/%{vdsm_name}/tests/fake-virt-sysprep
%{_datadir}/%{vdsm_name}/tests/fake-virt-v2v
%{_datadir}/%{vdsm_name}/tests/fake-virt-v2v.out
%{_datadir}/%{vdsm_name}/tests/fake-virt-v2v.err
%{_datadir}/%{vdsm_name}/tests/devices/*.py*
%{_datadir}/%{vdsm_name}/tests/devices/parsing/*.py*
%{_datadir}/%{vdsm_name}/tests/devices/data/*.xml
%{_datadir}/%{vdsm_name}/tests/mem_info.out
%{_datadir}/%{vdsm_name}/tests/network/*.py*
%{_datadir}/%{vdsm_name}/tests/network/netmaskconversions
%{_datadir}/%{vdsm_name}/tests/network/tc_filter_show.out
%{_datadir}/%{vdsm_name}/tests/network/functional/*.py*
%{_datadir}/%{vdsm_name}/tests/network/integration/*.py*
%{_datadir}/%{vdsm_name}/tests/network/integration/ovs/*.py*
%{_datadir}/%{vdsm_name}/tests/network/unit/*.py*
%{_datadir}/%{vdsm_name}/tests/network/unit/ovs/*.py*
%{_datadir}/%{vdsm_name}/tests/network/static/*.json
%{_datadir}/%{vdsm_name}/tests/network/static/ip_route_show_table_all.out
%{_datadir}/%{vdsm_name}/tests/storage/*.py*
%{_datadir}/%{vdsm_name}/tests/storage/*.out
%{_datadir}/%{vdsm_name}/tests/virt/*.py*
%{_datadir}/%{vdsm_name}/tests/virt/data/*.xml
%{_datadir}/%{vdsm_name}/tests/run_tests.sh
%{_datadir}/%{vdsm_name}/tests/toolTests_abrt-action-save-package-data.conf
%{_datadir}/%{vdsm_name}/tests/toolTests_CCPP.conf
%{_datadir}/%{vdsm_name}/tests/toolTests_abrt.conf
%{_datadir}/%{vdsm_name}/tests/toolTests_empty.conf
%{_datadir}/%{vdsm_name}/tests/toolTests_lconf_ssl.conf
%{_datadir}/%{vdsm_name}/tests/toolTests_libvirtd.conf
%{_datadir}/%{vdsm_name}/tests/toolTests_mtab_1g
%{_datadir}/%{vdsm_name}/tests/toolTests_mtab_default
%{_datadir}/%{vdsm_name}/tests/toolTests_mtab_nohugetlbfs
%{_datadir}/%{vdsm_name}/tests/toolTests_qemu_sanlock.conf
%{_datadir}/%{vdsm_name}/tests/toolTests_qemu_ssl.conf
%{_datadir}/%{vdsm_name}/tests/toolTests_vdsm_no_ssl.conf
%{_datadir}/%{vdsm_name}/tests/toolTests_vdsm_ssl.conf
%{_datadir}/%{vdsm_name}/tests/toolTests_vmcore.conf
%{_datadir}/%{vdsm_name}/tests/glusterGeoRepStatus.xml
%{_datadir}/%{vdsm_name}/tests/glusterVolumeGeoRepConfigList.xml
%{_datadir}/%{vdsm_name}/tests/glusterSnapshotList.xml
%{_datadir}/%{vdsm_name}/tests/glusterSnapshotListEmpty.xml
%{_datadir}/%{vdsm_name}/tests/glusterVolumeProfileInfo.xml
%{_datadir}/%{vdsm_name}/tests/glusterSnapshotConfig.xml
%{_datadir}/%{vdsm_name}/tests/glusterVolumeProfileInfoNfs.xml
%{_datadir}/%{vdsm_name}/tests/glusterVolumeRebalanceStatus.xml
%{_datadir}/%{vdsm_name}/tests/glusterVolumeRemoveBricksStatus.xml
%{_datadir}/%{vdsm_name}/tests/glusterSnapshotRestore.xml
%{_datadir}/%{vdsm_name}/tests/glusterVolumeSnapshotList.xml
%{_datadir}/%{vdsm_name}/tests/glusterVolumeSnapshotListEmpty.xml
%{_datadir}/%{vdsm_name}/tests/glusterVolumeTasks.xml
%{_datadir}/%{vdsm_name}/tests/glusterVolumeHealInfo.xml
%{_datadir}/%{vdsm_name}/tests/functional/*.py*
%{_datadir}/%{vdsm_name}/tests/functional/*.policy
%{_datadir}/%{vdsm_name}/tests/integration/*.py*

%files hook-openstacknet
%{_sysconfdir}/sudoers.d/50_vdsm_hook_openstacknet
%{_libexecdir}/%{vdsm_name}/hooks/after_device_create/50_openstacknet
%{_libexecdir}/%{vdsm_name}/hooks/after_device_create/openstacknet_utils.py*
%{_libexecdir}/%{vdsm_name}/hooks/after_device_migrate_destination/50_openstacknet
%{_libexecdir}/%{vdsm_name}/hooks/after_device_migrate_destination/openstacknet_utils.py*
%{_libexecdir}/%{vdsm_name}/hooks/after_nic_hotplug/50_openstacknet
%{_libexecdir}/%{vdsm_name}/hooks/after_nic_hotplug/openstacknet_utils.py*
%{_libexecdir}/%{vdsm_name}/hooks/after_vm_start/50_openstacknet
%{_libexecdir}/%{vdsm_name}/hooks/after_vm_start/openstacknet_utils.py*
%{_libexecdir}/%{vdsm_name}/hooks/before_device_create/50_openstacknet
%{_libexecdir}/%{vdsm_name}/hooks/before_device_create/openstacknet_utils.py*
%{_libexecdir}/%{vdsm_name}/hooks/before_nic_hotplug/50_openstacknet
%{_libexecdir}/%{vdsm_name}/hooks/before_nic_hotplug/openstacknet_utils.py*
%{_libexecdir}/%{vdsm_name}/hooks/after_get_caps/50_openstacknet
%{_libexecdir}/%{vdsm_name}/hooks/after_get_caps/openstacknet_utils.py*

%files hook-macspoof
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_macspoof
%{_libexecdir}/%{vdsm_name}/hooks/before_device_create/50_macspoof
%{_libexecdir}/%{vdsm_name}/hooks/before_nic_hotplug/50_macspoof

%if 0%{?with_vhostmd}
%files hook-vhostmd
%license COPYING
%{_sysconfdir}/sudoers.d/50_vdsm_hook_vhostmd
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_vhostmd
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_migrate_destination/50_vhostmd
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_dehibernate/50_vhostmd
%{_libexecdir}/%{vdsm_name}/hooks/after_vm_destroy/50_vhostmd
%else
%exclude %{_sysconfdir}/sudoers.d/50_vdsm_hook_vhostmd
%exclude %{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_vhostmd
%exclude %{_libexecdir}/%{vdsm_name}/hooks/before_vm_migrate_destination/50_vhostmd
%exclude %{_libexecdir}/%{vdsm_name}/hooks/before_vm_dehibernate/50_vhostmd
%exclude %{_libexecdir}/%{vdsm_name}/hooks/after_vm_destroy/50_vhostmd
%endif

%files hook-qemucmdline
%license COPYING
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_qemucmdline

%files hook-ethtool-options
%{_libexecdir}/%{vdsm_name}/hooks/after_network_setup/30_ethtool_options

%files hook-fcoe
%{_presetdir}/85-vdsm-hook-fcoe.preset
%{_libexecdir}/%{vdsm_name}/hooks/before_network_setup/50_fcoe

%files hook-localdisk
%{_sysconfdir}/sudoers.d/50_vdsm_hook_localdisk
%{_libexecdir}/%{vdsm_name}/hooks/after_disk_prepare/localdisk
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_migrate_source/localdisk
%{_libexecdir}/%{vdsm_name}/localdisk-helper
%{_udevrulesdir}/12-vdsm-localdisk.rules

%files hook-vmfex-dev
%{_libexecdir}/%{vdsm_name}/hooks/before_device_create/50_vmfex
%{_libexecdir}/%{vdsm_name}/hooks/before_device_migrate_destination/50_vmfex
%{_libexecdir}/%{vdsm_name}/hooks/before_nic_hotplug/50_vmfex

%files hook-cpuflags
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_cpuflags

%files hook-hostdev-scsi
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_hostdev_scsi

%if 0%{?with_hooks}
%files hook-allocate_net
%{_libexecdir}/%{vdsm_name}/hooks/before_device_create/10_allocate_net

%files hook-boot_hostdev
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_boot_hostdev

%files hook-checkimages
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/60_checkimages

%files hook-checkips
%{_libexecdir}/%{vdsm_name}/hooks/after_get_stats/10_checkips
%{_libexecdir}/%{vdsm_name}/hooks/checkipsd
%{_libexecdir}/%{vdsm_name}/hooks/after_get_stats/checkips_utils.py*
%{_unitdir}/vdsm-checkips.service

%files hook-extra-ipv4-addrs
%{_libexecdir}/%{vdsm_name}/hooks/after_network_setup/40_extra_ipv4_addrs

%files hook-diskunmap
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_diskunmap

%files hook-fakevmstats
%{_libexecdir}/%{vdsm_name}/hooks/after_get_all_vm_stats/10_fakevmstats

%files hook-fileinject
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_fileinject

%files hook-floppy
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_floppy
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_migrate_source/50_floppy

%files hook-httpsisoboot
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_httpsisoboot

%files hook-macbind
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_macbind

%files hook-extnet
%{_libexecdir}/%{vdsm_name}/hooks/before_device_create/50_extnet
%{_libexecdir}/%{vdsm_name}/hooks/before_nic_hotplug/50_extnet

%files hook-nestedvt
%{_sysconfdir}/modprobe.d/vdsm-nestedvt.conf
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_nestedvt

%files hook-numa
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_numa

%files hook-pincpu
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_pincpu

%files hook-promisc
%{_sysconfdir}/sudoers.d/50_vdsm_hook_promisc
%{_libexecdir}/%{vdsm_name}/hooks/after_vm_start/50_promisc
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_destroy/50_promisc

%files hook-scratchpad
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_scratchpad
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_migrate_source/50_scratchpad
%{_libexecdir}/%{vdsm_name}/hooks/after_vm_destroy/50_scratchpad

%files hook-smbios
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_smbios

%files hook-spiceoptions
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_spiceoptions

%files hook-vmdisk
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_vmdisk
%endif

%files http
%dir %{python_sitelib}/%{vdsm_name}
%dir %{python_sitelib}/%{vdsm_name}/rpc
%{python_sitelib}/%{vdsm_name}/rpc/http.py*

%files client
%{_bindir}/vdsm-client
%dir %{python_sitelib}/vdsmclient
%{python_sitelib}/vdsmclient/__init__.py*
%{python_sitelib}/vdsmclient/client.py*
%{python_sitelib}/yajsonrpc/__init__.py*
%{_mandir}/man1/vdsm-client.1*

%files jsonrpc
%dir %{python_sitelib}/%{vdsm_name}
%dir %{python_sitelib}/%{vdsm_name}/rpc
%{python_sitelib}/%{vdsm_name}/rpc/__init__.py*
%{python_sitelib}/%{vdsm_name}/rpc/bindingjsonrpc.py*
%{python_sitelib}/%{vdsm_name}/rpc/Bridge.py*
%{python_sitelib}/yajsonrpc/__init__.py*
%{python_sitelib}/yajsonrpc/jsonrpcclient.py*

%files api
%doc lib/vdsm/api/vdsm-api.html
%dir %{python_sitelib}/%{vdsm_name}
%dir %{python_sitelib}/%{vdsm_name}/api
%dir %{python_sitelib}/%{vdsm_name}/rpc
%{python_sitelib}/%{vdsm_name}/api/*.py*
%{python_sitelib}/%{vdsm_name}/rpc/vdsm-api.pickle
%{python_sitelib}/%{vdsm_name}/rpc/vdsm-events.pickle
%if ! 0%{?with_gluster_mgmt}
%exclude %{python_sitelib}/%{vdsm_name}/rpc/vdsm-api-gluster.pickle
%endif

%files yajsonrpc
%dir %{python_sitelib}/yajsonrpc
%{python_sitelib}/yajsonrpc/betterAsyncore.py*
%{python_sitelib}/yajsonrpc/exception.py*
%{python_sitelib}/yajsonrpc/stomp.py*
%{python_sitelib}/yajsonrpc/stompclient.py*
%{python_sitelib}/yajsonrpc/stompserver.py*

%files hook-faqemu
%license COPYING
%{_libexecdir}/%{vdsm_name}/hooks/after_get_caps/10_faqemu
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/10_faqemu

%if 0%{?with_gluster_mgmt}
%files gluster
%license COPYING
%dir %{python_sitelib}/%{vdsm_name}
%dir %{python_sitelib}/%{vdsm_name}/rpc
%dir %{python_sitelib}/%{vdsm_name}/gluster
%{python_sitelib}/%{vdsm_name}/gluster/api.py*
%{python_sitelib}/%{vdsm_name}/gluster/apiwrapper.py*
%{python_sitelib}/%{vdsm_name}/gluster/events.py*
%{python_sitelib}/%{vdsm_name}/gluster/fstab.py*
%{python_sitelib}/%{vdsm_name}/gluster/fence.py*
%{python_sitelib}/%{vdsm_name}/gluster/gfapi.py*
%{python_sitelib}/%{vdsm_name}/gluster/hooks.py*
%{python_sitelib}/%{vdsm_name}/gluster/services.py*
%{python_sitelib}/%{vdsm_name}/gluster/storagedev.py*
%{python_sitelib}/%{vdsm_name}/gluster/tasks.py*
%{python_sitelib}/%{vdsm_name}/gluster/thinstorage.py*
%{python_sitelib}/%{vdsm_name}/rpc/vdsm-api-gluster.pickle
%endif

%changelog
* Tue Dec 3 2019 Milan Zamazal <mzamazal@redhat.com> - 4.30.39
- See %{_docdir}/%{vdsm_name}/ChangeLog for the complete list of Vdsm changes.
