#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#

%if 0%{?fedora} || 0%{?rhel} >= 8
%global		with_python3 1
%global		__python_bin %{__python3}
%global		__python_sitelib %{python3_sitelib}
%else
%global		__python_bin %{__python2}
%global		__python_sitelib %{python2_sitelib}
%endif

%global		package_version 4.3.2

Summary:	Log Collector for oVirt Engine
Name:		ovirt-log-collector
Version:	4.3.2
Release:	1%{?release_suffix}%{?dist}
License:	ASL 2.0
URL:		http://www.ovirt.org
Source0:	http://resources.ovirt.org/pub/src/%{name}/%{name}-%{package_version}.tar.gz

BuildArch:	noarch

Requires:	logrotate
Requires:	openssh-clients
Requires:	sos >= 3.3
BuildRequires:	gettext

%if 0%{?with_python3}
Requires:	python3
Requires:	python3-dateutil
Requires:	python3-lxml
Requires:	python3-ovirt-engine-sdk4 >= 4.2.0
Requires:	python%{python3_pkgversion}-ovirt-engine-lib
BuildRequires:	python3-devel
%else
Requires:	python
Requires:	python-dateutil
Requires:	python-lxml
Requires:	python-ovirt-engine-sdk4 >= 4.2.0
Requires:	python2-ovirt-engine-lib
BuildRequires:	python2-devel
%endif

%description
Log Collector tool for oVirt Engine

%prep
%setup -q -n %{name}-%{package_version}

%build
%configure \
	--docdir="%{_docdir}/%{name}-%{version}" \
	--disable-python-syntax-check \
	PYTHON="%{__python_bin}"
make %{?_smp_mflags}

%check
make check

%install
rm -rf "%{buildroot}"
make %{?_smp_mflags} install DESTDIR="%{buildroot}"

%files
%doc AUTHORS
%license COPYING
%dir %{_localstatedir}/log/ovirt-engine/%{name}
%dir %{_sysconfdir}/ovirt-engine/logcollector.conf.d
%config(noreplace) %{_sysconfdir}/ovirt-engine/logcollector.conf
%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}
%{__python_sitelib}/ovirt_log_collector/
%{_bindir}/ovirt-log-collector
%{_mandir}/man8/ovirt-log-collector.8*

%changelog
* Tue Mar 26 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 4.3.2-1
- 4.3.2-1

* Fri Feb 15 2019 Douglas Schilling Landgraf <dougsland@redhat.com> - 4.3.1-1
- Require py3 packages on rhel8, minor spec cleaning
- main: fix pep8 / flake8 issues
- ovirt-log-collector: added --batch option for unattended mode
- man: fix location for logcollector.conf

* Thu Jan 10 2019 Douglas Schilling Landgraf <dougsland@redhat.com> - 4.3.0-1
- 4.3.0-1

* Wed Nov 29 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.2.0-1
- 4.2.0-1

* Thu May 25 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.2.0-0.0.master
- 4.2.0-0.0.master

* Thu Aug  4 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.0-0.0.master
- 4.1.0-0.0.master

* Wed Aug  5 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 4.0.0-0.0.master
- 4.0.0-0.0.master
