package org.ovirt.engine.core.common;

import java.util.HashMap;
import java.util.Map;

public enum AuditLogType {
    UNASSIGNED(0),
    // -- VDC Log types --
    VDC_START(1),

    VDC_STOP(2),
    // -- VDS Log types --
    VDS_FAILURE(12, AuditLogSeverity.ERROR), // When VDS changes status to up -> down or in VDC
    // initialization the VDS is down
    VDS_DETECTED(13), // When VDC initializes and detects a running VDS
    VDS_RECOVER(14), // When VDS changes status down->up
    VDS_SOFT_RECOVER(75), // Soft fencing was successful
    VDS_MAINTENANCE(15, AuditLogSeverity.NORMAL), // When VDS is transferred to maintenance mode
    VDS_ACTIVATE(16), // When VDS is reactivated
    VDS_ACTIVATE_MANUAL_HA(10454, AuditLogSeverity.WARNING), // When VDS is reactivated
    VDS_MAINTENANCE_FAILED(17, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.MINUTE.getValue()), // When VDS is transferred to maintenance mode
    VDS_ACTIVATE_FAILED(18, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.MINUTE.getValue()), // When VDS is reactivated
    VDS_RECOVER_FAILED(19, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.MINUTE.getValue()), // When VDS changes status down->up
    VDS_STATUS_CHANGE_FAILED_DUE_TO_STOP_SPM_FAILURE(27, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.MINUTE.getValue()),
    VDS_PROVISION(28, AuditLogSeverity.WARNING, AuditLogTimeInterval.MINUTE.getValue()),
    VDS_SLOW_STORAGE_RESPONSE_TIME(123, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.MINUTE.getValue() * 5), // ?
    VDS_ALREADY_IN_REQUESTED_STATUS(493, AuditLogSeverity.WARNING),
    VDS_MANUAL_FENCE_STATUS(494),
    VDS_AUTO_FENCE_STATUS(539),
    VDS_AUTO_FENCE_SKIPPED_DUE_TO_EXTERNAL_STATUS(423, AuditLogSeverity.WARNING),
    VDS_MANUAL_FENCE_STATUS_FAILED(495, AuditLogSeverity.ERROR),
    VDS_AUTO_FENCE_STATUS_FAILED(540, AuditLogSeverity.ERROR),
    VDS_MANUAL_FENCE_FAILED_CALL_FENCE_SPM(530, AuditLogSeverity.WARNING),
    VDS_AUTO_FENCE_FAILED_CALL_FENCE_SPM(541, AuditLogSeverity.WARNING),
    VDS_LOW_MEM(531, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.MINUTE.getValue() * 30),
    VDS_HIGH_MEM_USE(532, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.MINUTE.getValue() * 30),
    @Deprecated
    VDS_HIGH_NETWORK_USE(533, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.MINUTE.getValue() * 30),
    VDS_HIGH_CPU_USE(534, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.MINUTE.getValue() * 30),
    VDS_HIGH_SWAP_USE(535, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.MINUTE.getValue() * 30),
    VDS_LOW_SWAP(536, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.DAY.getValue()),
    VDS_FENCE_STATUS(496),
    VDS_FENCE_STATUS_FAILED(497, AuditLogSeverity.ERROR),
    VDS_APPROVE(498),
    VDS_APPROVE_FAILED(499, AuditLogSeverity.ERROR),
    VDS_FAILED_TO_RUN_VMS(500, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.MINUTE.getValue()),
    VDS_INSTALL(504),
    VDS_INSTALL_FAILED(505, AuditLogSeverity.ERROR),
    VDS_INITIATED_RUN_VM(506),
    VDS_INITIATED_RUN_VM_AS_STATELESS(537),
    VDS_INITIATED_RUN_VM_FAILED(507, AuditLogSeverity.ERROR, AuditLogTimeInterval.SECOND.getValue() * 5),
    VDS_INITIATED_RUN_AS_STATELESS_VM_NOT_YET_RUNNING(525),
    // VDS_INITIATED_RUN_VM_CHECKOUT_FAILED = 508,
    VDS_INSTALL_IN_PROGRESS(509),
    VDS_INSTALL_IN_PROGRESS_WARNING(510, AuditLogSeverity.WARNING),
    VDS_INSTALL_IN_PROGRESS_ERROR(511, AuditLogSeverity.ERROR),
    VDS_PACKAGES_IN_PROGRESS(550),
    VDS_PACKAGES_IN_PROGRESS_WARNING(551, AuditLogSeverity.WARNING),
    VDS_PACKAGES_IN_PROGRESS_ERROR(552, AuditLogSeverity.ERROR),

    // Ansible host execution
    VDS_ANSIBLE_INSTALL_STARTED(560),
    VDS_ANSIBLE_INSTALL_FINISHED(561),
    VDS_ANSIBLE_HOST_REMOVE_STARTED(562),
    VDS_ANSIBLE_HOST_REMOVE_FINISHED(563),
    VDS_ANSIBLE_HOST_REMOVE_FAILED(564, AuditLogSeverity.WARNING),
    VDS_ANSIBLE_HOST_REMOVE_EXECUTION_FAILED(565, AuditLogSeverity.ALERT),

    VDS_RECOVER_FAILED_VMS_UNKNOWN(513, AuditLogSeverity.ERROR),
    VDS_INITIALIZING(514, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.SECOND.getValue() * 30),
    VDS_CPU_LOWER_THAN_CLUSTER(515, AuditLogSeverity.WARNING),
    VDS_CPU_RETRIEVE_FAILED(516, AuditLogSeverity.WARNING),
    VDS_FAILED_TO_GET_HOST_HARDWARE_INFO(90, AuditLogSeverity.WARNING),
    @Deprecated
    VDS_STORAGE_CONNECTION_FAILED_BUT_LAST_VDS(187, AuditLogSeverity.ERROR),
    VDS_STORAGES_CONNECTION_FAILED(188, AuditLogSeverity.ERROR),
    VDS_STORAGE_VDS_STATS_FAILED(189, AuditLogSeverity.ERROR),
    VDS_SET_NONOPERATIONAL(517, AuditLogTimeInterval.MINUTE.getValue()),
    VDS_SET_NONOPERATIONAL_FAILED(518, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.MINUTE.getValue()),
    VDS_SET_NONOPERATIONAL_NETWORK(519, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.MINUTE.getValue()),
    VDS_SET_NONOPERATIONAL_IFACE_DOWN(603, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.MINUTE.getValue()),
    VDS_SET_NONOPERATIONAL_DOMAIN(522, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.MINUTE.getValue()),
    VDS_SET_NONOPERATIONAL_DOMAIN_FAILED(523, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.MINUTE.getValue()),
    VDS_DOMAIN_DELAY_INTERVAL(524, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.HOUR.getValue()),
    VDS_LOW_DISK_SPACE(23, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.HOUR.getValue()),
    VDS_LOW_DISK_SPACE_ERROR(24, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.MINUTE.getValue() * 15),
    VDS_NO_SELINUX_ENFORCEMENT(25, AuditLogSeverity.WARNING, AuditLogTimeInterval.HOUR.getValue()),
    USER_VDS_MAINTENANCE(600), // When VDS is transferred to
    USER_VDS_MAINTENANCE_WITHOUT_REASON(620),
    CPU_FLAGS_NX_IS_MISSING(601, AuditLogSeverity.WARNING),
    // maintenance mode
    USER_VDS_MAINTENANCE_MIGRATION_FAILED(602, AuditLogSeverity.WARNING),
    VDS_MAINTENANCE_MANUAL_HA(10452, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.MINUTE.getValue()),
    USER_VDS_MAINTENANCE_MANUAL_HA(10453, AuditLogSeverity.WARNING),

    SYSTEM_VDS_RESTART(121, AuditLogTimeInterval.MINUTE.getValue()),
    SYSTEM_FAILED_VDS_RESTART(122, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.MINUTE.getValue()),
    // SSH restart
    SYSTEM_SSH_HOST_RESTART(197, AuditLogTimeInterval.MINUTE.getValue()),
    SYSTEM_FAILED_SSH_HOST_RESTART(198, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.MINUTE.getValue()),

    // Host time drift Alert
    VDS_TIME_DRIFT_ALERT(604, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.MINUTE.getValue() * 60),

    // Proxy host selection
    PROXY_HOST_SELECTION(605),

    // Kdump detection
    FENCE_KDUMP_LISTENER_IS_NOT_ALIVE(613, AuditLogSeverity.ERROR),
    KDUMP_FLOW_DETECTED_ON_VDS(614),
    KDUMP_FLOW_NOT_DETECTED_ON_VDS(615),
    KDUMP_FLOW_FINISHED_ON_VDS(616),
    KDUMP_DETECTION_NOT_CONFIGURED_ON_VDS(617, AuditLogSeverity.WARNING),

    HOST_REFRESHED_CAPABILITIES(606),
    HOST_REFRESH_CAPABILITIES_FAILED(607, AuditLogSeverity.ERROR),

    HOST_INTERFACE_HIGH_NETWORK_USE(608, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.MINUTE.getValue() * 30),

    HOST_INTERFACE_STATE_UP(609, AuditLogSeverity.NORMAL),
    HOST_INTERFACE_STATE_DOWN(610, AuditLogSeverity.WARNING),
    HOST_BOND_SLAVE_STATE_UP(611, AuditLogSeverity.NORMAL),
    HOST_BOND_SLAVE_STATE_DOWN(612, AuditLogSeverity.WARNING),

    // Host Registration
    HOST_REGISTRATION_FAILED_INVALID_CLUSTER(618),

    HOST_PROTOCOL_INCOMPATIBLE_WITH_CLUSTER(619, AuditLogSeverity.WARNING),

    // Disk alignment audit logs - functionality was removed in 4.3
    @Deprecated
    DISK_ALIGNMENT_SCAN_START(700),
    @Deprecated
    DISK_ALIGNMENT_SCAN_FAILURE(701, AuditLogSeverity.WARNING),
    @Deprecated
    DISK_ALIGNMENT_SCAN_SUCCESS(702),

    // -- IRS Log types --
    IRS_FAILURE(22, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.HOUR.getValue() * 12),
    IRS_DISK_SPACE_LOW(26, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.HOUR.getValue() * 12),
    IRS_CONFIRMED_DISK_SPACE_LOW(1403, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.HOUR.getValue() * 12),
    IRS_DISK_SPACE_LOW_ERROR(201, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.MINUTE.getValue() * 15),
    IRS_HOSTED_ON_VDS(204),
    // -- USER Log types --
    USER_VDC_LOGIN(30, AuditLogTimeInterval.SECOND.getValue() * 5), // user logged in to VDC
    USER_VDC_LOGIN_FAILED(114, AuditLogSeverity.ERROR, AuditLogTimeInterval.SECOND.getValue() * 5), // user login failed
    USER_MAX_SESSIONS_EXCEEDED(4173, AuditLogSeverity.ERROR),
    USER_VDC_LOGOUT(31), // User logged out from VDC
    USER_VDC_LOGOUT_FAILED(815, AuditLogSeverity.ERROR), // User logged out failed
    USER_LOGIN_ON_BEHALF(1401, AuditLogTimeInterval.SECOND.getValue() * 5), // user logged in for vmconsole
    USER_LOGIN_ON_BEHALF_FAILED(1402, AuditLogSeverity.ERROR), // user login failed
    USER_VDC_SESSION_TERMINATED(831),
    USER_VDC_SESSION_TERMINATION_FAILED(832, AuditLogSeverity.ERROR),

    USER_INITIATED_RUN_VM(150),
    USER_INITIATED_RUN_VM_AND_PAUSE(179),
    USER_STARTED_VM(153),
    USER_INITIATED_RUN_VM_FAILED(151, AuditLogSeverity.WARNING),
    USER_RUN_VM(32), // User issued runVm command
    USER_RUN_VM_AS_STATELESS(538), // User issued runVm command in stateless mode
    USER_FAILED_RUN_VM(54, AuditLogSeverity.ERROR), // User issued runVm command
    USER_RUN_VM_AS_STATELESS_FINISHED_FAILURE(70, AuditLogSeverity.ERROR),
    USER_RUN_VM_AS_STATELESS_WITH_DISKS_NOT_ALLOWING_SNAPSHOT(171, AuditLogSeverity.WARNING),
    USER_RUN_VM_FAILURE_STATELESS_SNAPSHOT_LEFT(1001, AuditLogSeverity.ERROR),
    USER_RUN_VM_ON_NON_DEFAULT_VDS(152, AuditLogSeverity.WARNING),

    USER_REBOOT_VM(157),
    USER_FAILED_REBOOT_VM(158, AuditLogSeverity.ERROR),

    USER_STOP_VM(33), // User issued stopVm command
    USER_STOP_SUSPENDED_VM(111),
    USER_STOP_SUSPENDED_VM_FAILED(112, AuditLogSeverity.ERROR),
    VM_ALREADY_IN_REQUESTED_STATUS(254),
    USER_FAILED_STOP_VM(56, AuditLogSeverity.ERROR),
    USER_ADD_VM(34),
    USER_ADD_VM_STARTED(37),
    USER_ADD_VM_FINISHED_SUCCESS(53),
    USER_ADD_VM_FINISHED_FAILURE(60, AuditLogSeverity.ERROR),
    USER_FAILED_ADD_VM(57, AuditLogSeverity.ERROR),
    USER_UPDATE_VM(35),
    SYSTEM_UPDATE_VM(253),
    USER_FAILED_UPDATE_VM(58, AuditLogSeverity.ERROR),
    SYSTEM_FAILED_UPDATE_VM(252, AuditLogSeverity.ERROR),
    USER_UPDATE_VM_CLUSTER_DEFAULT_HOST_CLEARED(250),
    USER_REMOVE_VM_FINISHED(113),
    USER_REMOVE_VM_FINISHED_INTERNAL(1130),
    USER_REMOVE_VM_FINISHED_WITH_ILLEGAL_DISKS(172, AuditLogSeverity.WARNING),
    USER_REMOVE_VM_FINISHED_WITH_ILLEGAL_DISKS_INTERNAL(1720, AuditLogSeverity.WARNING),
    USER_ADD(149),
    @Deprecated
    USER_FAILED_REMOVE_VM(59, AuditLogSeverity.ERROR),
    USER_CHANGE_DISK_VM(38),
    USER_FAILED_CHANGE_DISK_VM(102, AuditLogSeverity.ERROR),
    @Deprecated
    USER_PAUSE_VM(39),
    @Deprecated
    USER_FAILED_PAUSE_VM(55, AuditLogSeverity.ERROR),
    USER_SUSPEND_VM(501),
    @Deprecated
    USER_SUSPEND_VM_FINISH_SUCCESS(512),
    USER_SUSPEND_VM_FINISH_FAILURE(521, AuditLogSeverity.ERROR),
    USER_SUSPEND_VM_FINISH_FAILURE_WILL_TRY_AGAIN(130, AuditLogSeverity.ERROR),
    USER_FAILED_SUSPEND_VM(502, AuditLogSeverity.ERROR),
    USER_SUSPEND_VM_OK(503),
    USER_RESUME_VM(40),
    USER_FAILED_RESUME_VM(103, AuditLogSeverity.ERROR),
    USER_INITIATED_SHUTDOWN_VM(73),
    USER_FAILED_SHUTDOWN_VM(74, AuditLogSeverity.ERROR),
    USER_STOPPED_VM_INSTEAD_OF_SHUTDOWN(76),
    USER_FAILED_STOPPING_VM_INSTEAD_OF_SHUTDOWN(77, AuditLogSeverity.ERROR),
    USER_ADD_DISK_TO_VM(78),
    USER_ADD_DISK_TO_VM_FINISHED_SUCCESS(97),
    USER_ADD_DISK_TO_VM_FINISHED_FAILURE(98, AuditLogSeverity.ERROR),
    USER_FAILED_ADD_DISK_TO_VM(79, AuditLogSeverity.ERROR),
    @Deprecated
    USER_REMOVE_DISK_FROM_VM(80),
    @Deprecated
    USER_FAILED_REMOVE_DISK_FROM_VM(81, AuditLogSeverity.ERROR),
    USER_UPDATE_VM_DISK(88),
    USER_FAILED_UPDATE_VM_DISK(89, AuditLogSeverity.ERROR),
    USER_HOTPLUG_DISK(2000),
    USER_FAILED_HOTPLUG_DISK(2001, AuditLogSeverity.ERROR),
    USER_HOTUNPLUG_DISK(2002),
    USER_FAILED_HOTUNPLUG_DISK(2003, AuditLogSeverity.ERROR),
    USER_COPIED_DISK(2004),
    USER_FAILED_COPY_DISK(2005, AuditLogSeverity.ERROR),
    USER_COPIED_DISK_FINISHED_SUCCESS(2006),
    USER_COPIED_DISK_FINISHED_FAILURE(2007, AuditLogSeverity.ERROR),
    USER_MOVED_DISK(2008),
    USER_FAILED_MOVED_VM_DISK(2009, AuditLogSeverity.ERROR),
    USER_MOVED_DISK_FINISHED_SUCCESS(2010),
    USER_MOVED_DISK_FINISHED_FAILURE(2011, AuditLogSeverity.ERROR),
    USER_FINISHED_REMOVE_DISK(2014),
    USER_FINISHED_REMOVE_DISK_ATTACHED_TO_VMS(2042),
    USER_FINISHED_FAILED_REMOVE_DISK(2015, AuditLogSeverity.WARNING),
    USER_FINISHED_REMOVE_DISK_NO_DOMAIN(2012),
    USER_FINISHED_REMOVE_DISK_ATTACHED_TO_VMS_NO_DOMAIN(2043),
    USER_FINISHED_FAILED_REMOVE_DISK_NO_DOMAIN(2013, AuditLogSeverity.WARNING),
    USER_ATTACH_DISK_TO_VM(2016),
    USER_FAILED_ATTACH_DISK_TO_VM(2017, AuditLogSeverity.ERROR),
    USER_DETACH_DISK_FROM_VM(2018),
    USER_FAILED_DETACH_DISK_FROM_VM(2019, AuditLogSeverity.ERROR),
    USER_ADD_DISK(2020),
    USER_ADD_DISK_FINISHED_SUCCESS(2021),
    USER_ADD_DISK_FINISHED_FAILURE(2022, AuditLogSeverity.ERROR),
    USER_FAILED_ADD_DISK(2023, AuditLogSeverity.ERROR),
    ADD_DISK_INTERNAL(2036),
    ADD_DISK_INTERNAL_FAILURE(2037),
    USER_REMOVE_DISK_INITIATED(2038),
    USER_REMOVE_DISK_ATTACHED_TO_VMS_INITIATED(2044),
    USER_IMPORT_IMAGE(2027),
    USER_IMPORT_IMAGE_AS_TEMPLATE(3017),
    USER_IMPORT_IMAGE_FINISHED_SUCCESS(2028),
    USER_IMPORT_IMAGE_AS_TEMPLATE_FINISHED_SUCCESS(3018),
    USER_IMPORT_IMAGE_FINISHED_FAILURE(2029, AuditLogSeverity.ERROR),
    USER_IMPORT_IMAGE_AS_TEMPLATE_FINISHED_FAILURE(3019, AuditLogSeverity.ERROR),
    USER_EXPORT_IMAGE(2030),
    USER_EXPORT_IMAGE_FINISHED_SUCCESS(2031),
    USER_EXPORT_IMAGE_FINISHED_FAILURE(2032, AuditLogSeverity.ERROR),
    USER_SPARSIFY_IMAGE_START(1325),
    USER_SPARSIFY_IMAGE_FINISH_SUCCESS(1326),
    USER_SPARSIFY_IMAGE_FINISH_FAILURE(1327, AuditLogSeverity.ERROR),
    USER_AMEND_IMAGE_START(1328),
    USER_AMEND_IMAGE_FINISH_SUCCESS(1329),
    USER_AMEND_IMAGE_FINISH_FAILURE(1330, AuditLogSeverity.ERROR),
    HOT_SET_NUMBER_OF_CPUS(2033),
    FAILED_HOT_SET_NUMBER_OF_CPUS(2034, AuditLogSeverity.ERROR),
    USER_ISCSI_BOND_HOST_RESTART_WARNING(2035, AuditLogSeverity.WARNING),
    HOT_SET_MEMORY(2039),
    FAILED_HOT_SET_MEMORY(2040, AuditLogSeverity.ERROR),
    DISK_PREALLOCATION_FAILED(2041, AuditLogSeverity.ERROR),
    MEMORY_HOT_UNPLUG_SUCCESSFULLY_REQUESTED(2046),
    MEMORY_HOT_UNPLUG_FAILED(2047, AuditLogSeverity.ERROR),
    FAILED_HOT_SET_MEMORY_NOT_DIVIDABLE(2048, AuditLogSeverity.ERROR),
    MEMORY_HOT_UNPLUG_SUCCESSFULLY_REQUESTED_PLUS_MEMORY_INFO(2049),
    NO_MEMORY_DEVICE_TO_HOT_UNPLUG(2050),
    NO_SUITABLE_MEMORY_DEVICE_TO_HOT_UNPLUG(2051),

    // Used only from SQL script, therefor should not have severity & message
    USER_RUN_UNLOCK_ENTITY_SCRIPT(2024),
    USER_MOVE_IMAGE_GROUP_FAILED_TO_DELETE_SRC_IMAGE(2025, AuditLogSeverity.WARNING),
    USER_MOVE_IMAGE_GROUP_FAILED_TO_DELETE_DST_IMAGE(2026, AuditLogSeverity.WARNING),
    USER_COPY_IMAGE_GROUP_FAILED_TO_DELETE_DST_IMAGE(2045, AuditLogSeverity.WARNING),
    // Quota audit logs
    USER_ADD_QUOTA(3000),
    USER_FAILED_ADD_QUOTA(3001, AuditLogSeverity.ERROR),
    USER_UPDATE_QUOTA(3002),
    USER_FAILED_UPDATE_QUOTA(3003, AuditLogSeverity.ERROR),
    USER_DELETE_QUOTA(3004),
    USER_FAILED_DELETE_QUOTA(3005, AuditLogSeverity.ERROR),
    USER_EXCEEDED_QUOTA_CLUSTER_GRACE_LIMIT(3006, AuditLogSeverity.ERROR),
    USER_EXCEEDED_QUOTA_CLUSTER_LIMIT(3007, AuditLogSeverity.WARNING),
    USER_EXCEEDED_QUOTA_CLUSTER_THRESHOLD(3008, AuditLogSeverity.WARNING),
    USER_EXCEEDED_QUOTA_STORAGE_GRACE_LIMIT(3009, AuditLogSeverity.ERROR),
    USER_EXCEEDED_QUOTA_STORAGE_LIMIT(3010, AuditLogSeverity.WARNING),
    USER_EXCEEDED_QUOTA_STORAGE_THRESHOLD(3011, AuditLogSeverity.WARNING),
    QUOTA_STORAGE_RESIZE_LOWER_THEN_CONSUMPTION(3012, AuditLogSeverity.WARNING),
    MISSING_QUOTA_STORAGE_PARAMETERS_PERMISSIVE_MODE(3013, AuditLogSeverity.WARNING),
    MISSING_QUOTA_CLUSTER_PARAMETERS_PERMISSIVE_MODE(3014, AuditLogSeverity.WARNING),
    USER_EXCEEDED_QUOTA_CLUSTER_GRACE_LIMIT_PERMISSIVE_MODE(3015, AuditLogSeverity.WARNING),
    USER_EXCEEDED_QUOTA_STORAGE_GRACE_LIMIT_PERMISSIVE_MODE(3016, AuditLogSeverity.WARNING),

    // Gluster Audit Logs
    GLUSTER_VOLUME_CREATE(4000),
    GLUSTER_VOLUME_CREATE_FAILED(4001, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_OPTION_ADDED(4002),
    GLUSTER_VOLUME_OPTION_SET_FAILED(4003, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_START(4004),
    GLUSTER_VOLUME_START_FAILED(4005, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_STOP(4006),
    GLUSTER_VOLUME_STOP_FAILED(4007, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_OPTIONS_RESET(4008),
    GLUSTER_VOLUME_OPTIONS_RESET_FAILED(4009, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_DELETE(4010),
    GLUSTER_VOLUME_DELETE_FAILED(4011, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_REBALANCE_START(4012),
    GLUSTER_VOLUME_REBALANCE_START_FAILED(4013, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_REMOVE_BRICKS(4014),
    GLUSTER_VOLUME_REMOVE_BRICKS_FAILED(4015, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_REPLACE_BRICK_FAILED(4016, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_REPLACE_BRICK_START(4017),
    GLUSTER_VOLUME_REPLACE_BRICK_START_FAILED(4018, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_ADD_BRICK(4019),
    GLUSTER_VOLUME_ADD_BRICK_FAILED(4020, AuditLogSeverity.ERROR),
    GLUSTER_SERVER_REMOVE_FAILED(4021, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_PROFILE_START(4022),
    GLUSTER_VOLUME_PROFILE_START_FAILED(4023, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_PROFILE_STOP(4024),
    GLUSTER_VOLUME_PROFILE_STOP_FAILED(4025, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_CREATED_FROM_CLI(4026, AuditLogSeverity.WARNING),
    GLUSTER_VOLUME_DELETED_FROM_CLI(4027, AuditLogSeverity.ALERT),
    GLUSTER_VOLUME_OPTION_SET_FROM_CLI(4028, AuditLogSeverity.WARNING),
    GLUSTER_VOLUME_OPTION_RESET_FROM_CLI(4029, AuditLogSeverity.WARNING),
    GLUSTER_VOLUME_PROPERTIES_CHANGED_FROM_CLI(4030, AuditLogSeverity.WARNING),
    GLUSTER_VOLUME_BRICK_ADDED_FROM_CLI(4031, AuditLogSeverity.WARNING),
    GLUSTER_VOLUME_BRICK_REMOVED_FROM_CLI(4032, AuditLogSeverity.ALERT),
    GLUSTER_SERVER_REMOVED_FROM_CLI(4033, AuditLogSeverity.ALERT),
    GLUSTER_VOLUME_INFO_FAILED(4034, AuditLogSeverity.ERROR),
    GLUSTER_COMMAND_FAILED(4035, AuditLogSeverity.ERROR),
    GLUSTER_SERVER_ADD_FAILED(4436, AuditLogSeverity.ERROR),
    GLUSTER_SERVERS_LIST_FAILED(4437, AuditLogSeverity.ERROR),
    GLUSTER_SERVER_REMOVE(4038),
    GLUSTER_VOLUME_STARTED_FROM_CLI(4039, AuditLogSeverity.WARNING),
    GLUSTER_VOLUME_STOPPED_FROM_CLI(4040, AuditLogSeverity.WARNING),
    GLUSTER_VOLUME_OPTION_CHANGED_FROM_CLI(4041),
    GLUSTER_HOOK_ENABLE(4042),
    GLUSTER_HOOK_ENABLE_FAILED(4043, AuditLogSeverity.ERROR),
    GLUSTER_HOOK_ENABLE_PARTIAL(4044, AuditLogSeverity.WARNING),
    GLUSTER_HOOK_DISABLE(4045),
    GLUSTER_HOOK_DISABLE_FAILED(4046, AuditLogSeverity.ERROR),
    GLUSTER_HOOK_DISABLE_PARTIAL(4047, AuditLogSeverity.WARNING),
    GLUSTER_HOOK_LIST_FAILED(4048, AuditLogSeverity.ERROR),
    GLUSTER_HOOK_CONFLICT_DETECTED(4049, AuditLogSeverity.WARNING),
    GLUSTER_HOOK_DETECTED_NEW(4050),
    GLUSTER_HOOK_DETECTED_DELETE(4051),
    GLUSTER_VOLUME_OPTION_MODIFIED(4052),
    GLUSTER_HOOK_GETCONTENT_FAILED(4053, AuditLogSeverity.ERROR),
    GLUSTER_SERVICES_LIST_FAILED(4054, AuditLogSeverity.ERROR),
    GLUSTER_SERVICE_TYPE_ADDED_TO_CLUSTER(4055),
    GLUSTER_CLUSTER_SERVICE_STATUS_CHANGED(4056),
    GLUSTER_SERVICE_ADDED_TO_SERVER(4057),
    GLUSTER_SERVER_SERVICE_STATUS_CHANGED(4058),
    GLUSTER_HOOK_UPDATED(4059),
    GLUSTER_HOOK_UPDATE_FAILED(4060, AuditLogSeverity.ERROR),
    GLUSTER_HOOK_ADDED(4061),
    GLUSTER_HOOK_ADD_FAILED(4062, AuditLogSeverity.ERROR),
    GLUSTER_HOOK_REMOVED(4063),
    GLUSTER_HOOK_REMOVE_FAILED(4064, AuditLogSeverity.ERROR),
    GLUSTER_HOOK_REFRESH(4065),
    GLUSTER_HOOK_REFRESH_FAILED(4066, AuditLogSeverity.ERROR),
    GLUSTER_SERVICE_STARTED(4067),
    GLUSTER_SERVICE_START_FAILED(4068, AuditLogSeverity.ERROR),
    GLUSTER_SERVICE_STOPPED(4069),
    GLUSTER_SERVICE_STOP_FAILED(4070, AuditLogSeverity.ERROR),
    GLUSTER_SERVICES_LIST_NOT_FETCHED(4071),
    GLUSTER_SERVICE_RESTARTED(4072),
    GLUSTER_SERVICE_RESTART_FAILED(4073, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_OPTIONS_RESET_ALL(4074),
    GLUSTER_HOST_UUID_NOT_FOUND(4075, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_BRICK_ADDED(4076),
    GLUSTER_CLUSTER_SERVICE_STATUS_ADDED(4077),
    GLUSTER_VOLUME_REBALANCE_STOP(4078),
    GLUSTER_VOLUME_REBALANCE_STOP_FAILED(4079, AuditLogSeverity.ERROR),
    START_REMOVING_GLUSTER_VOLUME_BRICKS(4080),
    START_REMOVING_GLUSTER_VOLUME_BRICKS_FAILED(4081, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_REMOVE_BRICKS_STOP(4082),
    GLUSTER_VOLUME_REMOVE_BRICKS_STOP_FAILED(4083, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_REMOVE_BRICKS_COMMIT(4084),
    GLUSTER_VOLUME_REMOVE_BRICKS_COMMIT_FAILED(4085, AuditLogSeverity.ERROR),
    GLUSTER_BRICK_STATUS_CHANGED(4086, AuditLogSeverity.WARNING),
    GLUSTER_VOLUME_REBALANCE_FINISHED(4087),
    GLUSTER_VOLUME_MIGRATE_BRICK_DATA_FINISHED(4088),
    GLUSTER_HOST_UUID_ALREADY_EXISTS(4095, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_REBALANCE_START_DETECTED_FROM_CLI(4089),
    START_REMOVING_GLUSTER_VOLUME_BRICKS_DETECTED_FROM_CLI(4090),
    GLUSTER_VOLUME_REBALANCE_NOT_FOUND_FROM_CLI(4091, AuditLogSeverity.WARNING),
    REMOVE_GLUSTER_VOLUME_BRICKS_NOT_FOUND_FROM_CLI(4092, AuditLogSeverity.WARNING),
    GLUSTER_VOLUME_DETAILS_REFRESH(4093),
    GLUSTER_VOLUME_DETAILS_REFRESH_FAILED(4094, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_GEO_REP_START_FAILED_EXCEPTION(4595, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_GEO_REP_START(4596),
    GLUSTER_VOLUME_GEO_REP_RESUME_FAILED(4598, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_GEO_REP_RESUME(4599),
    GLUSTER_VOLUME_GEO_REP_PAUSE_FAILED(4597, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_GEO_REP_PAUSE(4600),
    USER_FORCE_SELECTED_SPM_STOP_FAILED(4096, AuditLogSeverity.ERROR),
    GLUSTER_GEOREP_SESSION_DELETED_FROM_CLI(4097, AuditLogSeverity.WARNING),
    GLUSTER_GEOREP_SESSION_DETECTED_FROM_CLI(4098, AuditLogSeverity.WARNING),
    GLUSTER_GEOREP_SESSION_REFRESH(4099),
    GLUSTER_GEOREP_SESSION_REFRESH_FAILED(4100, AuditLogSeverity.ERROR),
    GEOREP_SESSION_STOP(4101),
    GEOREP_SESSION_STOP_FAILED(4102, AuditLogSeverity.ERROR),
    GEOREP_SESSION_DELETED(4103),
    GEOREP_SESSION_DELETE_FAILED(4104, AuditLogSeverity.ERROR),
    GLUSTER_GEOREP_CONFIG_SET(4105),
    GLUSTER_GEOREP_CONFIG_SET_FAILED(4106, AuditLogSeverity.ERROR),
    GLUSTER_GEOREP_CONFIG_LIST(4107),
    GLUSTER_GEOREP_CONFIG_LIST_FAILED(4108, AuditLogSeverity.ERROR),
    GLUSTER_GEOREP_CONFIG_SET_DEFAULT(4109),
    GLUSTER_GEOREP_CONFIG_SET_DEFAULT_FAILED(4110, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_SNAPSHOT_DELETED(4111),
    GLUSTER_VOLUME_SNAPSHOT_DELETE_FAILED(4112, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_ALL_SNAPSHOTS_DELETED(4113),
    GLUSTER_VOLUME_ALL_SNAPSHOTS_DELETE_FAILED(4114, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_SNAPSHOT_ACTIVATED(4115),
    GLUSTER_VOLUME_SNAPSHOT_ACTIVATE_FAILED(4116, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_SNAPSHOT_DEACTIVATED(4117),
    GLUSTER_VOLUME_SNAPSHOT_DEACTIVATE_FAILED(4118, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_SNAPSHOT_RESTORED(4119),
    GLUSTER_VOLUME_SNAPSHOT_RESTORE_FAILED(4120, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_SNAPSHOT_CONFIG_UPDATED(4121),
    GLUSTER_VOLUME_SNAPSHOT_CONFIG_UPDATE_FAILED(4122, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_SNAPSHOT_CONFIG_UPDATE_FAILED_PARTIALLY(4123, AuditLogSeverity.ERROR),
    NEW_STORAGE_DEVICE_DETECTED(4124),
    STORAGE_DEVICE_REMOVED_FROM_THE_HOST(4125),
    SYNC_STORAGE_DEVICES_IN_HOST(4126),
    SYNC_STORAGE_DEVICES_IN_HOST_FAILED(4127, AuditLogSeverity.ERROR),
    GEOREP_OPTION_SET_FROM_CLI(4128, AuditLogSeverity.WARNING),
    GEOREP_OPTION_CHANGED_FROM_CLI(4129, AuditLogSeverity.WARNING),
    GLUSTER_MASTER_VOLUME_STOP_FAILED_DURING_SNAPSHOT_RESTORE(4130, AuditLogSeverity.ERROR),
    GLUSTER_MASTER_VOLUME_SNAPSHOT_RESTORE_FAILED(4131, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_SNAPSHOT_CREATED(4132),
    GLUSTER_VOLUME_SNAPSHOT_CREATE_FAILED(4133, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_SNAPSHOT_SCHEDULED(4134),
    GLUSTER_VOLUME_SNAPSHOT_SCHEDULE_FAILED(4135, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_SNAPSHOT_RESCHEDULED(4136),
    GLUSTER_VOLUME_SNAPSHOT_RESCHEDULE_FAILED(4137, AuditLogSeverity.ERROR),
    CREATE_GLUSTER_BRICK(4138),
    CREATE_GLUSTER_BRICK_FAILED(4139, AuditLogSeverity.ERROR),
    GLUSTER_GEO_REP_PUB_KEY_FETCH_FAILED(4140, AuditLogSeverity.ERROR),
    GLUSTER_GET_PUB_KEY(4141),
    GLUSTER_GEOREP_PUBLIC_KEY_WRITE_FAILED(4142, AuditLogSeverity.ERROR),
    GLUSTER_WRITE_PUB_KEYS(4143),
    GLUSTER_GEOREP_SETUP_MOUNT_BROKER_FAILED(4144, AuditLogSeverity.ERROR),
    GLUSTER_SETUP_GEOREP_MOUNT_BROKER(4145),
    GLUSTER_GEOREP_SESSION_CREATE_FAILED(4146, AuditLogSeverity.ERROR),
    CREATE_GLUSTER_VOLUME_GEOREP_SESSION(4147),
    GLUSTER_VOLUME_SNAPSHOT_SOFT_LIMIT_REACHED(4148, AuditLogSeverity.ALERT),
    HOST_FEATURES_INCOMPATIBILE_WITH_CLUSTER(4149, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_SNAPSHOT_SCHEDULE_DELETED(4150),
    GLUSTER_BRICK_STATUS_DOWN(4151, AuditLogSeverity.ALERT),
    GLUSTER_VOLUME_SNAPSHOT_DETECTED_NEW(4152),
    GLUSTER_VOLUME_SNAPSHOT_DELETED_FROM_CLI(4153),
    GLUSTER_VOLUME_SNAPSHOT_CLUSTER_CONFIG_DETECTED_NEW(4154),
    GLUSTER_VOLUME_SNAPSHOT_VOLUME_CONFIG_DETECTED_NEW(4155),
    GLUSTER_VOLUME_SNAPSHOT_HARD_LIMIT_REACHED(4156, AuditLogSeverity.ALERT),
    GLUSTER_CLI_SNAPSHOT_SCHEDULE_DISABLE_FAILED(4157, AuditLogSeverity.ERROR),
    GLUSTER_CLI_SNAPSHOT_SCHEDULE_DISABLED(4158),
    SET_UP_PASSWORDLESS_SSH(4159),
    SET_UP_PASSWORDLESS_SSH_FAILED(4160, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_TYPE_UNSUPPORTED(4161, AuditLogSeverity.WARNING),
    GLUSTER_VOLUME_BRICK_REPLACED(4162),
    GLUSTER_SERVER_STATUS_DISCONNECTED(4163, AuditLogSeverity.ALERT),
    GLUSTER_STORAGE_DOMAIN_SYNC_FAILED(4164, AuditLogSeverity.ALERT),
    GLUSTER_STORAGE_DOMAIN_SYNCED(4165),
    GLUSTER_STORAGE_DOMAIN_SYNC_STARTED(4166),
    STORAGE_DOMAIN_DR_DELETED(4167, AuditLogSeverity.ERROR),
    GLUSTER_WEBHOOK_ADDED(4168),
    GLUSTER_WEBHOOK_ADD_FAILED(4169, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_RESET_BRICK_FAILED(4170, AuditLogSeverity.ERROR),
    GLUSTER_VOLUME_BRICK_RESETED(4171),
    GLUSTER_VOLUME_CONFIRMED_SPACE_LOW(4172, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.HOUR.getValue() * 12),

    USER_FORCE_SELECTED_SPM(159),
    USER_VDS_RESTART(41),
    USER_FAILED_VDS_RESTART(107, AuditLogSeverity.ERROR),
    USER_VDS_START(20),
    USER_FAILED_VDS_START(118, AuditLogSeverity.ERROR),
    USER_VDS_STOP(21),
    USER_FAILED_VDS_STOP(137, AuditLogSeverity.ERROR),
    USER_ADD_VDS(42),
    USER_FAILED_ADD_VDS(104, AuditLogSeverity.ERROR),
    USER_UPDATE_VDS(43),
    USER_FAILED_UPDATE_VDS(105, AuditLogSeverity.ERROR),
    USER_REMOVE_VDS(44),
    USER_FAILED_REMOVE_VDS(106, AuditLogSeverity.ERROR),
    USER_CREATE_SNAPSHOT(45),
    MERGE_SNAPSHOTS_ON_HOST(72),
    USER_CREATE_SNAPSHOT_FINISHED_SUCCESS(68),
    USER_CREATE_SNAPSHOT_FINISHED_FAILURE(69, AuditLogSeverity.ERROR),
    USER_CREATE_LIVE_SNAPSHOT_FINISHED_FAILURE(170, AuditLogSeverity.WARNING),
    USER_FAILED_CREATE_SNAPSHOT(117, AuditLogSeverity.ERROR),
    USER_CREATE_LIVE_SNAPSHOT_NO_MEMORY_FAILURE(173, AuditLogSeverity.ERROR),
    USER_REMOVE_SNAPSHOT(342),
    USER_FAILED_REMOVE_SNAPSHOT(343, AuditLogSeverity.ERROR),
    USER_REMOVE_SNAPSHOT_FINISHED_SUCCESS(356),
    USER_REMOVE_SNAPSHOT_FINISHED_FAILURE(357, AuditLogSeverity.ERROR),
    USER_REMOVE_SNAPSHOT_FINISHED_FAILURE_PARTIAL_SNAPSHOT(359, AuditLogSeverity.WARNING),
    USER_REMOVE_SNAPSHOT_FINISHED_FAILURE_BASE_IMAGE_NOT_FOUND(362, AuditLogSeverity.ERROR),
    USER_TRY_BACK_TO_SNAPSHOT(46),
    USER_TRY_BACK_TO_SNAPSHOT_FINISH_SUCCESS(71),
    USER_TRY_BACK_TO_SNAPSHOT_FINISH_FAILURE(99, AuditLogSeverity.ERROR),
    USER_FAILED_TRY_BACK_TO_SNAPSHOT(115, AuditLogSeverity.ERROR),
    @Deprecated
    USER_RESTORE_FROM_SNAPSHOT(47),
    @Deprecated
    USER_RESTORE_FROM_SNAPSHOT_START(1190),
    @Deprecated
    USER_RESTORE_FROM_SNAPSHOT_FINISH_SUCCESS(100),
    @Deprecated
    USER_RESTORE_FROM_SNAPSHOT_FINISH_FAILURE(101, AuditLogSeverity.ERROR),
    @Deprecated
    USER_FAILED_RESTORE_FROM_SNAPSHOT(116, AuditLogSeverity.ERROR),
    USER_COMMIT_RESTORE_FROM_SNAPSHOT_START(94),
    USER_COMMIT_RESTORE_FROM_SNAPSHOT_FINISH_SUCCESS(95),
    USER_COMMIT_RESTORE_FROM_SNAPSHOT_FINISH_FAILURE(96, AuditLogSeverity.ERROR),
    USER_UNDO_RESTORE_FROM_SNAPSHOT_START(650),
    USER_UNDO_RESTORE_FROM_SNAPSHOT_FINISH_SUCCESS(651),
    USER_UNDO_RESTORE_FROM_SNAPSHOT_FINISH_FAILURE(652, AuditLogSeverity.ERROR),
    USER_ADD_VM_TEMPLATE(48),
    USER_ADD_VM_TEMPLATE_SUCCESS(29),
    USER_FAILED_ADD_VM_TEMPLATE(108, AuditLogSeverity.ERROR),
    USER_ADD_VM_TEMPLATE_FAILURE(36, AuditLogSeverity.ERROR),
    USER_ADD_VM_TEMPLATE_FINISHED_SUCCESS(51),
    USER_ADD_VM_TEMPLATE_CREATE_TEMPLATE_FAILURE(1322, AuditLogSeverity.ERROR),
    USER_ADD_VM_TEMPLATE_ASSIGN_ILLEGAL_FAILURE(1323, AuditLogSeverity.ERROR),
    USER_ADD_VM_TEMPLATE_SEAL_FAILURE(1324, AuditLogSeverity.ERROR),
    USER_ADD_VM_TEMPLATE_FINISHED_FAILURE(52, AuditLogSeverity.ERROR),
    USER_UPDATE_VM_TEMPLATE(49),
    USER_FAILED_UPDATE_VM_TEMPLATE(109, AuditLogSeverity.ERROR),
    USER_REMOVE_VM_TEMPLATE(50),
    USER_REMOVE_VM_TEMPLATE_FINISHED(251),
    USER_FAILED_REMOVE_VM_TEMPLATE(110, AuditLogSeverity.ERROR),
    TEMPLATE_IMPORT(135),
    TEMPLATE_IMPORT_FAILED(136, AuditLogSeverity.ERROR),
    TEMPLATE_IMPORT_FROM_CONFIGURATION_SUCCESS(180),
    TEMPLATE_IMPORT_FROM_CONFIGURATION_FAILED(181, AuditLogSeverity.ERROR),
    USER_ATTACH_USER_TO_VM(520),
    USER_DETACH_USER_FROM_VM(360),
    USER_FAILED_DETACH_USER_FROM_VM(361, AuditLogSeverity.ERROR),
    USER_FAILED_ATTACH_USER_TO_VM(182, AuditLogSeverity.ERROR),
    USER_REMOVE_ADUSER(325),
    USER_FAILED_REMOVE_ADUSER(326, AuditLogSeverity.ERROR),
    USER_FAILED_ADD_ADUSER(327, AuditLogSeverity.WARNING),
    USER_PASSWORD_CHANGED(346),
    USER_PASSWORD_CHANGE_FAILED(347, AuditLogSeverity.ERROR),
    USER_CLEAR_UNKNOWN_VMS(348),
    USER_FAILED_CLEAR_UNKNOWN_VMS(349, AuditLogSeverity.ERROR),
    USER_EXTEND_DISK_SIZE_FAILURE(370, AuditLogSeverity.ERROR),
    USER_EXTEND_DISK_SIZE_SUCCESS(371),
    USER_EXTEND_DISK_SIZE_UPDATE_VM_FAILURE(372, AuditLogSeverity.WARNING),
    USER_REMOVE_DISK_SNAPSHOT(373),
    USER_FAILED_REMOVE_DISK_SNAPSHOT(374, AuditLogSeverity.ERROR),
    USER_REMOVE_DISK_SNAPSHOT_FINISHED_SUCCESS(375),
    USER_REMOVE_DISK_SNAPSHOT_FINISHED_FAILURE(376, AuditLogSeverity.ERROR),
    USER_EXTENDED_DISK_SIZE(377),
    USER_REGISTER_DISK_FINISHED_SUCCESS(378),
    USER_REGISTER_DISK_FINISHED_FAILURE(379, AuditLogSeverity.ERROR),
    USER_EXTEND_DISK_SIZE_UPDATE_HOST_FAILURE(380, AuditLogSeverity.WARNING),
    USER_REGISTER_DISK_INITIATED(381),
    USER_REDUCE_DISK_FINISHED_SUCCESS(382),
    USER_REDUCE_DISK_FINISHED_FAILURE(383, AuditLogSeverity.ERROR),

    USER_EJECT_VM_DISK(528),

    VM_DISK_ALREADY_CHANGED(1191),
    VM_DISK_ALREADY_EJECTED(1192),

    // -- VM Log types --
    VM_DOWN(61),
    VM_DOWN_ERROR(119, AuditLogSeverity.ERROR),
    VM_MIGRATION_START(62),
    VM_MIGRATION_DONE(63),
    VM_MIGRATION_ABORT(64, AuditLogSeverity.ERROR),
    VM_MIGRATION_FAILED(65, AuditLogSeverity.ERROR),
    VM_MIGRATION_NO_VDS_TO_MIGRATE_TO(166, AuditLogSeverity.WARNING),
    VM_MIGRATION_NOT_ALL_VM_NICS_WERE_PLUGGED_BACK(12003, AuditLogSeverity.ERROR),
    VM_MIGRATION_PLUGGING_VM_NICS_FAILED(12004, AuditLogSeverity.ERROR),
    VM_FAILURE(66, AuditLogSeverity.ERROR),
    VM_MIGRATION_START_SYSTEM_INITIATED(67),
    VM_MIGRATION_TO_SERVER_FAILED(120, AuditLogSeverity.ERROR),
    VM_MIGRATION_TRYING_RERUN(128, AuditLogSeverity.WARNING),
    VM_CANCEL_MIGRATION(161),
    VM_CANCEL_MIGRATION_FAILED(162, AuditLogSeverity.ERROR),
    VM_STATUS_RESTORED(163),
    VM_SET_TICKET(164),
    VM_SET_TICKET_FAILED(165, AuditLogSeverity.ERROR),
    VM_CONSOLE_CONNECTED(167),
    VM_CONSOLE_DISCONNECTED(168),
    VM_FAILED_TO_PRESTART_IN_POOL(169, AuditLogSeverity.WARNING, AuditLogTimeInterval.HOUR.getValue()),
    VM_CANCEL_CONVERSION(194),
    VM_CANCEL_CONVERSION_FAILED(195, AuditLogSeverity.ERROR),

    VM_MIGRATION_FAILED_DURING_MOVE_TO_MAINTENANCE(140, AuditLogSeverity.ERROR),
    VM_MIGRATION_FAILED_DURING_MOVE_TO_MAINTENANCE_NO_DESTINATION_VDS(1111, AuditLogSeverity.ERROR),
    VM_SET_TO_UNKNOWN_STATUS(142, AuditLogSeverity.WARNING),
    VM_WAS_SET_DOWN_DUE_TO_HOST_REBOOT_OR_MANUAL_FENCE(143),

    USER_EXPORT_VM(131),
    USER_EXPORT_VM_FAILED(132, AuditLogSeverity.ERROR),
    USER_EXPORT_TEMPLATE(133),
    USER_EXPORT_TEMPLATE_FAILED(134, AuditLogSeverity.ERROR),
    VM_IMPORT(124),
    VM_IMPORT_FAILED(125, AuditLogSeverity.ERROR),
    VM_NOT_RESPONDING(126, AuditLogSeverity.WARNING),
    VDS_RUN_IN_NO_KVM_MODE(127, AuditLogSeverity.ERROR),
    VDS_VERSION_NOT_SUPPORTED_FOR_CLUSTER(141, AuditLogSeverity.ERROR),
    VDS_CLUSTER_VERSION_NOT_SUPPORTED(154, AuditLogSeverity.ERROR),
    VDS_ARCHITECTURE_NOT_SUPPORTED_FOR_CLUSTER(155, AuditLogSeverity.ERROR),
    CPU_TYPE_UNSUPPORTED_IN_THIS_CLUSTER_VERSION(156, AuditLogSeverity.ERROR),
    VM_CLEARED(129),
    VM_PAUSED(1025),
    VM_PAUSED_ENOSPC(138, AuditLogSeverity.ERROR),
    VM_PAUSED_ERROR(139, AuditLogSeverity.ERROR),
    VM_IMPORT_INFO(144),
    VM_PAUSED_EIO(145, AuditLogSeverity.ERROR),
    VM_PAUSED_EPERM(146, AuditLogSeverity.ERROR),
    VM_RECOVERED_FROM_PAUSE_ERROR(196, AuditLogSeverity.NORMAL),
    VM_POWER_DOWN_FAILED(147, AuditLogSeverity.WARNING),
    VM_IMPORT_FROM_CONFIGURATION_EXECUTED_SUCCESSFULLY(174),
    VM_IMPORT_FROM_CONFIGURATION_ATTACH_DISKS_FAILED(175, AuditLogSeverity.WARNING),

    VM_MEMORY_UNDER_GUARANTEED_VALUE(148, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.MINUTE.getValue() * 15),
    VM_BALLOON_DRIVER_ERROR(176, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.MINUTE.getValue() * 15),
    VM_BALLOON_DRIVER_UNCONTROLLED(177, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.MINUTE.getValue() * 15),
    VM_MEMORY_NOT_IN_RECOMMENDED_RANGE(178, AuditLogSeverity.WARNING),

    USER_ADD_VM_POOL_WITH_VMS(302),
    USER_ADD_VM_POOL_WITH_VMS_FAILED(303, AuditLogSeverity.ERROR),
    USER_ADD_VM_POOL_WITH_VMS_ADD_VDS_FAILED(320, AuditLogSeverity.ERROR),
    USER_REMOVE_VM_POOL_INITIATED(321),
    USER_REMOVE_VM_POOL(304),
    USER_REMOVE_VM_POOL_FAILED(305, AuditLogSeverity.ERROR),
    USER_ADD_VM_TO_POOL(306),
    USER_ADD_VM_TO_POOL_FAILED(307, AuditLogSeverity.ERROR),
    USER_REMOVE_VM_FROM_POOL(308),
    USER_REMOVE_VM_FROM_POOL_FAILED(309, AuditLogSeverity.ERROR),
    USER_ATTACH_USER_TO_POOL(310),
    USER_ATTACH_USER_TO_POOL_INTERNAL(472),
    USER_ATTACH_USER_TO_POOL_FAILED(311, AuditLogSeverity.ERROR),
    USER_ATTACH_USER_TO_POOL_FAILED_INTERNAL(473, AuditLogSeverity.ERROR),
    USER_DETACH_USER_FROM_POOL(312),
    USER_DETACH_USER_FROM_POOL_FAILED(313, AuditLogSeverity.ERROR),
    USER_UPDATE_VM_POOL(314),
    USER_UPDATE_VM_POOL_FAILED(315, AuditLogSeverity.ERROR),
    USER_ATTACH_USER_TO_VM_FROM_POOL(316),
    USER_ATTACH_USER_TO_VM_FROM_POOL_FINISHED_SUCCESS(318),
    USER_ATTACH_USER_TO_VM_FROM_POOL_FINISHED_FAILURE(319, AuditLogSeverity.ERROR),
    USER_ATTACH_USER_TO_VM_FROM_POOL_FAILED(317, AuditLogSeverity.ERROR),
    USER_UPDATE_VM_POOL_WITH_VMS(344),
    USER_UPDATE_VM_POOL_WITH_VMS_FAILED(345, AuditLogSeverity.ERROR),
    USER_VM_POOL_MAX_SUBSEQUENT_FAILURES_REACHED(358, AuditLogSeverity.WARNING),

    USER_ADD_BOOKMARK(350),
    USER_ADD_BOOKMARK_FAILED(351, AuditLogSeverity.ERROR),
    USER_UPDATE_BOOKMARK(352),
    USER_UPDATE_BOOKMARK_FAILED(353, AuditLogSeverity.ERROR),
    USER_REMOVE_BOOKMARK(354),
    USER_REMOVE_BOOKMARK_FAILED(355, AuditLogSeverity.ERROR),
    /**
     * AdGroups
     */
    USER_ATTACH_VM_TO_AD_GROUP(400),
    USER_ATTACH_VM_TO_AD_GROUP_FAILED(401, AuditLogSeverity.ERROR),
    USER_DETACH_VM_TO_AD_GROUP(402),
    USER_DETACH_VM_TO_AD_GROUP_FAILED(403, AuditLogSeverity.ERROR),
    USER_ATTACH_VM_POOL_TO_AD_GROUP(404),
    USER_ATTACH_VM_POOL_TO_AD_GROUP_INTERNAL(470),
    USER_ATTACH_VM_POOL_TO_AD_GROUP_FAILED(405, AuditLogSeverity.ERROR),
    USER_ATTACH_VM_POOL_TO_AD_GROUP_FAILED_INTERNAL(471, AuditLogSeverity.ERROR),
    USER_DETACH_VM_POOL_TO_AD_GROUP(406),
    USER_DETACH_VM_POOL_TO_AD_GROUP_FAILED(407, AuditLogSeverity.ERROR),
    USER_REMOVE_AD_GROUP(408),
    USER_REMOVE_AD_GROUP_FAILED(409, AuditLogSeverity.ERROR),
    USER_UPDATE_TAG(430),
    USER_UPDATE_TAG_FAILED(431, AuditLogSeverity.ERROR),
    USER_ADD_TAG(432),
    USER_ADD_TAG_FAILED(433, AuditLogSeverity.ERROR),
    USER_REMOVE_TAG(434),
    USER_REMOVE_TAG_FAILED(435, AuditLogSeverity.ERROR),
    USER_ATTACH_TAG_TO_USER(436),
    USER_ATTACH_TAG_TO_USER_FAILED(437, AuditLogSeverity.ERROR),
    USER_ATTACH_TAG_TO_USER_GROUP(438),
    USER_ATTACH_TAG_TO_USER_GROUP_FAILED(439, AuditLogSeverity.ERROR),
    USER_ATTACH_TAG_TO_VM(440),
    USER_ATTACH_TAG_TO_VM_FAILED(441, AuditLogSeverity.ERROR),
    USER_ATTACH_TAG_TO_VDS(442),
    USER_ATTACH_TAG_TO_VDS_FAILED(443, AuditLogSeverity.ERROR),
    USER_DETACH_VDS_FROM_TAG(444),
    USER_DETACH_VDS_FROM_TAG_FAILED(445, AuditLogSeverity.ERROR),
    USER_DETACH_VM_FROM_TAG(446),
    USER_DETACH_VM_FROM_TAG_FAILED(447, AuditLogSeverity.ERROR),
    USER_DETACH_USER_FROM_TAG(448),
    USER_DETACH_USER_FROM_TAG_FAILED(449, AuditLogSeverity.ERROR),
    USER_DETACH_USER_GROUP_FROM_TAG(450),
    USER_DETACH_USER_GROUP_FROM_TAG_FAILED(451, AuditLogSeverity.ERROR),
    USER_ATTACH_TAG_TO_USER_EXISTS(452, AuditLogSeverity.WARNING),
    USER_ATTACH_TAG_TO_USER_GROUP_EXISTS(453, AuditLogSeverity.WARNING),
    USER_ATTACH_TAG_TO_VM_EXISTS(454, AuditLogSeverity.WARNING),
    USER_ATTACH_TAG_TO_VDS_EXISTS(455, AuditLogSeverity.WARNING),
    USER_ATTACH_TAG_TO_TEMPLATE(183),
    USER_ATTACH_TAG_TO_TEMPLATE_FAILED(184, AuditLogSeverity.ERROR),
    USER_DETACH_TEMPLATE_FROM_TAG(185),
    USER_DETACH_TEMPLATE_FROM_TAG_FAILED(186, AuditLogSeverity.ERROR),
    USER_ATTACH_TAG_TO_TEMPLATE_EXISTS(460, AuditLogSeverity.WARNING),
    USER_MOVE_TAG(555),
    USER_MOVE_TAG_FAILED(556, AuditLogSeverity.ERROR),
    USER_LOGGED_IN_VM(456),
    USER_LOGGED_OUT_VM(457),
    USER_LOCKED_VM(458),
    USER_UNLOCKED_VM(459),
    UPDATE_TAGS_VM_DEFAULT_DISPLAY_TYPE(467),
    UPDATE_TAGS_VM_DEFAULT_DISPLAY_TYPE_FAILED(468),
    USER_ADD_CLUSTER(809),
    USER_ADD_CLUSTER_FAILED(810, AuditLogSeverity.ERROR),
    USER_UPDATE_CLUSTER(811),
    USER_UPDATE_CLUSTER_FAILED(812, AuditLogSeverity.ERROR),
    USER_START_CLUSTER_UPGRADE(892),
    USER_START_CLUSTER_UPGRADE_FAILED(893, AuditLogSeverity.ERROR),
    USER_FINISH_CLUSTER_UPGRADE(894),
    USER_FINISH_CLUSTER_UPGRADE_FAILED(895, AuditLogSeverity.ERROR),
    SYSTEM_UPDATE_CLUSTER(835, AuditLogTimeInterval.MINUTE.getValue()),
    SYSTEM_UPDATE_CLUSTER_FAILED(836, AuditLogTimeInterval.MINUTE.getValue()),
    USER_REMOVE_CLUSTER(813),
    USER_REMOVE_CLUSTER_FAILED(814, AuditLogSeverity.ERROR),
    MAC_POOL_EMPTY(816, AuditLogSeverity.WARNING),
    MAC_ADDRESS_IS_EXTERNAL(925, AuditLogSeverity.WARNING),
    MAC_ADDRESS_IS_IN_USE(833, AuditLogSeverity.WARNING),
    MAC_ADDRESS_HAD_TO_BE_REALLOCATED(10916, AuditLogSeverity.WARNING),
    MAC_ADDRESS_COULDNT_BE_REALLOCATED(10918, AuditLogSeverity.ERROR),
    MAC_ADDRESS_VIOLATES_NO_DUPLICATES_SETTING(10917, AuditLogSeverity.ERROR),
    MAC_POOL_VIOLATES_NO_OVERLAPPING_RANGES(10919, AuditLogSeverity.WARNING),
    MAC_POOL_VIOLATES_NO_OVERLAPPING_MAC_POOLS(10925, AuditLogSeverity.WARNING),
    MAC_ADDRESS_IS_IN_USE_UNPLUG(838, AuditLogSeverity.WARNING),
    HOST_AVAILABLE_UPDATES_STARTED(884),
    HOST_AVAILABLE_UPDATES_FINISHED(885),
    HOST_AVAILABLE_UPDATES_FAILED(839, AuditLogSeverity.ERROR),
    HOST_AVAILABLE_UPDATES_PROCESS_IS_ALREADY_RUNNING(886, AuditLogSeverity.WARNING),
    HOST_AVAILABLE_UPDATES_SKIPPED_UNSUPPORTED_STATUS(887, AuditLogSeverity.WARNING),
    HOST_CERTIFICATION_HAS_EXPIRED(877, AuditLogSeverity.ALERT, AuditLogTimeInterval.DAY.getValue()),
    HOST_CERTIFICATION_IS_ABOUT_TO_EXPIRE(845, AuditLogSeverity.WARNING, AuditLogTimeInterval.DAY.getValue()),
    HOST_CERTIFICATION_IS_ABOUT_TO_EXPIRE_ALERT(879, AuditLogSeverity.ALERT, AuditLogTimeInterval.DAY.getValue()),
    ENGINE_CERTIFICATION_HAS_EXPIRED(846, AuditLogSeverity.ALERT, AuditLogTimeInterval.DAY.getValue()),
    ENGINE_CERTIFICATION_IS_ABOUT_TO_EXPIRE(847, AuditLogSeverity.WARNING, AuditLogTimeInterval.DAY.getValue()),
    ENGINE_CERTIFICATION_IS_ABOUT_TO_EXPIRE_ALERT(878, AuditLogSeverity.ALERT, AuditLogTimeInterval.DAY.getValue()),
    ENGINE_CA_CERTIFICATION_HAS_EXPIRED(848, AuditLogSeverity.ALERT, AuditLogTimeInterval.DAY.getValue()),
    ENGINE_CA_CERTIFICATION_IS_ABOUT_TO_EXPIRE(849, AuditLogSeverity.WARNING, AuditLogTimeInterval.DAY.getValue()),
    ENGINE_CA_CERTIFICATION_IS_ABOUT_TO_EXPIRE_ALERT(883, AuditLogSeverity.ALERT, AuditLogTimeInterval.DAY.getValue()),
    HOST_CERTIFICATION_IS_INVALID(876, AuditLogSeverity.ERROR, AuditLogTimeInterval.DAY.getValue()),
    HOST_UPGRADE_STARTED(840),
    HOST_UPGRADE_FAILED(841, AuditLogSeverity.ERROR),
    HOST_UPGRADE_FINISHED(842),
    HOST_UPGRADE_FINISHED_MANUAL_HA(890, AuditLogSeverity.WARNING),
    HOST_UPDATES_ARE_AVAILABLE_WITH_PACKAGES(843, AuditLogSeverity.NORMAL, AuditLogTimeInterval.DAY.getValue() * 1),
    HOST_UPDATES_ARE_AVAILABLE(844, AuditLogSeverity.NORMAL, AuditLogTimeInterval.DAY.getValue() * 1),
    CERTIFICATE_FILE_NOT_FOUND(817, AuditLogSeverity.ERROR),
    HOST_CERTIFICATION_ENROLLMENT_STARTED(880, AuditLogSeverity.NORMAL),
    HOST_CERTIFICATION_ENROLLMENT_FINISHED(881, AuditLogSeverity.NORMAL),
    HOST_CERTIFICATION_ENROLLMENT_FAILED(882, AuditLogSeverity.ERROR),
    RUN_VM_FAILED(818, AuditLogSeverity.ERROR),
    MAC_ADDRESSES_POOL_NOT_INITIALIZED(837, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.HOUR.getValue()),
    // CBC
    VDS_REGISTER_ERROR_UPDATING_HOST(819, AuditLogSeverity.ERROR),
    VDS_REGISTER_ERROR_UPDATING_HOST_ALL_TAKEN(820, AuditLogSeverity.ERROR),
    VDS_REGISTER_HOST_IS_ACTIVE(821, AuditLogSeverity.ERROR),
    VDS_REGISTER_ERROR_UPDATING_NAME(822, AuditLogSeverity.ERROR),
    VDS_REGISTER_ERROR_UPDATING_NAMES_ALL_TAKEN(823, AuditLogSeverity.ERROR),
    VDS_REGISTER_NAME_IS_ACTIVE(824, AuditLogSeverity.ERROR),
    VDS_REGISTER_AUTO_APPROVE_PATTERN(825, AuditLogSeverity.ERROR),
    VDS_REGISTER_FAILED(826, AuditLogSeverity.ERROR),
    VDS_REGISTER_EXISTING_VDS_UPDATE_FAILED(827, AuditLogSeverity.ERROR),
    VDS_REGISTER_SUCCEEDED(828),
    VDS_REGISTER_EMPTY_ID(834, AuditLogSeverity.WARNING),
    VM_MIGRATION_ON_CONNECT_CHECK_FAILED(829, AuditLogSeverity.ERROR),
    VM_MIGRATION_ON_CONNECT_CHECK_SUCCEEDED(830),

    // Network
    NETWORK_REMOVE_BOND(926),
    NETWORK_REMOVE_BOND_FAILED(927, AuditLogSeverity.ERROR),
    NETWORK_VDS_NETWORK_MATCH_CLUSTER(928),
    NETWORK_VDS_NETWORK_NOT_MATCH_CLUSTER(929, AuditLogSeverity.ERROR),
    NETWORK_REMOVE_VM_INTERFACE(930),
    NETWORK_REMOVE_VM_INTERFACE_FAILED(931, AuditLogSeverity.ERROR),
    NETWORK_ADD_VM_INTERFACE(932),
    NETWORK_ADD_VM_INTERFACE_FAILED(933, AuditLogSeverity.ERROR),
    NETWORK_UPDATE_VM_INTERFACE(934),
    NETWORK_UPDATE_VM_INTERFACE_FAILED(935, AuditLogSeverity.ERROR),
    NETWORK_ADD_TEMPLATE_INTERFACE(936),
    NETWORK_ADD_TEMPLATE_INTERFACE_FAILED(937, AuditLogSeverity.ERROR),
    NETWORK_REMOVE_TEMPLATE_INTERFACE(938),
    NETWORK_REMOVE_TEMPLATE_INTERFACE_FAILED(939, AuditLogSeverity.ERROR),
    NETWORK_UPDATE_TEMPLATE_INTERFACE(940),
    NETWORK_UPDATE_TEMPLATE_INTERFACE_FAILED(941, AuditLogSeverity.ERROR),
    NETWORK_ADD_NETWORK(942),
    NETWORK_ADD_NETWORK_FAILED(943, AuditLogSeverity.ERROR),
    NETWORK_REMOVE_NETWORK(944),
    NETWORK_REMOVE_NETWORK_FAILED(945, AuditLogSeverity.ERROR),
    NETWORK_ATTACH_NETWORK_TO_CLUSTER(946),
    NETWORK_ATTACH_NETWORK_TO_CLUSTER_FAILED(947, AuditLogSeverity.ERROR),
    NETWORK_DETACH_NETWORK_TO_CLUSTER(948),
    NETWORK_DETACH_NETWORK_TO_CLUSTER_FAILED(949, AuditLogSeverity.ERROR),
    NETWORK_ACTIVATE_VM_INTERFACE_SUCCESS(1012),
    NETWORK_ACTIVATE_VM_INTERFACE_FAILURE(1013, AuditLogSeverity.ERROR),
    NETWORK_DEACTIVATE_VM_INTERFACE_SUCCESS(1014),
    NETWORK_DEACTIVATE_VM_INTERFACE_FAILURE(1015, AuditLogSeverity.ERROR),
    NETWORK_UPDATE_DISPLAY_FOR_HOST_WITH_ACTIVE_VM(1098, AuditLogSeverity.WARNING),
    NETWORK_UPDATE_DISPLAY_FOR_CLUSTER_WITH_ACTIVE_VM(1099, AuditLogSeverity.WARNING),
    NETWORK_UPDATE_DISPLAY_TO_CLUSTER(1100),
    NETWORK_UPDATE_DISPLAY_TO_CLUSTER_FAILED(1101, AuditLogSeverity.ERROR),
    NETWORK_UPDATE_NETWORK_TO_VDS_INTERFACE(1102),
    NETWORK_UPDATE_NETWORK_TO_VDS_INTERFACE_FAILED(1103, AuditLogSeverity.ERROR),
    NETWORK_COMMINT_NETWORK_CHANGES(1104),
    NETWORK_COMMINT_NETWORK_CHANGES_FAILED(1105, AuditLogSeverity.ERROR),
    @Deprecated
    NETWORK_HOST_USING_WRONG_CLUSER_VLAN(1106, AuditLogSeverity.WARNING),
    @Deprecated
    NETWORK_HOST_MISSING_CLUSER_VLAN(1107, AuditLogSeverity.WARNING),
    @Deprecated
    VDS_NETWORK_MTU_DIFFER_FROM_LOGICAL_NETWORK(1108, AuditLogTimeInterval.HOUR.getValue()),
    BRIDGED_NETWORK_OVER_MULTIPLE_INTERFACES(1109, AuditLogSeverity.WARNING),
    VDS_NETWORKS_OUT_OF_SYNC(1110, AuditLogSeverity.WARNING),
    NETWORK_UPDTAE_NETWORK_ON_CLUSTER(1112),
    NETWORK_UPDTAE_NETWORK_ON_CLUSTER_FAILED(1113, AuditLogSeverity.ERROR),
    NETWORK_UPDATE_NETWORK(1114),
    NETWORK_UPDATE_NETWORK_FAILED(1115, AuditLogSeverity.ERROR),
    NETWORK_UPDATE_VM_INTERFACE_LINK_UP(1116),
    NETWORK_UPDATE_VM_INTERFACE_LINK_DOWN(1117),
    INVALID_BOND_INTERFACE_FOR_MANAGEMENT_NETWORK_CONFIGURATION(1118, AuditLogSeverity.ERROR),
    VLAN_ID_MISMATCH_FOR_MANAGEMENT_NETWORK_CONFIGURATION(1119, AuditLogSeverity.ERROR),
    SETUP_NETWORK_FAILED_FOR_MANAGEMENT_NETWORK_CONFIGURATION(1120, AuditLogSeverity.ERROR),
    PERSIST_NETWORK_FAILED_FOR_MANAGEMENT_NETWORK(1121, AuditLogSeverity.WARNING),
    ADD_VNIC_PROFILE(1122),
    ADD_VNIC_PROFILE_FAILED(1123, AuditLogSeverity.ERROR),
    UPDATE_VNIC_PROFILE(1124),
    UPDATE_VNIC_PROFILE_FAILED(1125, AuditLogSeverity.ERROR),
    REMOVE_VNIC_PROFILE(1126),
    REMOVE_VNIC_PROFILE_FAILED(1127, AuditLogSeverity.ERROR),
    NETWORK_WITHOUT_INTERFACES(1128, AuditLogSeverity.WARNING),
    VNIC_PROFILE_UNSUPPORTED_FEATURES(1129, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.DAY.getValue()),
    REMOVE_NETWORK_BY_LABEL_FAILED(1131, AuditLogSeverity.ERROR),
    LABEL_NETWORK(1132),
    LABEL_NETWORK_FAILED(1133, AuditLogSeverity.ERROR),
    UNLABEL_NETWORK(1134),
    UNLABEL_NETWORK_FAILED(1135, AuditLogSeverity.ERROR),
    LABEL_NIC(1136),
    LABEL_NIC_FAILED(1137, AuditLogSeverity.ERROR),
    UNLABEL_NIC(1138),
    UNLABEL_NIC_FAILED(1139, AuditLogSeverity.ERROR),
    SUBNET_REMOVED(1140),
    SUBNET_REMOVAL_FAILED(1141, AuditLogSeverity.ERROR),
    SUBNET_ADDED(1142),
    SUBNET_ADDITION_FAILED(1143, AuditLogSeverity.ERROR),
    CONFIGURE_NETWORK_BY_LABELS_WHEN_CHANGING_CLUSTER_FAILED(1144, AuditLogSeverity.ERROR),
    PERSIST_NETWORK_ON_HOST(1145),
    PERSIST_NETWORK_ON_HOST_FINISHED(1146),
    PERSIST_NETWORK_ON_HOST_FAILED(1147, AuditLogSeverity.ERROR),
    PERSIST_SETUP_NETWORK_ON_HOST_FINISHED(10903),
    PERSIST_SETUP_NETWORK_ON_HOST_FAILED(10904, AuditLogSeverity.ERROR),
    MULTI_UPDATE_NETWORK_NOT_POSSIBLE(1148, AuditLogSeverity.WARNING),
    REMOVE_PORT_FROM_EXTERNAL_PROVIDER_FAILED(1149, AuditLogSeverity.WARNING),
    PERSIST_HOST_SETUP_NETWORK_ON_HOST(10902),
    HOST_SYNC_ALL_NETWORKS_FAILED(10900, AuditLogSeverity.ERROR),
    HOST_SYNC_ALL_NETWORKS_FINISHED(10901),
    CLUSTER_SYNC_ALL_NETWORKS_FAILED(10905, AuditLogSeverity.ERROR),
    CLUSTER_SYNC_ALL_NETWORKS_STARTED(10906),
    NETWORK_REMOVE_NIC_FILTER_PARAMETER(10910),
    NETWORK_REMOVE_NIC_FILTER_PARAMETER_FAILED(10911, AuditLogSeverity.ERROR),
    NETWORK_ADD_NIC_FILTER_PARAMETER(10912),
    NETWORK_ADD_NIC_FILTER_PARAMETER_FAILED(10913, AuditLogSeverity.ERROR),
    NETWORK_UPDATE_NIC_FILTER_PARAMETER(10914),
    NETWORK_UPDATE_NIC_FILTER_PARAMETER_FAILED(10915, AuditLogSeverity.ERROR),
    NETWORK_IMPORT_EXTERNAL_NETWORK(10920),
    NETWORK_IMPORT_EXTERNAL_NETWORK_FAILED(10921, AuditLogSeverity.ERROR),
    @Deprecated
    NETWORK_IMPORT_EXTERNAL_NETWORK_INTERNAL(10922),
    @Deprecated
    NETWORK_IMPORT_EXTERNAL_NETWORK_INTERNAL_FAILED(10923, AuditLogSeverity.ERROR),
    NETWORK_AUTO_DEFINE_NO_DEFAULT_EXTERNAL_PROVIDER(10924, AuditLogSeverity.WARNING),
    NETWORK_REMOVING_IPV6_GATEWAY_FROM_OLD_DEFAULT_ROUTE_ROLE_ATTACHMENT(10926, AuditLogSeverity.WARNING),

    // Import/Export
    IMPORTEXPORT_STARTING_EXPORT_VM(1162),
    IMPORTEXPORT_EXPORT_VM(1150),
    IMPORTEXPORT_EXPORT_VM_FAILED(1151, AuditLogSeverity.ERROR),
    IMPORTEXPORT_IMPORT_VM_FAILED_UPDATING_OVF(1189, AuditLogSeverity.ERROR),
    IMPORTEXPORT_STARTING_IMPORT_VM(1165),
    IMPORTEXPORT_STARTING_CONVERT_VM(1193),
    IMPORTEXPORT_CONVERT_FAILED(1194),
    IMPORTEXPORT_CANNOT_GET_OVF(1195),
    IMPORTEXPORT_INVALID_OVF(1196),
    IMPORTEXPORT_STARTING_EXPORT_VM_TO_OVA(1223),
    IMPORTEXPORT_EXPORT_VM_TO_OVA(1224),
    IMPORTEXPORT_EXPORT_VM_TO_OVA_FAILED(1225, AuditLogSeverity.ERROR),
    IMPORTEXPORT_STARTING_EXPORT_TEMPLATE_TO_OVA(1226),
    IMPORTEXPORT_EXPORT_TEMPLATE_TO_OVA(1227),
    IMPORTEXPORT_EXPORT_TEMPLATE_TO_OVA_FAILED(1228, AuditLogSeverity.ERROR),
    IMPORTEXPORT_IMPORT_VM(1152),
    IMPORTEXPORT_IMPORT_VM_FAILED(1153, AuditLogSeverity.ERROR),
    IMPORTEXPORT_STARTING_REMOVE_TEMPLATE(1166),
    IMPORTEXPORT_REMOVE_TEMPLATE(1154),
    IMPORTEXPORT_REMOVE_TEMPLATE_FAILED(1155, AuditLogSeverity.ERROR),
    IMPORTEXPORT_EXPORT_TEMPLATE(1156),
    IMPORTEXPORT_STARTING_EXPORT_TEMPLATE(1164),
    IMPORTEXPORT_EXPORT_TEMPLATE_FAILED(1157, AuditLogSeverity.ERROR),
    IMPORTEXPORT_STARTING_IMPORT_TEMPLATE(1163),
    IMPORTEXPORT_IMPORT_TEMPLATE(1158),
    IMPORTEXPORT_IMPORT_TEMPLATE_FAILED(1159, AuditLogSeverity.ERROR),
    IMPORTEXPORT_STARTING_REMOVE_VM(1167),
    IMPORTEXPORT_REMOVE_VM(1160),
    IMPORTEXPORT_REMOVE_VM_FAILED(1161, AuditLogSeverity.ERROR),
    IMPORTEXPORT_GET_VMS_INFO_FAILED(200, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.MINUTE.getValue() * 30),
    IMPORTEXPORT_GET_EXTERNAL_VMS_INFO_FAILED(202, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.MINUTE.getValue() * 30),
    IMPORTEXPORT_FAILED_TO_IMPORT_VM(1168, AuditLogSeverity.WARNING),
    IMPORTEXPORT_FAILED_TO_IMPORT_TEMPLATE(1169, AuditLogSeverity.WARNING),
    IMPORTEXPORT_IMPORT_TEMPLATE_INVALID_INTERFACES(1170, AuditLogSeverity.NORMAL,
            AuditLogTimeInterval.MINUTE.getValue()),
    IMPORTEXPORT_NO_PROXY_HOST_AVAILABLE_IN_DC(1186, AuditLogSeverity.ERROR),
    IMPORTEXPORT_HOST_CANNOT_SERVE_AS_PROXY(1187, AuditLogSeverity.ERROR),
    IMPORTEXPORT_PARTIAL_VM_MISSING_ENTITIES(1188, AuditLogSeverity.WARNING),
    IMPORTEXPORT_PARTIAL_TEMPLATE_MISSING_ENTITIES(1197, AuditLogSeverity.WARNING),
    FAILED_DETERMINE_STORAGE_DOMAIN_METADATA_DEVICES(1219, AuditLogSeverity.ERROR),

    // SR-IOV
    UPDATE_HOST_NIC_VFS_CONFIG(1201),
    UPDATE_HOST_NIC_VFS_CONFIG_FAILED(1202, AuditLogSeverity.ERROR),
    ADD_VFS_CONFIG_NETWORK(1203),
    ADD_VFS_CONFIG_NETWORK_FAILED(1204),
    REMOVE_VFS_CONFIG_NETWORK(1205),
    REMOVE_VFS_CONFIG_NETWORK_FAILED(1206),
    ADD_VFS_CONFIG_LABEL(1207),
    ADD_VFS_CONFIG_LABEL_FAILED(1208),
    REMOVE_VFS_CONFIG_LABEL(1209),
    REMOVE_VFS_CONFIG_LABEL_FAILED(1210),

    // Reduce domain
    USER_REDUCE_DOMAIN_DEVICES_STARTED(1211),
    USER_REDUCE_DOMAIN_DEVICES_FAILED_METADATA_DEVICES(1212, AuditLogSeverity.ERROR),
    USER_REDUCE_DOMAIN_DEVICES_FAILED(1213, AuditLogSeverity.ERROR),
    USER_REDUCE_DOMAIN_DEVICES_SUCCEEDED(1214),
    USER_REDUCE_DOMAIN_DEVICES_FAILED_NO_FREE_SPACE(1215, AuditLogSeverity.ERROR),
    USER_REDUCE_DOMAIN_DEVICES_FAILED_TO_GET_DOMAIN_INFO(1216, AuditLogSeverity.ERROR),

    // VM leases
    CANNOT_IMPORT_VM_WITH_LEASE_COMPAT_VERSION(1217, AuditLogSeverity.WARNING),
    CANNOT_IMPORT_VM_WITH_LEASE_STORAGE_DOMAIN(1218, AuditLogSeverity.WARNING),
    HOT_PLUG_LEASE_FAILED(1220, AuditLogSeverity.ERROR),
    HOT_UNPLUG_LEASE_FAILED(1221, AuditLogSeverity.ERROR),
    DETACH_DOMAIN_WITH_VMS_AND_TEMPLATES_LEASES(1222, AuditLogSeverity.WARNING),
    CANNOT_IMPORT_VM_TEMPLATE_WITH_LEASE_COMPAT_VERSION(1350, AuditLogSeverity.WARNING),
    CANNOT_IMPORT_VM_TEMPLATE_WITH_LEASE_STORAGE_DOMAIN(1351, AuditLogSeverity.WARNING),

    // NUMA
    NUMA_ADD_VM_NUMA_NODE_SUCCESS(1300),
    NUMA_ADD_VM_NUMA_NODE_FAILED(1301, AuditLogSeverity.ERROR),
    NUMA_UPDATE_VM_NUMA_NODE_SUCCESS(1310),
    NUMA_UPDATE_VM_NUMA_NODE_FAILED(1311, AuditLogSeverity.ERROR),
    NUMA_REMOVE_VM_NUMA_NODE_SUCCESS(1320),
    NUMA_REMOVE_VM_NUMA_NODE_FAILED(1321, AuditLogSeverity.ERROR),
    VM_DOES_NOT_FIT_TO_SINGLE_NUMA_NODE(1340, AuditLogSeverity.WARNING),

    USER_ADD_PERMISSION(850),
    USER_ADD_PERMISSION_FAILED(851, AuditLogSeverity.ERROR),
    USER_REMOVE_PERMISSION(852),
    USER_REMOVE_PERMISSION_FAILED(853, AuditLogSeverity.ERROR),
    USER_ADD_ROLE(854),
    USER_ADD_ROLE_FAILED(855, AuditLogSeverity.ERROR),
    USER_UPDATE_ROLE(856),
    USER_UPDATE_ROLE_FAILED(857, AuditLogSeverity.ERROR),
    USER_REMOVE_ROLE(858),
    USER_REMOVE_ROLE_FAILED(859, AuditLogSeverity.ERROR),
    USER_ATTACHED_ACTION_GROUP_TO_ROLE(860),
    USER_ATTACHED_ACTION_GROUP_TO_ROLE_FAILED(861, AuditLogSeverity.ERROR),
    USER_DETACHED_ACTION_GROUP_FROM_ROLE(862),
    USER_DETACHED_ACTION_GROUP_FROM_ROLE_FAILED(863, AuditLogSeverity.ERROR),
    USER_ADD_ROLE_WITH_ACTION_GROUP(864),
    USER_ADD_ROLE_WITH_ACTION_GROUP_FAILED(865, AuditLogSeverity.ERROR),
    USER_ADD_SYSTEM_PERMISSION(866),
    USER_ADD_SYSTEM_PERMISSION_FAILED(867, AuditLogSeverity.ERROR),
    USER_REMOVE_SYSTEM_PERMISSION(868),
    USER_REMOVE_SYSTEM_PERMISSION_FAILED(869, AuditLogSeverity.ERROR),
    USER_ADD_PROFILE(870),
    USER_ADD_PROFILE_FAILED(871, AuditLogSeverity.ERROR),
    USER_UPDATE_PROFILE(872),
    USER_UPDATE_PROFILE_FAILED(873, AuditLogSeverity.ERROR),
    USER_REMOVE_PROFILE(874),
    USER_REMOVE_PROFILE_FAILED(875, AuditLogSeverity.ERROR),

    // AD Computer Account
    AD_COMPUTER_ACCOUNT_SUCCEEDED(900),
    AD_COMPUTER_ACCOUNT_FAILED(901, AuditLogSeverity.ERROR),
    USER_ADD_STORAGE_POOL(950),
    USER_ADD_STORAGE_POOL_FAILED(951, AuditLogSeverity.ERROR),
    USER_UPDATE_STORAGE_POOL(952),
    USER_UPDATE_STORAGE_POOL_FAILED(953, AuditLogSeverity.ERROR),
    USER_REMOVE_STORAGE_POOL(954),
    USER_REMOVE_STORAGE_POOL_FAILED(955, AuditLogSeverity.ERROR),
    USER_FORCE_REMOVE_STORAGE_POOL(918),
    USER_FORCE_REMOVE_STORAGE_POOL_FAILED(919, AuditLogSeverity.ERROR),
    USER_ADD_STORAGE_DOMAIN(956),
    USER_ADD_STORAGE_DOMAIN_FAILED(957, AuditLogSeverity.ERROR),
    USER_UPDATE_STORAGE_DOMAIN(958),
    USER_UPDATE_STORAGE_DOMAIN_FAILED(959, AuditLogSeverity.ERROR),
    USER_REMOVE_STORAGE_DOMAIN(960),
    USER_REMOVE_STORAGE_DOMAIN_FAILED(961, AuditLogSeverity.ERROR),
    USER_ATTACH_STORAGE_DOMAIN_TO_POOL(962),
    USER_ATTACH_STORAGE_DOMAIN_TO_POOL_FAILED(963, AuditLogSeverity.ERROR),
    USER_DETACH_STORAGE_DOMAIN_FROM_POOL(964),
    USER_DETACH_STORAGE_DOMAIN_FROM_POOL_FAILED(965, AuditLogSeverity.ERROR),
    USER_ACTIVATED_STORAGE_DOMAIN(966),
    USER_ACTIVATE_STORAGE_DOMAIN_FAILED(967, AuditLogSeverity.ERROR),
    USER_DEACTIVATED_STORAGE_DOMAIN(968),
    USER_DEACTIVATE_STORAGE_DOMAIN_FAILED(969, AuditLogSeverity.ERROR),
    SYSTEM_DEACTIVATED_STORAGE_DOMAIN(970, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.MINUTE.getValue()),
    SYSTEM_DEACTIVATE_STORAGE_DOMAIN_FAILED(971, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.MINUTE.getValue()),
    USER_EXTENDED_STORAGE_DOMAIN(972),
    USER_EXTENDED_STORAGE_DOMAIN_FAILED(973, AuditLogSeverity.ERROR),
    @Deprecated
    USER_REMOVE_VG(974),
    @Deprecated
    USER_REMOVE_VG_FAILED(975, AuditLogSeverity.ERROR),
    USER_ACTIVATE_STORAGE_POOL(976),
    USER_ACTIVATE_STORAGE_POOL_FAILED(977, AuditLogSeverity.ERROR),
    SYSTEM_FAILED_CHANGE_STORAGE_POOL_STATUS(978, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.MINUTE.getValue()),
    SYSTEM_CHANGE_STORAGE_POOL_STATUS_NO_HOST_FOR_SPM(979, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.MINUTE.getValue()),
    SYSTEM_CHANGE_STORAGE_POOL_STATUS_PROBLEMATIC(980, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.MINUTE.getValue()),

    USER_FORCE_REMOVE_STORAGE_DOMAIN(981),
    USER_FORCE_REMOVE_STORAGE_DOMAIN_FAILED(982, AuditLogSeverity.ERROR),
    RECONSTRUCT_MASTER_FAILED_NO_MASTER(983, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.HOUR.getValue()),
    RECONSTRUCT_MASTER_DONE(984),
    RECONSTRUCT_MASTER_FAILED(985, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.HOUR.getValue()),
    SYSTEM_CHANGE_STORAGE_POOL_STATUS_PROBLEMATIC_SEARCHING_NEW_SPM(986, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.MINUTE.getValue()),
    SYSTEM_CHANGE_STORAGE_POOL_STATUS_PROBLEMATIC_WITH_ERROR(987, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.MINUTE.getValue()),
    USER_CONNECT_HOSTS_TO_LUN_FAILED(988, AuditLogSeverity.ERROR),
    SYSTEM_CHANGE_STORAGE_POOL_STATUS_PROBLEMATIC_FROM_NON_OPERATIONAL(989, AuditLogTimeInterval.MINUTE.getValue()),
    SYSTEM_MASTER_DOMAIN_NOT_IN_SYNC(990, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.MINUTE.getValue()),
    RECOVERY_STORAGE_POOL(991),
    RECOVERY_STORAGE_POOL_FAILED(992, AuditLogSeverity.ERROR),
    SYSTEM_CHANGE_STORAGE_POOL_STATUS_RESET_IRS(993, AuditLogTimeInterval.MINUTE.getValue()),
    CONNECT_STORAGE_SERVERS_FAILED(994, AuditLogSeverity.WARNING),
    CONNECT_STORAGE_POOL_FAILED(995, AuditLogSeverity.WARNING),
    STORAGE_DOMAIN_ERROR(996, AuditLogSeverity.ERROR),
    REFRESH_REPOSITORY_IMAGE_LIST_FAILED(997, AuditLogSeverity.ERROR),
    REFRESH_REPOSITORY_IMAGE_LIST_SUCCEEDED(998),
    STORAGE_ALERT_VG_METADATA_CRITICALLY_FULL(999, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.MINUTE.getValue() * 15),
    STORAGE_ALERT_SMALL_VG_METADATA(1000, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.HOUR.getValue() * 12),
    USER_ATTACH_STORAGE_DOMAINS_TO_POOL(1002),
    USER_ATTACH_STORAGE_DOMAINS_TO_POOL_FAILED(1003, AuditLogSeverity.ERROR),
    STORAGE_DOMAIN_TASKS_ERROR(1004, AuditLogSeverity.WARNING),
    UPDATE_OVF_FOR_STORAGE_POOL_FAILED(1005, AuditLogSeverity.WARNING),
    UPGRADE_STORAGE_POOL_ENCOUNTERED_PROBLEMS(1006, AuditLogSeverity.WARNING),
    REFRESH_REPOSITORY_IMAGE_LIST_INCOMPLETE(1007, AuditLogSeverity.WARNING),
    FAILED_IMPORT_IMAGE_FROM_REPOSITORY(1021, AuditLogSeverity.ERROR),
    NUMBER_OF_LVS_ON_STORAGE_DOMAIN_EXCEEDED_THRESHOLD(1008, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.HOUR.getValue() * 3),
    USER_DEACTIVATE_STORAGE_DOMAIN_OVF_UPDATE_INCOMPLETE(1009, AuditLogSeverity.WARNING),

    RELOAD_CONFIGURATIONS_SUCCESS(1010),
    RELOAD_CONFIGURATIONS_FAILURE(1011, AuditLogSeverity.ERROR),

    UPDATE_OVF_FOR_STORAGE_DOMAIN_FAILED(190, AuditLogSeverity.WARNING),
    CREATE_OVF_STORE_FOR_STORAGE_DOMAIN_FAILED(191, AuditLogSeverity.WARNING),
    CREATE_OVF_STORE_FOR_STORAGE_DOMAIN_INITIATE_FAILED(192, AuditLogSeverity.WARNING),
    DELETE_OVF_STORE_FOR_STORAGE_DOMAIN_FAILED(193, AuditLogSeverity.WARNING),
    USER_UPDATE_OVF_STORE(199),
    UPDATE_FOR_OVF_STORES_FAILED(1016, AuditLogSeverity.WARNING),
    RETRIEVE_OVF_STORE_FAILED(1017, AuditLogSeverity.WARNING),
    OVF_STORE_DOES_NOT_EXISTS(1018, AuditLogSeverity.WARNING),
    UPDATE_DESCRIPTION_FOR_DISK_FAILED(1019, AuditLogSeverity.ERROR),
    UPDATE_DESCRIPTION_FOR_DISK_SKIPPED_SINCE_STORAGE_DOMAIN_NOT_ACTIVE(1020, AuditLogSeverity.WARNING),
    USER_REFRESH_LUN_STORAGE_DOMAIN(1022),
    USER_REFRESH_LUN_STORAGE_DOMAIN_FAILED(1023, AuditLogSeverity.ERROR),
    USER_REFRESH_LUN_STORAGE_DIFFERENT_SIZE_DOMAIN_FAILED(1024, AuditLogSeverity.ERROR),
    FAILED_TO_STORE_ENTIRE_DISK_FIELD_IN_DISK_DESCRIPTION_METADATA(1026, AuditLogSeverity.WARNING),
    FAILED_TO_STORE_ENTIRE_DISK_FIELD_AND_REST_OF_FIELDS_IN_DISK_DESCRIPTION_METADATA(1027, AuditLogSeverity.WARNING),
    FAILED_TO_STORE_DISK_FIELDS_IN_DISK_DESCRIPTION_METADATA(1028, AuditLogSeverity.WARNING),
    STORAGE_DOMAIN_MOVED_TO_MAINTENANCE(1029),
    USER_DEACTIVATED_LAST_MASTER_STORAGE_DOMAIN(1030),
    TRANSFER_IMAGE_INITIATED(1031),
    TRANSFER_IMAGE_SUCCEEDED(1032),
    TRANSFER_IMAGE_CANCELLED(1033),
    TRANSFER_IMAGE_FAILED(1034, AuditLogSeverity.ERROR),
    TRANSFER_IMAGE_TEARDOWN_FAILED(1035, AuditLogSeverity.ALERT),
    USER_SCAN_STORAGE_DOMAIN_FOR_UNREGISTERED_DISKS(1036),
    USER_SCAN_STORAGE_DOMAIN_FOR_UNREGISTERED_DISKS_FAILED(1037, AuditLogSeverity.ERROR),
    LUNS_BROKE_SD_PASS_DISCARD_SUPPORT(1039, AuditLogSeverity.WARNING),
    DISKS_WITH_ILLEGAL_PASS_DISCARD_EXIST(1040, AuditLogSeverity.WARNING),
    USER_REMOVE_DEVICE_FROM_STORAGE_DOMAIN_FAILED(1041, AuditLogSeverity.ERROR),
    USER_REMOVE_DEVICE_FROM_STORAGE_DOMAIN(1042),
    USER_REMOVE_DEVICE_FROM_STORAGE_DOMAIN_STARTED(1043),
    ILLEGAL_STORAGE_DOMAIN_DISCARD_AFTER_DELETE(1044, AuditLogSeverity.WARNING),
    LUNS_BROKE_SD_DISCARD_AFTER_DELETE_SUPPORT(1045, AuditLogSeverity.WARNING),
    STORAGE_DOMAINS_COULD_NOT_BE_SYNCED(1046, AuditLogSeverity.ALERT),
    DIRECT_LUNS_COULD_NOT_BE_SYNCED(1048, AuditLogSeverity.ALERT),
    OVF_STORES_UPDATE_IGNORED(1052, AuditLogSeverity.NORMAL),

    // ImageIO
    UPLOAD_IMAGE_CLIENT_ERROR(1060, AuditLogSeverity.ERROR),
    UPLOAD_IMAGE_XHR_TIMEOUT_ERROR(1061, AuditLogSeverity.ERROR),
    UPLOAD_IMAGE_NETWORK_ERROR(1062, AuditLogSeverity.ERROR),
    DOWNLOAD_IMAGE_NETWORK_ERROR(1063, AuditLogSeverity.ERROR),
    TRANSFER_IMAGE_STOPPED_BY_SYSTEM_TICKET_RENEW_FAILURE(1064, AuditLogSeverity.ERROR),
    TRANSFER_IMAGE_STOPPED_BY_SYSTEM_MISSING_TICKET(1065, AuditLogSeverity.ERROR),
    TRANSFER_IMAGE_STOPPED_BY_SYSTEM_MISSING_HOST(1067, AuditLogSeverity.ERROR),
    TRANSFER_IMAGE_STOPPED_BY_SYSTEM_FAILED_TO_CREATE_TICKET(1068, AuditLogSeverity.ERROR),
    TRANSFER_IMAGE_STOPPED_BY_SYSTEM_FAILED_TO_ADD_TICKET_TO_DAEMON(1069, AuditLogSeverity.ERROR),
    TRANSFER_IMAGE_STOPPED_BY_SYSTEM_FAILED_TO_ADD_TICKET_TO_PROXY(1070, AuditLogSeverity.ERROR),
    UPLOAD_IMAGE_PAUSED_BY_SYSTEM_TIMEOUT(1071, AuditLogSeverity.ERROR),
    DOWNLOAD_IMAGE_CANCELED_TIMEOUT(1072, AuditLogSeverity.ERROR),
    TRANSFER_IMAGE_PAUSED_BY_USER(1073, AuditLogSeverity.NORMAL),
    TRANSFER_IMAGE_RESUMED_BY_USER(1074, AuditLogSeverity.NORMAL),

    // Authentication
    USER_ACCOUNT_DISABLED_OR_LOCKED(160, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.HOUR.getValue()),
    USER_ACCOUNT_PASSWORD_EXPIRED(1171, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.HOUR.getValue()),
    AUTH_FAILED_INVALID_CREDENTIALS(1172, AuditLogSeverity.ERROR),
    AUTH_FAILED_CLOCK_SKEW_TOO_GREAT(1173, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.HOUR.getValue()),
    AUTH_FAILED_NO_KDCS_FOUND(1174, AuditLogSeverity.ERROR),
    AUTH_FAILED_DNS_ERROR(1175, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.HOUR.getValue()),
    AUTH_FAILED_OTHER(1176, AuditLogSeverity.ERROR),
    AUTH_FAILED_DNS_COMMUNICATION_ERROR(1177, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.HOUR.getValue()),
    AUTH_FAILED_CONNECTION_TIMED_OUT(1178, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.HOUR.getValue()),
    AUTH_FAILED_WRONG_REALM(1179, AuditLogSeverity.ERROR),
    AUTH_FAILED_CONNECTION_ERROR(1180, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.HOUR.getValue()),
    AUTH_FAILED_CANNOT_FIND_LDAP_SERVER_FOR_DOMAIN(1181, AuditLogSeverity.ERROR),
    AUTH_FAILED_NO_USER_INFORMATION_WAS_FOUND(1182, AuditLogSeverity.ERROR),
    AUTH_FAILED_CLIENT_NOT_FOUND_IN_KERBEROS_DATABASE(1183, AuditLogSeverity.ERROR),
    AUTH_FAILED_INTERNAL_KERBEROS_ERROR(1184, AuditLogSeverity.ERROR),
    USER_ACCOUNT_EXPIRED(1185, AuditLogSeverity.ERROR),

    // Providers
    PROVIDER_ADDED(205),
    PROVIDER_ADDITION_FAILED(206, AuditLogSeverity.ERROR),
    PROVIDER_UPDATED(207),
    PROVIDER_UPDATE_FAILED(208, AuditLogSeverity.ERROR),
    PROVIDER_REMOVED(209),
    PROVIDER_REMOVAL_FAILED(210, AuditLogSeverity.ERROR),
    PROVIDER_CERTIFICATE_IMPORTED(213),
    PROVIDER_CERTIFICATE_IMPORT_FAILED(214, AuditLogSeverity.ERROR),
    @Deprecated
    PROVIDER_SYNCHRONIZED(215),
    PROVIDER_SYNCHRONIZED_FAILED(216, AuditLogSeverity.ERROR, AuditLogTimeInterval.DAY.getValue()),
    PROVIDER_SYNCHRONIZED_PERFORMED(217),
    PROVIDER_SYNCHRONIZED_PERFORMED_FAILED(218, AuditLogSeverity.ERROR, AuditLogTimeInterval.DAY.getValue()),
    PROVIDER_SYNCHRONIZED_DISABLED(219, AuditLogSeverity.ERROR),

    // General
    ENTITY_RENAMED(1200),
    ENTITY_RENAMED_INTERNALLY(1400),

    VDS_ALERT_FENCE_IS_NOT_CONFIGURED(9000, AuditLogSeverity.ALERT),
    VDS_ALERT_FENCE_TEST_FAILED(9001, AuditLogSeverity.ALERT),
    VDS_ALERT_FENCE_OPERATION_FAILED(9002, AuditLogSeverity.ALERT),
    VDS_ALERT_FENCE_OPERATION_SKIPPED(9003, AuditLogSeverity.ALERT),
    VDS_ALERT_FENCE_NO_PROXY_HOST(9004),
    VDS_ALERT_FENCE_STATUS_VERIFICATION_FAILED(9005, AuditLogSeverity.ALERT),
    CANNOT_HIBERNATE_RUNNING_VMS_AFTER_CLUSTER_CPU_UPGRADE(9006, AuditLogSeverity.WARNING),
    VDS_ALERT_SECONDARY_AGENT_USED_FOR_FENCE_OPERATION(9007, AuditLogSeverity.ALERT),
    VDS_HOST_NOT_RESPONDING_CONNECTING(9008, AuditLogSeverity.WARNING),
    VDS_ALERT_PM_HEALTH_CHECK_FENCE_AGENT_NON_RESPONSIVE(9009, AuditLogSeverity.ALERT),
    VDS_ALERT_PM_HEALTH_CHECK_START_MIGHT_FAIL(9010, AuditLogSeverity.ALERT),
    VDS_ALERT_PM_HEALTH_CHECK_STOP_MIGHT_FAIL(9011, AuditLogSeverity.ALERT),
    VDS_ALERT_PM_HEALTH_CHECK_RESTART_MIGHT_FAIL(9012, AuditLogSeverity.ALERT),
    VDS_ALERT_FENCE_OPERATION_SKIPPED_BROKEN_CONNECTIVITY(9013, AuditLogSeverity.ALERT),
    VDS_ALERT_NOT_RESTARTED_DUE_TO_POLICY(9014, AuditLogSeverity.ALERT),
    VDS_ALERT_FENCE_DISABLED_BY_CLUSTER_POLICY(9015, AuditLogSeverity.ALERT),
    FENCE_DISABLED_IN_CLUSTER_POLICY(9016, AuditLogSeverity.ALERT),
    FENCE_OPERATION_STARTED(9017),
    FENCE_OPERATION_SUCCEEDED(9018),
    FENCE_OPERATION_FAILED(9019, AuditLogSeverity.ERROR),
    FENCE_OPERATION_USING_AGENT_AND_PROXY_STARTED(9020),
    FENCE_OPERATION_USING_AGENT_AND_PROXY_FAILED(9021, AuditLogSeverity.WARNING),
    VDS_ALERT_NO_PM_CONFIG_FENCE_OPERATION_SKIPPED(9028, AuditLogSeverity.ALERT),
    CLUSTER_UPDATE_CPU_WHEN_DEPRECATED(9029, AuditLogSeverity.NORMAL),

    // Engine backup
    ENGINE_NO_FULL_BACKUP(9022, AuditLogSeverity.ALERT),
    ENGINE_NO_WARM_BACKUP(9023, AuditLogSeverity.ALERT),
    ENGINE_BACKUP_STARTED(9024, AuditLogSeverity.NORMAL),
    ENGINE_BACKUP_COMPLETED(9025, AuditLogSeverity.NORMAL),
    ENGINE_BACKUP_FAILED(9026, AuditLogSeverity.ERROR),

    VDS_HOST_NOT_RESPONDING(9027, AuditLogSeverity.WARNING, AuditLogTimeInterval.MINUTE.getValue() * 3),

    TASK_STOPPING_ASYNC_TASK(9500, AuditLogTimeInterval.MINUTE.getValue()),
    TASK_CLEARING_ASYNC_TASK(9501, AuditLogTimeInterval.MINUTE.getValue()),

    VDS_ACTIVATE_ASYNC(9502, AuditLogTimeInterval.HOUR.getValue() * 3), // When VDS is reactivated by autorecovery
    VDS_ACTIVATE_MANUAL_HA_ASYNC(10455, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.HOUR.getValue() * 3), // When VDS is reactivated by autorecovery
    VDS_ACTIVATE_FAILED_ASYNC(9503, AuditLogSeverity.WARNING, AuditLogTimeInterval.HOUR.getValue() * 3), // When VDS is
                                                                                                         // reactivated
    @Deprecated
    STORAGE_ACTIVATE_ASYNC(9504, AuditLogTimeInterval.HOUR.getValue() * 3), // When VDS is reactivated by autorecovery

    USER_ACTIVATED_STORAGE_DOMAIN_ASYNC(9505, AuditLogTimeInterval.HOUR.getValue() * 3),
    USER_ACTIVATE_STORAGE_DOMAIN_FAILED_ASYNC(9506, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.HOUR.getValue() * 3),

    IMPORTEXPORT_IMPORT_VM_INVALID_INTERFACES(9600, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.MINUTE.getValue()),
    VDS_SET_NON_OPERATIONAL_VM_NETWORK_IS_BRIDGELESS(9601, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.MINUTE.getValue()),

    EMULATED_MACHINES_INCOMPATIBLE_WITH_CLUSTER(9604, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.MINUTE.getValue()),

    EMULATED_MACHINES_INCOMPATIBLE_WITH_CLUSTER_LEVEL(9609, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.MINUTE.getValue()),

    MIXING_RHEL_VERSIONS_IN_CLUSTER(9610, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.MINUTE.getValue()),

    /** Highly available virtual machine went down. */
    HA_VM_FAILED(9602, AuditLogSeverity.ERROR),
    /** Restart of a highly available virtual machine failed. */
    HA_VM_RESTART_FAILED(9603, AuditLogSeverity.ERROR),
    EXCEEDED_MAXIMUM_NUM_OF_RESTART_HA_VM_ATTEMPTS(9605, AuditLogSeverity.ERROR),
    RNG_SOURCES_INCOMPATIBLE_WITH_CLUSTER(9608, AuditLogSeverity.WARNING, AuditLogTimeInterval.MINUTE.getValue()),

    IMPORTEXPORT_SNAPSHOT_VM_INVALID_INTERFACES(9606, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.MINUTE.getValue()),
    ADD_VM_FROM_SNAPSHOT_INVALID_INTERFACES(9607, AuditLogSeverity.WARNING,
            AuditLogTimeInterval.MINUTE.getValue()),

    COLD_REBOOT_VM_DOWN(9611),
    COLD_REBOOT_FAILED(9612, AuditLogSeverity.ERROR),
    EXCEEDED_MAXIMUM_NUM_OF_COLD_REBOOT_VM_ATTEMPTS(9613, AuditLogSeverity.ERROR),

    // DWH
    DWH_STOPPED(9701),
    DWH_STARTED(9700),
    DWH_ERROR(9704, AuditLogSeverity.ERROR),

    // External Events/Alerts
    EXTERNAL_EVENT_NORMAL(9801),
    EXTERNAL_EVENT_WARNING(9802, AuditLogSeverity.WARNING),
    EXTERNAL_EVENT_ERROR(9803, AuditLogSeverity.ERROR),
    EXTERNAL_ALERT(9804, AuditLogSeverity.ALERT),

    // watchdog
    WATCHDOG_EVENT(9901, AuditLogSeverity.WARNING),

    // cluster policy
    USER_ADD_CLUSTER_POLICY(9910),
    USER_FAILED_TO_ADD_CLUSTER_POLICY(9911, AuditLogSeverity.ERROR),
    USER_UPDATE_CLUSTER_POLICY(9912),
    USER_FAILED_TO_UPDATE_CLUSTER_POLICY(9913, AuditLogSeverity.ERROR),
    USER_REMOVE_CLUSTER_POLICY(9914),
    USER_FAILED_TO_REMOVE_CLUSTER_POLICY(9915, AuditLogSeverity.ERROR),

    // external scheduler
    FAILED_TO_CONNECT_TO_SCHEDULER_PROXY(9920, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.MINUTE.getValue()),

    // trusted service
    VDS_UNTRUSTED(10000, AuditLogSeverity.ERROR,
            AuditLogTimeInterval.MINUTE.getValue()),
    USER_UPDATE_VM_FROM_TRUSTED_TO_UNTRUSTED(10001, AuditLogSeverity.WARNING),
    USER_UPDATE_VM_FROM_UNTRUSTED_TO_TRUSTED(10002, AuditLogSeverity.WARNING),
    IMPORTEXPORT_IMPORT_VM_FROM_TRUSTED_TO_UNTRUSTED(10003, AuditLogSeverity.WARNING),
    IMPORTEXPORT_IMPORT_VM_FROM_UNTRUSTED_TO_TRUSTED(10004, AuditLogSeverity.WARNING),
    USER_ADD_VM_FROM_TRUSTED_TO_UNTRUSTED(10005, AuditLogSeverity.WARNING),
    USER_ADD_VM_FROM_UNTRUSTED_TO_TRUSTED(10006, AuditLogSeverity.WARNING),
    IMPORTEXPORT_IMPORT_TEMPLATE_FROM_TRUSTED_TO_UNTRUSTED(10007, AuditLogSeverity.WARNING),
    IMPORTEXPORT_IMPORT_TEMPLATE_FROM_UNTRUSTED_TO_TRUSTED(10008, AuditLogSeverity.WARNING),
    USER_ADD_VM_TEMPLATE_FROM_TRUSTED_TO_UNTRUSTED(10009, AuditLogSeverity.WARNING),
    USER_ADD_VM_TEMPLATE_FROM_UNTRUSTED_TO_TRUSTED(10010, AuditLogSeverity.WARNING),
    USER_UPDATE_VM_TEMPLATE_FROM_TRUSTED_TO_UNTRUSTED(10011, AuditLogSeverity.WARNING),
    USER_UPDATE_VM_TEMPLATE_FROM_UNTRUSTED_TO_TRUSTED(10012, AuditLogSeverity.WARNING),
    IMPORTEXPORT_GET_EXTERNAL_VMS_NOT_IN_DOWN_STATUS(10013, AuditLogSeverity.WARNING),

    // External tasks
    USER_ADD_EXTERNAL_JOB(11000),
    USER_ADD_EXTERNAL_JOB_FAILED(11001, AuditLogSeverity.ERROR),


    // Multipath alerts
    FAULTY_MULTIPATHS_ON_HOST(11500, AuditLogSeverity.WARNING),
    NO_FAULTY_MULTIPATHS_ON_HOST(11501, AuditLogSeverity.NORMAL),
    MULTIPATH_DEVICES_WITHOUT_VALID_PATHS_ON_HOST(11502, AuditLogSeverity.WARNING),

    // network Qos
    USER_ADDED_NETWORK_QOS(10100),
    USER_FAILED_TO_ADD_NETWORK_QOS(10101, AuditLogSeverity.ERROR),
    USER_REMOVED_NETWORK_QOS(10102),
    USER_FAILED_TO_REMOVE_NETWORK_QOS(10103, AuditLogSeverity.ERROR),
    USER_UPDATED_NETWORK_QOS(10104),
    USER_FAILED_TO_UPDATE_NETWORK_QOS(10105, AuditLogSeverity.ERROR),

    // Qos
    USER_ADDED_QOS(10110),
    USER_FAILED_TO_ADD_QOS(10111, AuditLogSeverity.ERROR),
    USER_REMOVED_QOS(10112),
    USER_FAILED_TO_REMOVE_QOS(10113, AuditLogSeverity.ERROR),
    USER_UPDATED_QOS(10114),
    USER_FAILED_TO_UPDATE_QOS(10115, AuditLogSeverity.ERROR),

    // Disk Profile
    USER_ADDED_DISK_PROFILE(10120),
    USER_FAILED_TO_ADD_DISK_PROFILE(10121, AuditLogSeverity.ERROR),
    USER_REMOVED_DISK_PROFILE(10122),
    USER_FAILED_TO_REMOVE_DISK_PROFILE(10123, AuditLogSeverity.ERROR),
    USER_UPDATED_DISK_PROFILE(10124),
    USER_FAILED_TO_UPDATE_DISK_PROFILE(10125, AuditLogSeverity.ERROR),

    // Cpu Profile
    USER_ADDED_CPU_PROFILE(10130),
    USER_FAILED_TO_ADD_CPU_PROFILE(10131, AuditLogSeverity.ERROR),
    USER_REMOVED_CPU_PROFILE(10132),
    USER_FAILED_TO_REMOVE_CPU_PROFILE(10133, AuditLogSeverity.ERROR),
    USER_UPDATED_CPU_PROFILE(10134),
    USER_FAILED_TO_UPDATE_CPU_PROFILE(10135, AuditLogSeverity.ERROR),

    // mom policies
    USER_UPDATED_MOM_POLICIES(10200),
    USER_FAILED_TO_UPDATE_MOM_POLICIES(10201, AuditLogSeverity.WARNING),

    // power management policy
    PM_POLICY_UP_TO_MAINTENANCE(10250),
    PM_POLICY_MAINTENANCE_TO_DOWN(10251),
    PM_POLICY_TO_UP(10252),

    // HA Reservation
    CLUSTER_ALERT_HA_RESERVATION(10300, AuditLogSeverity.ALERT,
            AuditLogTimeInterval.MINUTE.getValue() * 10),

    CLUSTER_ALERT_HA_RESERVATION_DOWN(10301, AuditLogSeverity.ALERT),

    // affinity groups
    USER_ADDED_AFFINITY_GROUP(10350),
    USER_FAILED_TO_ADD_AFFINITY_GROUP(10351, AuditLogSeverity.ERROR),
    USER_UPDATED_AFFINITY_GROUP(10352),
    USER_FAILED_TO_UPDATE_AFFINITY_GROUP(10353, AuditLogSeverity.ERROR),
    USER_REMOVED_AFFINITY_GROUP(10354),
    USER_FAILED_TO_REMOVE_AFFINITY_GROUP(10355, AuditLogSeverity.ERROR),
    VM_TO_HOST_CONFLICT_IN_ENFORCING_POSITIVE_AND_NEGATIVE_AFFINITY(10356, AuditLogSeverity.ERROR),
    VM_TO_HOST_CONFLICT_IN_POSITIVE_AND_NEGATIVE_AFFINITY(10357, AuditLogSeverity.WARNING),
    VM_TO_HOST_CONFLICTS_POSITIVE_VM_TO_VM_AFFINITY(10358, AuditLogSeverity.WARNING),
    VM_TO_HOST_CONFLICTS_NEGATIVE_VM_TO_VM_AFFINITY(10359, AuditLogSeverity.WARNING),
    NON_INTERSECTING_POSITIVE_HOSTS_AFFINITY_CONFLICTS(10360, AuditLogSeverity.WARNING),
    VM_TO_VM_AFFINITY_CONFLICTS(10361, AuditLogSeverity.ERROR),

    // affinity labels
    USER_ADDED_AFFINITY_LABEL(10380),
    USER_FAILED_TO_ADD_AFFINITY_LABEL(10381, AuditLogSeverity.ERROR),
    USER_UPDATED_AFFINITY_LABEL(10382),
    USER_FAILED_TO_UPDATE_AFFINITY_LABEL(10383, AuditLogSeverity.ERROR),
    USER_REMOVED_AFFINITY_LABEL(10384),
    USER_FAILED_TO_REMOVE_AFFINITY_LABEL(10385, AuditLogSeverity.ERROR),

    // iSCSI bond
    ISCSI_BOND_ADD_SUCCESS(10400),
    ISCSI_BOND_ADD_SUCCESS_WITH_WARNING(10407, AuditLogSeverity.WARNING),
    ISCSI_BOND_ADD_FAILED(10401, AuditLogSeverity.ERROR),
    ISCSI_BOND_EDIT_SUCCESS(10402),
    ISCSI_BOND_EDIT_SUCCESS_WITH_WARNING(10406, AuditLogSeverity.WARNING),
    ISCSI_BOND_EDIT_FAILED(10403, AuditLogSeverity.ERROR),
    ISCSI_BOND_REMOVE_SUCCESS(10404),
    ISCSI_BOND_REMOVE_FAILED(10405, AuditLogSeverity.ERROR),

    // Hosted Engine
    USER_SET_HOSTED_ENGINE_MAINTENANCE(10450),
    USER_FAILED_TO_SET_HOSTED_ENGINE_MAINTENANCE(10451, AuditLogSeverity.ERROR),
    HOSTED_ENGINE_VM_IMPORT_SUCCEEDED(10456, AuditLogSeverity.NORMAL),
    HOSTED_ENGINE_VM_IMPORT_FAILED(10457, AuditLogSeverity.ERROR, AuditLogTimeInterval.HOUR.getValue() * 2),
    HOSTED_ENGINE_SD_NOT_EXIT(10458, AuditLogSeverity.WARNING, AuditLogTimeInterval.HOUR.getValue() * 2),
    HOSTED_ENGINE_SD_NOT_ACTIVE(10459, AuditLogSeverity.WARNING, AuditLogTimeInterval.HOUR.getValue() * 2),
    HOSTED_ENGINE_DOMAIN_IMPORT_SUCCEEDED(10460, AuditLogSeverity.NORMAL, AuditLogTimeInterval.HOUR.getValue()),
    HOSTED_ENGINE_DOMAIN_IMPORT_FAILED(10461, AuditLogSeverity.ERROR, AuditLogTimeInterval.HOUR.getValue()),

    // External scheduler
    EXTERNAL_SCHEDULER_PLUGIN_ERROR(10500, AuditLogSeverity.ERROR),
    EXTERNAL_SCHEDULER_ERROR(10501, AuditLogSeverity.ERROR),

    // Audit Log
    USER_REMOVE_AUDIT_LOG(10600),
    USER_REMOVE_AUDIT_LOG_FAILED(10601, AuditLogSeverity.ERROR),
    USER_CLEAR_ALL_AUDIT_LOG_EVENTS(10602),
    USER_CLEAR_ALL_AUDIT_LOG_EVENTS_FAILED(10603, AuditLogSeverity.ERROR),
    USER_CLEAR_ALL_AUDIT_LOG_ALERTS(10606),
    USER_CLEAR_ALL_AUDIT_LOG_ALERTS_FAILED(10607, AuditLogSeverity.ERROR),
    USER_DISPLAY_ALL_AUDIT_LOG(10604),
    USER_DISPLAY_ALL_AUDIT_LOG_FAILED(10605, AuditLogSeverity.ERROR),

    VM_SLA_POLICY_CPU(10550),
    VM_SLA_POLICY_STORAGE(10551),
    VM_SLA_POLICY_CPU_STORAGE(10552),
    FAILED_VM_SLA_POLICY(10553, AuditLogSeverity.ERROR),

    // MacPool Log
    MAC_POOL_ADD_SUCCESS(10700),
    MAC_POOL_ADD_FAILED(10701, AuditLogSeverity.ERROR),
    MAC_POOL_EDIT_SUCCESS(10702),
    MAC_POOL_EDIT_FAILED(10703, AuditLogSeverity.ERROR),
    MAC_POOL_REMOVE_SUCCESS(10704),
    MAC_POOL_REMOVE_FAILED(10705, AuditLogSeverity.ERROR),

    // Cinder
    CINDER_PROVIDER_ERROR(10750, AuditLogSeverity.ERROR),
    CINDER_DISK_CONNECTION_FAILURE(10751, AuditLogSeverity.ERROR),
    CINDER_DISK_CONNECTION_VOLUME_DRIVER_UNSUPPORTED(10752, AuditLogSeverity.ERROR),
    USER_FINISHED_FAILED_REMOVE_CINDER_DISK(10753, AuditLogSeverity.ERROR),
    USER_ADDED_LIBVIRT_SECRET(10754),
    USER_FAILED_TO_ADD_LIBVIRT_SECRET(10755, AuditLogSeverity.ERROR),
    USER_UPDATE_LIBVIRT_SECRET(10756),
    USER_FAILED_TO_UPDATE_LIBVIRT_SECRET(10757, AuditLogSeverity.ERROR),
    USER_REMOVED_LIBVIRT_SECRET(10758),
    USER_FAILED_TO_REMOVE_LIBVIRT_SECRET(10759, AuditLogSeverity.ERROR),
    FAILED_TO_REGISTER_LIBVIRT_SECRET(10760, AuditLogSeverity.ERROR),
    FAILED_TO_UNREGISTER_LIBVIRT_SECRET(10761, AuditLogSeverity.ERROR),
    FAILED_TO_REGISTER_LIBVIRT_SECRET_ON_VDS(10762, AuditLogSeverity.ERROR),
    NO_LIBRBD_PACKAGE_AVAILABLE_ON_VDS(10763, AuditLogSeverity.ERROR),
    FAILED_TO_FREEZE_VM(10764, AuditLogSeverity.WARNING),
    FAILED_TO_THAW_VM(10765, AuditLogSeverity.WARNING),
    FREEZE_VM_INITIATED(10766, AuditLogSeverity.NORMAL),
    FREEZE_VM_SUCCESS(10767, AuditLogSeverity.NORMAL),
    THAW_VM_SUCCESS(10768, AuditLogSeverity.NORMAL),
    USER_FAILED_TO_FREEZE_VM(10769, AuditLogSeverity.WARNING),
    USER_FAILED_TO_THAW_VM(10770, AuditLogSeverity.WARNING),
    VDS_CANNOT_CONNECT_TO_GLUSTERFS(10771, AuditLogSeverity.ERROR),

    // Managed Block Storage
    CONNECTOR_INFO_MISSING_ON_VDS(10772, AuditLogSeverity.ERROR),
    UNDO_SNAPSHOT_FAILURE_PARTIAL(10773, AuditLogSeverity.ERROR),

    //Affinity Rules Enforcement Manager
    AFFINITY_RULES_ENFORCEMENT_MANAGER_START(10780, AuditLogSeverity.NORMAL),
    AFFINITY_RULES_ENFORCEMENT_MANAGER_INTERVAL_REACHED(10781, AuditLogSeverity.NORMAL),

    // Incremental Backup
    VM_BACKUP_STARTED(10790),
    VM_BACKUP_FAILED(10792, AuditLogSeverity.ERROR),
    VM_BACKUP_SUCCEEDED(10793),
    VM_BACKUP_FINALIZED(10794),
    VM_BACKUP_FAILED_TO_FINALIZE(10795, AuditLogSeverity.ERROR),

    // Host Devices
    VM_ADD_HOST_DEVICES(10800),
    VM_REMOVE_HOST_DEVICES(10801),

    VDS_BROKER_COMMAND_FAILURE(10802, AuditLogSeverity.ERROR, 30),
    IRS_BROKER_COMMAND_FAILURE(10803, AuditLogSeverity.ERROR),

    // Unable to resolve ip of host registered using hostname
    VDS_UNKNOWN_HOST(10804, AuditLogSeverity.ERROR),

    // DC status
    SYSTEM_CHANGE_STORAGE_POOL_STATUS_UP_REPORTING_HOSTS(10810, AuditLogSeverity.NORMAL),
    SYSTEM_CHANGE_STORAGE_POOL_STATUS_NON_RESPONSIVE_NO_REPORTING_HOSTS(10811, AuditLogSeverity.ALERT),
    STORAGE_POOL_LOWER_THAN_ENGINE_HIGHEST_CLUSTER_LEVEL(10812, AuditLogSeverity.ALERT),

    // Migration reasons
    MIGRATION_REASON_AFFINITY_ENFORCEMENT(12000),
    MIGRATION_REASON_LOAD_BALANCING(12001),
    MIGRATION_REASON_HOST_IN_MAINTENANCE(12002),

    CLUSTER_CANNOT_UPDATE_VM_COMPATIBILITY_VERSION(12005, AuditLogSeverity.ERROR),

    // API deprecation warning, at most once each day:
    DEPRECATED_API(13000, AuditLogSeverity.WARNING, AuditLogTimeInterval.DAY.getValue()),

    DEPRECATED_IPTABLES_FIREWALL(13001, AuditLogSeverity.WARNING);

    private int intValue;
    // indicates time interval in seconds on which identical events from same instance are suppressed.
    private int eventFloodRate;
    private static final Map<Integer, AuditLogType> mappings = new HashMap<>();
    private AuditLogSeverity severity;

    static {
        for (AuditLogType logType : values()) {
            mappings.put(logType.getValue(), logType);
        }
    }

    private AuditLogType(int value) {
        this(value, null, 0);
    }

    private AuditLogType(int value, AuditLogSeverity severity) {
        this(value, severity, 0);
    }

    private AuditLogType(int value, int eventFloodRate) {
        this(value, null, eventFloodRate);
    }

    private AuditLogType(int value, AuditLogSeverity severity, int eventFloodRate) {
        intValue = value;
        this.eventFloodRate = eventFloodRate;
        this.severity = getDefaultSeverity(severity);
    }

    private static AuditLogSeverity getDefaultSeverity(AuditLogSeverity severity) {
        return severity == null ? AuditLogSeverity.NORMAL : severity;
    }

    public int getValue() {
        return intValue;
    }

    public int getEventFloodRate() {
        return eventFloodRate;
    }

    public AuditLogSeverity getSeverity() {
        return severity;
    }

    public boolean shouldBeLogged() {
        return this != AuditLogType.UNASSIGNED;
    }

    public static AuditLogType forValue(int value) {
        return mappings.get(value);
    }

}
