/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.HostNicContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlBondingReader;
import org.ovirt.engine.sdk4.internal.xml.XmlBootProtocolReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHostNicVirtualFunctionsConfigurationReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHostReader;
import org.ovirt.engine.sdk4.internal.xml.XmlIpReader;
import org.ovirt.engine.sdk4.internal.xml.XmlMacReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNetworkLabelReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNetworkReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNicStatusReader;
import org.ovirt.engine.sdk4.internal.xml.XmlPropertyReader;
import org.ovirt.engine.sdk4.internal.xml.XmlQosReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStatisticReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVlanReader;
import org.ovirt.engine.sdk4.types.HostNic;
import org.ovirt.engine.sdk4.types.NetworkLabel;
import org.ovirt.engine.sdk4.types.Statistic;

public class XmlHostNicReader {
    public static HostNic readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        HostNicContainer object = new HostNicContainer();
        block68: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block68;
                }
                case "id": {
                    object.id(image);
                    continue block68;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block69: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "ad_aggregator_id": {
                    object.adAggregatorId(reader.readInteger());
                    continue block69;
                }
                case "base_interface": {
                    object.baseInterface(reader.readString());
                    continue block69;
                }
                case "bonding": {
                    object.bonding(XmlBondingReader.readOne(reader));
                    continue block69;
                }
                case "boot_protocol": {
                    object.bootProtocol(XmlBootProtocolReader.readOne(reader));
                    continue block69;
                }
                case "bridged": {
                    object.bridged(reader.readBoolean());
                    continue block69;
                }
                case "check_connectivity": {
                    object.checkConnectivity(reader.readBoolean());
                    continue block69;
                }
                case "comment": {
                    object.comment(reader.readString());
                    continue block69;
                }
                case "custom_configuration": {
                    object.customConfiguration(reader.readBoolean());
                    continue block69;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block69;
                }
                case "host": {
                    object.host(XmlHostReader.readOne(reader));
                    continue block69;
                }
                case "ip": {
                    object.ip(XmlIpReader.readOne(reader));
                    continue block69;
                }
                case "ipv6": {
                    object.ipv6(XmlIpReader.readOne(reader));
                    continue block69;
                }
                case "ipv6_boot_protocol": {
                    object.ipv6BootProtocol(XmlBootProtocolReader.readOne(reader));
                    continue block69;
                }
                case "mac": {
                    object.mac(XmlMacReader.readOne(reader));
                    continue block69;
                }
                case "mtu": {
                    object.mtu(reader.readInteger());
                    continue block69;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block69;
                }
                case "network": {
                    object.network(XmlNetworkReader.readOne(reader));
                    continue block69;
                }
                case "network_labels": {
                    object.networkLabels(XmlNetworkLabelReader.readMany(reader));
                    continue block69;
                }
                case "override_configuration": {
                    object.overrideConfiguration(reader.readBoolean());
                    continue block69;
                }
                case "physical_function": {
                    object.physicalFunction(XmlHostNicReader.readOne(reader));
                    continue block69;
                }
                case "properties": {
                    object.properties(XmlPropertyReader.readMany(reader));
                    continue block69;
                }
                case "qos": {
                    object.qos(XmlQosReader.readOne(reader));
                    continue block69;
                }
                case "speed": {
                    object.speed(reader.readInteger());
                    continue block69;
                }
                case "statistics": {
                    object.statistics(XmlStatisticReader.readMany(reader));
                    continue block69;
                }
                case "status": {
                    object.status(XmlNicStatusReader.readOne(reader));
                    continue block69;
                }
                case "virtual_functions_configuration": {
                    object.virtualFunctionsConfiguration(XmlHostNicVirtualFunctionsConfigurationReader.readOne(reader));
                    continue block69;
                }
                case "vlan": {
                    object.vlan(XmlVlanReader.readOne(reader));
                    continue block69;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block69;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlHostNicReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<HostNic> iterateMany(final XmlReader reader) {
        return new Iterator<HostNic>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public HostNic next() {
                HostNic next = XmlHostNicReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<HostNic> readMany(XmlReader reader) {
        ArrayList<HostNic> list = new ArrayList<HostNic>();
        Iterator<HostNic> iterator = XmlHostNicReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(HostNicContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "networklabels": {
                    ArrayListWithHref<NetworkLabel> list = new ArrayListWithHref<NetworkLabel>(object.networkLabels());
                    list.href(href);
                    object.networkLabels(list);
                    break;
                }
                case "statistics": {
                    ArrayListWithHref<Statistic> list = new ArrayListWithHref<Statistic>(object.statistics());
                    list.href(href);
                    object.statistics(list);
                    break;
                }
            }
        }
    }
}

