import $ from 'jquery'

import { setLogDebug } from './helpers'

const CONFIG_URL = '/ovirt-engine/web-ui/ovirt-web-ui.config'

const AppConfiguration = {
  debug: true,
  applicationContext: '',
  applicationURL: '/',
  pageLimit: 8,

  consoleClientResourcesURL: 'https://www.ovirt.org/documentation/admin-guide/virt/console-client-resources/',
  cockpitPort: '9090',
}

export function readConfiguration () {
  return new Promise((resolve, reject) => {
    $.ajax({
      url: CONFIG_URL,
      success: (result) => {
        Object.assign(AppConfiguration, JSON.parse(result))
      },
      error: (result) => {
        console.log(`Failed to load production configuration, assuming development mode.`)
      },
      complete: () => {
        setLogDebug(AppConfiguration.debug)
        resolve()
      },
      async: true,
    })
  })
}

export default AppConfiguration
