%global rolename infra
%global roleprefix oVirt.
%global roleprefix_legacy ovirt-
%global ansible_roles_dir ansible/roles

Name: ovirt-ansible-infra
Summary: Ansible role to deploy oVirt infrastructure.
Version: 1.1.5
Release: 1%{?release_suffix}%{?dist}
Source0: http://resources.ovirt.org/pub/src/ovirt-ansible-infra/ovirt-ansible-infra-1.1.5.tar.gz
License: ASL 2.0
Group:          Virtualization/Management
BuildArch:      noarch
Url:            http://www.ovirt.org

Requires: ansible >= 2.5

%description
This Ansible role provide funtionality to oVirt infrastructure.

%pretrans -p <lua>
-- Remove the legacy directory before installing the symlink. This is known issue in RPM:
-- https://fedoraproject.org/wiki/Packaging:Directory_Replacement
path = "%{_datadir}/%{ansible_roles_dir}/%{roleprefix_legacy}%{rolename}"
st = posix.stat(path)
if st and st.type == "directory" then
  os.execute('rm -rf "'..path..'"')
end

%prep
%setup -c -q

%build

%install
export PKG_DATA_DIR_ORIG=%{_datadir}/%{ansible_roles_dir}/%{roleprefix}%{rolename}
export PKG_DATA_DIR=%{buildroot}$PKG_DATA_DIR_ORIG
export PKG_DOC_DIR=%{buildroot}%{_pkgdocdir}
export ROLENAME_LEGACY=%{buildroot}%{_datadir}/%{ansible_roles_dir}/%{roleprefix_legacy}%{rolename}
sh build.sh install

%files
%{_datadir}/%{ansible_roles_dir}/%{roleprefix}%{rolename}
%{_datadir}/%{ansible_roles_dir}/%{roleprefix_legacy}%{rolename}

%doc README.md
%doc examples/

%license LICENSE

%changelog
* Tue Apr 10 2018 Ondra Machacek <omachace@redhat.com> - 1.1.5-1
- Require Ansible 2.5.
- Add hosted_engine parameter.

* Thu Mar 1 2018 Ondra Machacek <omachace@redhat.com> - 1.1.4-1
- Don't fail when hosts var is not passed.
- Add login support within role.

* Wed Jan 17 2018 Ondra Machacek <omachace@redhat.com> - 1.1.3-1
- Print only host names while looping hosts.
- oVirt.datacenters: use import_role instead of include_role.
- Use skip_missing flag for subelements in oVirt.storages.

* Mon Dec 04 2017 Ondra Machacek <omachace@redhat.com> - 1.1.2-1
- Add %pretrans scriplet to remove legacy role name.

* Mon Nov 27 2017 Ondra Machacek <omachace@redhat.com> - 1.1.1-1
- Fix role names to be in sync with Ansible Galaxy.

* Mon Nov 27 2017 Ondra Machacek <omachace@redhat.com> - 1.1.0-1
- Initial release
