/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.lang.Boolean;
import org.ovirt.engine.sdk4.internal.containers.KsmContainer;
import org.ovirt.engine.sdk4.types.Ksm;

public class KsmBuilder {
    private Boolean enabled;
    private Boolean mergeAcrossNodes;
    
    public KsmBuilder enabled(boolean newEnabled) {
        enabled = Boolean.valueOf(newEnabled);
        return this;
    }
    
    public KsmBuilder enabled(Boolean newEnabled) {
        enabled = newEnabled;
        return this;
    }
    
    
    public KsmBuilder mergeAcrossNodes(boolean newMergeAcrossNodes) {
        mergeAcrossNodes = Boolean.valueOf(newMergeAcrossNodes);
        return this;
    }
    
    public KsmBuilder mergeAcrossNodes(Boolean newMergeAcrossNodes) {
        mergeAcrossNodes = newMergeAcrossNodes;
        return this;
    }
    
    
    public Ksm build() {
        KsmContainer container = new KsmContainer();
        container.enabled(enabled);
        container.mergeAcrossNodes(mergeAcrossNodes);
        return container;
    }
}
