/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.CloudInitBuilder;
import org.ovirt.engine.sdk4.builders.ConfigurationBuilder;
import org.ovirt.engine.sdk4.builders.NicConfigurationBuilder;
import org.ovirt.engine.sdk4.internal.containers.InitializationContainer;
import org.ovirt.engine.sdk4.types.CloudInit;
import org.ovirt.engine.sdk4.types.Configuration;
import org.ovirt.engine.sdk4.types.Initialization;
import org.ovirt.engine.sdk4.types.NicConfiguration;

public class InitializationBuilder {
    private String activeDirectoryOu;
    private String authorizedSshKeys;
    private CloudInit cloudInit;
    private Configuration configuration;
    private String customScript;
    private String dnsSearch;
    private String dnsServers;
    private String domain;
    private String hostName;
    private String inputLocale;
    private List<NicConfiguration> nicConfigurations;
    private String orgName;
    private Boolean regenerateIds;
    private Boolean regenerateSshKeys;
    private String rootPassword;
    private String systemLocale;
    private String timezone;
    private String uiLanguage;
    private String userLocale;
    private String userName;
    private String windowsLicenseKey;

    public InitializationBuilder activeDirectoryOu(String newActiveDirectoryOu) {
        this.activeDirectoryOu = newActiveDirectoryOu;
        return this;
    }

    public InitializationBuilder authorizedSshKeys(String newAuthorizedSshKeys) {
        this.authorizedSshKeys = newAuthorizedSshKeys;
        return this;
    }

    public InitializationBuilder cloudInit(CloudInit newCloudInit) {
        this.cloudInit = newCloudInit;
        return this;
    }

    public InitializationBuilder cloudInit(CloudInitBuilder newCloudInit) {
        this.cloudInit = newCloudInit == null ? null : newCloudInit.build();
        return this;
    }

    public InitializationBuilder configuration(Configuration newConfiguration) {
        this.configuration = newConfiguration;
        return this;
    }

    public InitializationBuilder configuration(ConfigurationBuilder newConfiguration) {
        this.configuration = newConfiguration == null ? null : newConfiguration.build();
        return this;
    }

    public InitializationBuilder customScript(String newCustomScript) {
        this.customScript = newCustomScript;
        return this;
    }

    public InitializationBuilder dnsSearch(String newDnsSearch) {
        this.dnsSearch = newDnsSearch;
        return this;
    }

    public InitializationBuilder dnsServers(String newDnsServers) {
        this.dnsServers = newDnsServers;
        return this;
    }

    public InitializationBuilder domain(String newDomain) {
        this.domain = newDomain;
        return this;
    }

    public InitializationBuilder hostName(String newHostName) {
        this.hostName = newHostName;
        return this;
    }

    public InitializationBuilder inputLocale(String newInputLocale) {
        this.inputLocale = newInputLocale;
        return this;
    }

    public InitializationBuilder nicConfigurations(List<NicConfiguration> newNicConfigurations) {
        if (newNicConfigurations != null) {
            if (this.nicConfigurations == null) {
                this.nicConfigurations = new ArrayList<NicConfiguration>(newNicConfigurations);
            } else {
                this.nicConfigurations.addAll(newNicConfigurations);
            }
        }
        return this;
    }

    public InitializationBuilder nicConfigurations(NicConfiguration ... newNicConfigurations) {
        if (newNicConfigurations != null) {
            if (this.nicConfigurations == null) {
                this.nicConfigurations = new ArrayList<NicConfiguration>(newNicConfigurations.length);
            }
            Collections.addAll(this.nicConfigurations, newNicConfigurations);
        }
        return this;
    }

    public InitializationBuilder nicConfigurations(NicConfigurationBuilder ... newNicConfigurations) {
        if (newNicConfigurations != null) {
            if (this.nicConfigurations == null) {
                this.nicConfigurations = new ArrayList<NicConfiguration>(newNicConfigurations.length);
            }
            for (NicConfigurationBuilder builder : newNicConfigurations) {
                this.nicConfigurations.add(builder.build());
            }
        }
        return this;
    }

    public InitializationBuilder orgName(String newOrgName) {
        this.orgName = newOrgName;
        return this;
    }

    public InitializationBuilder regenerateIds(boolean newRegenerateIds) {
        this.regenerateIds = newRegenerateIds;
        return this;
    }

    public InitializationBuilder regenerateIds(Boolean newRegenerateIds) {
        this.regenerateIds = newRegenerateIds;
        return this;
    }

    public InitializationBuilder regenerateSshKeys(boolean newRegenerateSshKeys) {
        this.regenerateSshKeys = newRegenerateSshKeys;
        return this;
    }

    public InitializationBuilder regenerateSshKeys(Boolean newRegenerateSshKeys) {
        this.regenerateSshKeys = newRegenerateSshKeys;
        return this;
    }

    public InitializationBuilder rootPassword(String newRootPassword) {
        this.rootPassword = newRootPassword;
        return this;
    }

    public InitializationBuilder systemLocale(String newSystemLocale) {
        this.systemLocale = newSystemLocale;
        return this;
    }

    public InitializationBuilder timezone(String newTimezone) {
        this.timezone = newTimezone;
        return this;
    }

    public InitializationBuilder uiLanguage(String newUiLanguage) {
        this.uiLanguage = newUiLanguage;
        return this;
    }

    public InitializationBuilder userLocale(String newUserLocale) {
        this.userLocale = newUserLocale;
        return this;
    }

    public InitializationBuilder userName(String newUserName) {
        this.userName = newUserName;
        return this;
    }

    public InitializationBuilder windowsLicenseKey(String newWindowsLicenseKey) {
        this.windowsLicenseKey = newWindowsLicenseKey;
        return this;
    }

    public Initialization build() {
        InitializationContainer container = new InitializationContainer();
        container.activeDirectoryOu(this.activeDirectoryOu);
        container.authorizedSshKeys(this.authorizedSshKeys);
        container.cloudInit(this.cloudInit);
        container.configuration(this.configuration);
        container.customScript(this.customScript);
        container.dnsSearch(this.dnsSearch);
        container.dnsServers(this.dnsServers);
        container.domain(this.domain);
        container.hostName(this.hostName);
        container.inputLocale(this.inputLocale);
        container.nicConfigurations(this.nicConfigurations);
        container.orgName(this.orgName);
        container.regenerateIds(this.regenerateIds);
        container.regenerateSshKeys(this.regenerateSshKeys);
        container.rootPassword(this.rootPassword);
        container.systemLocale(this.systemLocale);
        container.timezone(this.timezone);
        container.uiLanguage(this.uiLanguage);
        container.userLocale(this.userLocale);
        container.userName(this.userName);
        container.windowsLicenseKey(this.windowsLicenseKey);
        return container;
    }
}

