/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.lang.String;
import java.math.BigInteger;

/**
 * Represents a storage server connection.
 * 
 * Example XML representation:
 * 
 * [source,xml]
 * ----
 * <storage_connection id="123">
 *   <address>mynfs.example.com</address>
 *   <type>nfs</type>
 *   <path>/exports/mydata</path>
 * </storage_connection>
 * ----
 */
public interface StorageConnection extends Identified {
    String address();
    
    boolean addressPresent();
    
    String mountOptions();
    
    boolean mountOptionsPresent();
    
    BigInteger nfsRetrans();
    Byte nfsRetransAsByte();
    Short nfsRetransAsShort();
    Integer nfsRetransAsInteger();
    Long nfsRetransAsLong();
    
    boolean nfsRetransPresent();
    
    BigInteger nfsTimeo();
    Byte nfsTimeoAsByte();
    Short nfsTimeoAsShort();
    Integer nfsTimeoAsInteger();
    Long nfsTimeoAsLong();
    
    boolean nfsTimeoPresent();
    
    NfsVersion nfsVersion();
    
    boolean nfsVersionPresent();
    
    String password();
    
    boolean passwordPresent();
    
    String path();
    
    boolean pathPresent();
    
    BigInteger port();
    Byte portAsByte();
    Short portAsShort();
    Integer portAsInteger();
    Long portAsLong();
    
    boolean portPresent();
    
    String portal();
    
    boolean portalPresent();
    
    String target();
    
    boolean targetPresent();
    
    StorageType type();
    
    boolean typePresent();
    
    String username();
    
    boolean usernamePresent();
    
    String vfsType();
    
    boolean vfsTypePresent();
    
    Host host();
    
    boolean hostPresent();
    
}
