/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.CoreBuilder;
import org.ovirt.engine.sdk4.builders.CpuTopologyBuilder;
import org.ovirt.engine.sdk4.builders.CpuTuneBuilder;
import org.ovirt.engine.sdk4.internal.containers.CpuContainer;
import org.ovirt.engine.sdk4.types.Architecture;
import org.ovirt.engine.sdk4.types.Core;
import org.ovirt.engine.sdk4.types.Cpu;
import org.ovirt.engine.sdk4.types.CpuMode;
import org.ovirt.engine.sdk4.types.CpuTopology;
import org.ovirt.engine.sdk4.types.CpuTune;

public class CpuBuilder {
    private Architecture architecture;
    private List<Core> cores;
    private CpuTune cpuTune;
    private BigInteger level;
    private CpuMode mode;
    private String name;
    private BigDecimal speed;
    private CpuTopology topology;
    private String type;

    public CpuBuilder architecture(Architecture newArchitecture) {
        this.architecture = newArchitecture;
        return this;
    }

    public CpuBuilder cores(List<Core> newCores) {
        if (newCores != null) {
            if (this.cores == null) {
                this.cores = new ArrayList<Core>(newCores);
            } else {
                this.cores.addAll(newCores);
            }
        }
        return this;
    }

    public CpuBuilder cores(Core ... newCores) {
        if (newCores != null) {
            if (this.cores == null) {
                this.cores = new ArrayList<Core>(newCores.length);
            }
            Collections.addAll(this.cores, newCores);
        }
        return this;
    }

    public CpuBuilder cores(CoreBuilder ... newCores) {
        if (newCores != null) {
            if (this.cores == null) {
                this.cores = new ArrayList<Core>(newCores.length);
            }
            for (CoreBuilder builder : newCores) {
                this.cores.add(builder.build());
            }
        }
        return this;
    }

    public CpuBuilder cpuTune(CpuTune newCpuTune) {
        this.cpuTune = newCpuTune;
        return this;
    }

    public CpuBuilder cpuTune(CpuTuneBuilder newCpuTune) {
        this.cpuTune = newCpuTune == null ? null : newCpuTune.build();
        return this;
    }

    public CpuBuilder level(int newLevel) {
        this.level = BigInteger.valueOf(newLevel);
        return this;
    }

    public CpuBuilder level(Integer newLevel) {
        this.level = newLevel == null ? null : BigInteger.valueOf(newLevel.longValue());
        return this;
    }

    public CpuBuilder level(long newLevel) {
        this.level = BigInteger.valueOf(newLevel);
        return this;
    }

    public CpuBuilder level(Long newLevel) {
        this.level = newLevel == null ? null : BigInteger.valueOf(newLevel);
        return this;
    }

    public CpuBuilder level(BigInteger newLevel) {
        this.level = newLevel;
        return this;
    }

    public CpuBuilder mode(CpuMode newMode) {
        this.mode = newMode;
        return this;
    }

    public CpuBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public CpuBuilder speed(float newSpeed) {
        this.speed = BigDecimal.valueOf(newSpeed);
        return this;
    }

    public CpuBuilder speed(Float newSpeed) {
        this.speed = newSpeed == null ? null : BigDecimal.valueOf(newSpeed.doubleValue());
        return this;
    }

    public CpuBuilder speed(double newSpeed) {
        this.speed = BigDecimal.valueOf(newSpeed);
        return this;
    }

    public CpuBuilder speed(Double newSpeed) {
        this.speed = newSpeed == null ? null : BigDecimal.valueOf(newSpeed);
        return this;
    }

    public CpuBuilder speed(BigDecimal newSpeed) {
        this.speed = newSpeed;
        return this;
    }

    public CpuBuilder topology(CpuTopology newTopology) {
        this.topology = newTopology;
        return this;
    }

    public CpuBuilder topology(CpuTopologyBuilder newTopology) {
        this.topology = newTopology == null ? null : newTopology.build();
        return this;
    }

    public CpuBuilder type(String newType) {
        this.type = newType;
        return this;
    }

    public Cpu build() {
        CpuContainer container = new CpuContainer();
        container.architecture(this.architecture);
        container.cores(this.cores);
        container.cpuTune(this.cpuTune);
        container.level(this.level);
        container.mode(this.mode);
        container.name(this.name);
        container.speed(this.speed);
        container.topology(this.topology);
        container.type(this.type);
        return container;
    }
}

