/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.Boolean;
import org.ovirt.engine.sdk4.types.Ksm;

public class KsmContainer extends Container implements Ksm {
    private Boolean enabled;
    private Boolean mergeAcrossNodes;
    
    public boolean enabled() {
        return enabled;
    }
    
    public void enabled(boolean newEnabled) {
        enabled = Boolean.valueOf(newEnabled);
    }
    
    public void enabled(Boolean newEnabled) {
        enabled = newEnabled;
    }
    
    public boolean enabledPresent() {
        return enabled != null;
    }
    
    public boolean mergeAcrossNodes() {
        return mergeAcrossNodes;
    }
    
    public void mergeAcrossNodes(boolean newMergeAcrossNodes) {
        mergeAcrossNodes = Boolean.valueOf(newMergeAcrossNodes);
    }
    
    public void mergeAcrossNodes(Boolean newMergeAcrossNodes) {
        mergeAcrossNodes = newMergeAcrossNodes;
    }
    
    public boolean mergeAcrossNodesPresent() {
        return mergeAcrossNodes != null;
    }
    
}
