/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.HostDeviceContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlHostReader;
import org.ovirt.engine.sdk4.internal.xml.XmlProductReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVendorReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVmReader;
import org.ovirt.engine.sdk4.types.HostDevice;

public class XmlHostDeviceReader {
    public static HostDevice readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        HostDeviceContainer object = new HostDeviceContainer();
        block40: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block40;
                }
                case "id": {
                    object.id(image);
                    continue block40;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block41: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "capability": {
                    object.capability(reader.readString());
                    continue block41;
                }
                case "comment": {
                    object.comment(reader.readString());
                    continue block41;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block41;
                }
                case "host": {
                    object.host(XmlHostReader.readOne(reader));
                    continue block41;
                }
                case "iommu_group": {
                    object.iommuGroup(reader.readInteger());
                    continue block41;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block41;
                }
                case "parent_device": {
                    object.parentDevice(XmlHostDeviceReader.readOne(reader));
                    continue block41;
                }
                case "physical_function": {
                    object.physicalFunction(XmlHostDeviceReader.readOne(reader));
                    continue block41;
                }
                case "placeholder": {
                    object.placeholder(reader.readBoolean());
                    continue block41;
                }
                case "product": {
                    object.product(XmlProductReader.readOne(reader));
                    continue block41;
                }
                case "vendor": {
                    object.vendor(XmlVendorReader.readOne(reader));
                    continue block41;
                }
                case "virtual_functions": {
                    object.virtualFunctions(reader.readInteger());
                    continue block41;
                }
                case "vm": {
                    object.vm(XmlVmReader.readOne(reader));
                    continue block41;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.next();
                    continue block41;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlHostDeviceReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<HostDevice> iterateMany(final XmlReader reader) {
        return new Iterator<HostDevice>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public HostDevice next() {
                HostDevice next = XmlHostDeviceReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<HostDevice> readMany(XmlReader reader) {
        ArrayList<HostDevice> list = new ArrayList<HostDevice>();
        Iterator<HostDevice> iterator = XmlHostDeviceReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(HostDeviceContainer object, String[] link) {
    }
}

