/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.String;
import org.ovirt.engine.sdk4.types.Identified;

public class IdentifiedContainer extends Container implements Identified {
    private String comment;
    private String description;
    private String href;
    private String id;
    private String name;
    
    public String comment() {
        return comment;
    }
    
    public void comment(String newComment) {
        comment = newComment;
    }
    
    public boolean commentPresent() {
        return comment != null;
    }
    
    public String description() {
        return description;
    }
    
    public void description(String newDescription) {
        description = newDescription;
    }
    
    public boolean descriptionPresent() {
        return description != null;
    }
    
    public String href() {
        return href;
    }
    
    public void href(String newHref) {
        href = newHref;
    }
    
    public boolean hrefPresent() {
        return href != null;
    }
    
    public String id() {
        return id;
    }
    
    public void id(String newId) {
        id = newId;
    }
    
    public boolean idPresent() {
        return id != null;
    }
    
    public String name() {
        return name;
    }
    
    public void name(String newName) {
        name = newName;
    }
    
    public boolean namePresent() {
        return name != null;
    }
    
}
