/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class HideUtilityClassConstructorCheck
extends Check {
    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    public void visitToken(DetailAST aAST) {
        boolean isUtilClass;
        DetailAST objBlock = aAST.findFirstToken(6);
        boolean hasMethodOrField = false;
        boolean hasNonStaticMethodOrField = false;
        boolean hasDefaultCtor = true;
        boolean hasPublicCtor = false;
        for (DetailAST child = (DetailAST)objBlock.getFirstChild(); child != null; child = (DetailAST)child.getNextSibling()) {
            DetailAST modifiers;
            int type = child.getType();
            if (type == 9 || type == 10) {
                hasMethodOrField = true;
                modifiers = child.findFirstToken(5);
                boolean isStatic = modifiers.branchContains(64);
                boolean isPrivate = modifiers.branchContains(61);
                if (!isStatic && !isPrivate) {
                    hasNonStaticMethodOrField = true;
                }
            }
            if (type != 8) continue;
            hasDefaultCtor = false;
            modifiers = child.findFirstToken(5);
            if (modifiers.branchContains(61) || modifiers.branchContains(63)) continue;
            hasPublicCtor = true;
        }
        boolean hasAccessibleCtor = hasDefaultCtor || hasPublicCtor;
        boolean extendsJLO = aAST.findFirstToken(18) == null;
        boolean bl = isUtilClass = extendsJLO && hasMethodOrField && !hasNonStaticMethodOrField;
        if (isUtilClass && hasAccessibleCtor) {
            this.log(aAST.getLineNo(), aAST.getColumnNo(), "hide.utility.class");
        }
    }
}

