/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.AbstractSvnUpdate;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnCheckout
extends AbstractSvnUpdate<Long> {
    private SvnTarget source;
    private int targetWorkingCopyFormat = -1;

    protected SvnCheckout(SvnOperationFactory factory) {
        super(factory);
    }

    public SvnTarget getSource() {
        return this.source;
    }

    public void setSource(SvnTarget source) {
        this.source = source;
    }

    @Override
    protected void ensureArgumentsAreValid() throws SVNException {
        SVNErrorMessage err;
        super.ensureArgumentsAreValid();
        if (this.getRevision() == null) {
            this.setRevision(SVNRevision.UNDEFINED);
        }
        if (this.getSource() == null || !this.getSource().isURL() || this.getSource().getURL() == null) {
            err = SVNErrorMessage.create(SVNErrorCode.BAD_URL);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (!this.getRevision().isValid() && this.getFirstTarget() != null) {
            this.setRevision(this.getSource().getResolvedPegRevision());
        }
        if (!this.getRevision().isValid()) {
            this.setRevision(SVNRevision.HEAD);
        }
        if (this.getFirstTarget() == null || this.getFirstTarget().getFile() == null) {
            err = SVNErrorMessage.create(SVNErrorCode.BAD_FILENAME, "Checkout destination path can not be NULL");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (this.getRevision().getNumber() < 0L && this.getRevision().getDate() == null && this.getRevision() != SVNRevision.HEAD) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    @Override
    public boolean isChangesWorkingCopy() {
        return true;
    }

    public void setTargetWorkingCopyFormat(int targetWorkingCopyFormat) {
        this.targetWorkingCopyFormat = targetWorkingCopyFormat;
    }

    public int getTargetWorkingCopyFormat() {
        return this.targetWorkingCopyFormat;
    }
}

