#
# ovirt-hosted-engine-setup -- ovirt hosted engine setup
# Copyright (C) 2013-2016 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

%global         package_version 2.0.2.2
%global         ovirt_hosted_engine_setup_templates %{_datadir}/%{name}/templates
%global         ovirt_hosted_engine_setup_scripts %{_datadir}/%{name}/scripts
%global         vdsmhooksdir %{_libexecdir}/vdsm/hooks


Summary:        oVirt Hosted Engine setup tool
Name:           ovirt-hosted-engine-setup
Version:        2.0.2.2
Release:        1%{?release_suffix}%{?dist}
License:        LGPLv2+
URL:            http://www.ovirt.org
Source:         http://resources.ovirt.org/pub/src/%{name}/%{name}-%{package_version}.tar.gz
Group:          Applications/System

BuildArch:      noarch

Requires:       bind-utils
Requires:       genisoimage
Requires:       iptables
Requires:       iptables-services
Requires:       libselinux-python
Requires:       lsof
Requires:       openssh-server
Requires:       openssl
Requires:       python
Requires:       python-ethtool >= 0.6-3
Requires:       python-netaddr
Requires:       python-libguestfs
Requires:       sanlock >= 2.8
Requires:       sanlock-python >= 2.8
Requires:       sudo
Requires:       libvirt-client

BuildRequires:  gettext >= 0.18.2
BuildRequires:  python2-devel

%if 0%{?fedora}
Requires:       qemu-img
%endif

%if 0%{?rhel}
Requires:       qemu-img-rhev
%endif


Requires:       otopi >= 1.5.1
Requires:       ovirt-host-deploy >= 1.5.0
Requires:       ovirt-hosted-engine-ha >= 2.0.3
Requires:       ovirt-engine-sdk-python >= 3.6.3.0
Requires:       ovirt-setup-lib >= 1.0.2
Requires:       glusterfs-cli >= 3.7.3
Requires:       vdsm >= 4.18.13
Requires:       vdsm-cli >= 4.18.13
Requires:       vdsm-python >= 4.18.13
Requires(post): vdsm-python >= 4.18.13

Conflicts:      ovirt-engine-appliance < 4.0
Conflicts:      ovirt-engine-appliance >= 4.1

# Dependencies that will be required by ovirt-host-deploy
# avoiding to have them installed in the middle of the setup
Requires:       dmidecode
Requires:       iproute
Requires:       kexec-tools
Requires:       m2crypto
Requires:       ovirt-vmconsole-host
Requires:       qemu-kvm-tools
Requires:       socat
Requires:       tar
Requires:       tuned
Requires:       util-linux

%description
Hosted Engine setup tool for oVirt project.

%prep
%setup -q -n %{name}-%{package_version}

%build
%configure \
        --docdir="%{_docdir}/%{name}-%{version}" \
        --disable-python-syntax-check \
        %{?conf}
make %{?_smp_mflags}

%install
make %{?_smp_mflags} install DESTDIR="%{buildroot}"
%find_lang %{name}

%files -f %{name}.lang
%license COPYING
%doc README
%dir %{_sysconfdir}/ovirt-hosted-engine-setup.env.d
%dir %{_sysconfdir}/ovirt-hosted-engine
%ghost %attr(600, root, root) %{_sysconfdir}/ovirt-hosted-engine/virsh_auth.conf
%dir %attr(700, root, root) %{_localstatedir}/log/ovirt-hosted-engine-setup
%dir %{_localstatedir}/lib/ovirt-hosted-engine-setup
%dir %{_localstatedir}/lib/ovirt-hosted-engine-setup/answers
%{_sbindir}/hosted-engine
%{_sbindir}/%{name}
%{python_sitelib}/ovirt_hosted_engine_setup/
%{_datadir}/%{name}/
%{_mandir}/man8/*

#move to a separate package?
%{vdsmhooksdir}/before_vm_start/

%post
touch %{_sysconfdir}/ovirt-hosted-engine/virsh_auth.conf
chmod 600 %{_sysconfdir}/ovirt-hosted-engine/virsh_auth.conf
python -c '
from vdsm.tool.configurators import passwd
print((
    "[credentials-vdsm]\n"
    "authname={authname}\n"
    "password={password}\n\n"
    "[auth-libvirt-localhost]\n"
    "credentials=vdsm\n"
).format(
    authname=passwd.SASL_USERNAME,
    password=passwd.libvirt_password(),
))
' > %{_sysconfdir}/ovirt-hosted-engine/virsh_auth.conf

%changelog
* Wed Sep 14 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.0.2.2-1
- 2.0.2.2-1

* Wed Sep 07 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.0.2.2-0.0.master
- 2.0.2.2-0.0.master

* Wed Sep 07 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.0.2.1-1
- 2.0.2.1-1

* Tue Aug 30 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.0.2.1-0.0.master
- 2.0.2.1-0.0.master

* Tue Aug 30 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.0.2-1
- 2.0.2-1

* Thu Aug 25 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.0.1.6-0.0.master
- 2.0.1.6-0.0.master

* Thu Aug 25 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.0.1.5-1
- 2.0.1.5-1

* Tue Aug 09 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.0.1.5-0.0.master
- 2.0.1.5-0.0.master

* Tue Aug 09 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.0.1.4-1
- 2.0.1.4-1

* Wed Jul 27 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.0.1.4-0.0.master
- 2.0.1.4-0.0

* Wed Jul 27 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.0.1.3-1
- 2.0.1.3-1

* Tue Jul 26 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.0.1.3-0.0.master
- 2.0.1.3-0.0

* Tue Jul 26 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.0.1.2-1
- 2.0.1.2-1

* Wed Jul 20 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.0.1.2-0.0.master
- 2.0.1.2-0.0

* Wed Jul 20 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.0.1.1-1
- 2.0.1.1-1

* Tue Jul 12 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 2.0.1-1
- 2.0.1-1

* Thu Jun 16 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.0.0.3-0.0.master
- 2.0.0.3-0.0

* Thu Jun 16 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.0.0.2-1
- 2.0.0.2-1

* Wed Jun 08 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.0.0.2-0.0.master
- 2.0.0.2-0.0.master

* Wed Jun 08 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.0.0.1-1
- 2.0.0.1-1

* Tue May 31 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 2.0.0-1
- 2.0.0-1

* Thu Aug  6 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 2.0.0-0.0.master
- 2.0.0-0.0.master
