#
# ovirt-engine-setup -- ovirt engine setup
# Copyright (C) 2013 Red Hat, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#


"""ovirt-host-rename core plugin."""


from otopi import util


from . import database
from . import engine
from . import misc
from . import pki
from . import protocols
from . import sso
from . import tools
from . import uninstall


@util.export
def createPlugins(context):
    database.Plugin(context=context)
    engine.Plugin(context=context)
    misc.Plugin(context=context)
    pki.Plugin(context=context)
    protocols.Plugin(context=context)
    sso.Plugin(context=context)
    tools.Plugin(context=context)
    uninstall.Plugin(context=context)


# vim: expandtab tabstop=4 shiftwidth=4
