/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.HostNicVirtualFunctionsConfigurationBuilder;
import org.ovirt.engine.sdk4.types.HostNic;
import org.ovirt.engine.sdk4.types.HostNicVirtualFunctionsConfiguration;

public interface HostNicService extends Service {
    public interface GetRequest extends Request<GetRequest, GetResponse> {
    }
    
    public interface GetResponse extends Response {
        HostNic nic();
    }
    
    GetRequest get();
    
    /**
     * The action updates virtual function configuration in case the current resource represents an SR-IOV enabled NIC.
     * The input should be consisted of at least one of the following properties:
     * 
     * - `allNetworksAllowed`
     * - `numberOfVirtualFunctions`
     * 
     * Please see the `HostNicVirtualFunctionsConfiguration` type for the meaning of the properties.
     */
    public interface UpdateVirtualFunctionsConfigurationRequest extends Request<UpdateVirtualFunctionsConfigurationRequest, UpdateVirtualFunctionsConfigurationResponse> {
        /**
         * Indicates if the update should be performed asynchronously.
         */
        UpdateVirtualFunctionsConfigurationRequest async(Boolean async);
        UpdateVirtualFunctionsConfigurationRequest virtualFunctionsConfiguration(HostNicVirtualFunctionsConfiguration virtualFunctionsConfiguration);
        UpdateVirtualFunctionsConfigurationRequest virtualFunctionsConfiguration(HostNicVirtualFunctionsConfigurationBuilder virtualFunctionsConfiguration);
    }
    
    /**
     * The action updates virtual function configuration in case the current resource represents an SR-IOV enabled NIC.
     * The input should be consisted of at least one of the following properties:
     * 
     * - `allNetworksAllowed`
     * - `numberOfVirtualFunctions`
     * 
     * Please see the `HostNicVirtualFunctionsConfiguration` type for the meaning of the properties.
     */
    public interface UpdateVirtualFunctionsConfigurationResponse extends Response {
    }
    
    /**
     * The action updates virtual function configuration in case the current resource represents an SR-IOV enabled NIC.
     * The input should be consisted of at least one of the following properties:
     * 
     * - `allNetworksAllowed`
     * - `numberOfVirtualFunctions`
     * 
     * Please see the `HostNicVirtualFunctionsConfiguration` type for the meaning of the properties.
     */
    UpdateVirtualFunctionsConfigurationRequest updateVirtualFunctionsConfiguration();
    
    NetworkAttachmentsService networkAttachmentsService();
    NetworkLabelsService networkLabelsService();
    /**
     * Retrieves sub-collection resource of network labels that are allowed on an the virtual functions
     * in case that the current resource represents an SR-IOV physical function NIC.
     */
    NetworkLabelsService virtualFunctionAllowedLabelsService();
    /**
     * Retrieves sub-collection resource of networks that are allowed on an the virtual functions
     * in case that the current resource represents an SR-IOV physical function NIC.
     */
    VirtualFunctionAllowedNetworksService virtualFunctionAllowedNetworksService();
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

