/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.services.CopyableService;
import org.ovirt.engine.sdk4.types.Action;

public class CopyableServiceImpl
extends ServiceImpl
implements CopyableService {
    public CopyableServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public CopyableService.CopyRequest copy() {
        return new CopyRequestImpl();
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "CopyableService:" + this.getPath();
    }

    private class CopyResponseImpl
    implements CopyableService.CopyResponse {
        private CopyResponseImpl() {
        }
    }

    private class CopyRequestImpl
    implements CopyableService.CopyRequest {
        private Boolean async;

        private CopyRequestImpl() {
        }

        @Override
        public CopyableService.CopyRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public CopyableService.CopyResponse send() {
            HttpPost request = new HttpPost(CopyableServiceImpl.this.getConnection().getUrl() + CopyableServiceImpl.this.getPath() + "/copy");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                xmlWriter.writeStartElement("action");
                if (this.async != null) {
                    xmlWriter.writeBoolean("async", this.async);
                }
                xmlWriter.writeEndElement();
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            HttpResponse response = CopyableServiceImpl.this.getConnection().send((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 200) {
                Action action = CopyableServiceImpl.this.checkAction(response);
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new CopyResponseImpl();
            }
            CopyableServiceImpl.this.checkFault(response);
            return null;
        }
    }
}

