%if 0%{?fedora} >= 15 || 0%{?rhel} >= 7
%global with_systemd 1
%endif

Summary:        A plugin to make oVirt Node installs compatible with oVirt Engine and vdsm
Name:           ovirt-node-plugin-vdsm
Version:        0.6.1
Release:        0.0.ovirt36%{?BUILD_NUMBER}%{?extra_release}%{?dist}
Source0:        %{name}-0.6.1_ovirt36.tar.gz
License:        GPLv2+
Group:          Applications/System

BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-buildroot
URL:            http://www.ovirt.org/
Requires:       ovirt-node >= 3.0.4
Requires:       python
Requires:       systemd-python
Requires:       vdsm-python >= 4.17.0

Requires:       ovirt-host-deploy-offline >= 1.3.0
%if ! 0%{?rhel}
Requires:       vdsm-hook-vhostmd
%endif

Requires:       ovirt-node-plugin-hosted-engine
Requires:       vdsm-hook-ethtool-options
Requires(post): augeas

BuildArch:      noarch
BuildRequires:  python2-devel
%if 0%{?with_systemd}
BuildRequires:  systemd-units
%endif

%{!?_licensedir:%global license %%doc}

%define app_root %{_datadir}/%{name}
%define recipe_root %{_datadir}/ovirt-node-recipe

%description
Provides UI and associated scripts for integrating oVirt Node and oVirt Engine

%package recipe
Summary:        Kickstarts for building oVirt Node isos including %{name}
Group:          Applications/System
Requires:       ovirt-node-recipe >= 2.6.0

%description recipe
Provides kickstart files for generating an oVirt Node ISO image containing
%{name}.

%prep
%setup -q -n %{name}-0.6.1_ovirt36


%build
%configure

%install
%{__rm} -rf %{buildroot}
make install DESTDIR=%{buildroot}
%if 0%{?with_systemd}
install -Dm 0644 systemd/ovirt-node-plugin-vdsm.service %{buildroot}%{_unitdir}/ovirt-node-plugin-vdsm.service
%endif

# vdsm-reg is deprecated, we do not ship it anymore.
# However, vdsm-upgrade tool is still required since it
# sends messages to engine. As this tool is only used in ovirt-node,
# we should ship it inside ovirt-node-plugin-vdsm. 
install -p -d -m755 %{buildroot}%{_datadir}/vdsm-reg
install -p -d -m755 %{buildroot}%{_localstatedir}/log/vdsm-reg
install -p -m755 vdsm-upgrade/vdsm-upgrade %buildroot%{_datadir}/vdsm-reg/vdsm-upgrade


%post
%if 0%{?with_systemd}
/bin/systemctl enable ovirt-node-plugin-vdsm.service >/dev/null 2>&1 || :
/bin/systemctl daemon-reload >/dev/null 2>&1 || :
%endif

# reserve vdsm port 54321
augtool << \EOF_sysctl
set /files/etc/sysctl.conf/net.ipv4.ip_local_reserved_ports 54321
save
EOF_sysctl

#SELinux Booleans
/usr/sbin/setsebool -P virt_use_nfs=1 \
                       virt_use_sanlock=1 \
                       sanlock_use_nfs=1

%preun

%files recipe
%license COPYING
%{recipe_root}

%files
%dir %{_localstatedir}/log/vdsm-reg
%dir %{_datadir}/vdsm-reg
%license COPYING
%doc README
%{python_sitelib}/ovirt/node/setup/vdsm
%if 0%{?with_systemd}
%{_unitdir}/ovirt-node-plugin-vdsm.service
%endif
%{_sbindir}/ovirt-node-plugin-vdsm-autoreg
%{_datadir}/vdsm-reg/vdsm-upgrade
%{_libexecdir}/ovirt-node/hooks/pre-upgrade/01-vdsm
%{_libexecdir}/ovirt-node/hooks/pre-upgrade/03-persist-multipath-wwids
%{_libexecdir}/ovirt-node/hooks/post-upgrade/01-sanlock-check
%{_libexecdir}/ovirt-node/hooks/on-boot/01-vdsm-configure
%{_libexecdir}/ovirt-node/hooks/on-boot/02-vdsm-sebool-config
%{_libexecdir}/ovirt-node/hooks/on-boot/03-persist-multipath-wwids
%{_libexecdir}/ovirt-node/hooks/on-boot/90-start-vdsm
%{_sysconfdir}/ovirt-plugins.d
%{_sysconfdir}/default/version.ovirt-node-plugin-vdsm

%changelog
* Fri Aug 07 2015 Douglas Schilling Landgraf <dougsland@redhat.com> - 0.6.1
- replace ovirt-register to vdsm-tool register
- use ovirt-node-plugin-vdsm service

* Fri Nov 07 2014 Fabian Deutsch <fabiand@redhat.com> - 0.4.3
- Explicitly start vdsmd again rhbz#1156369

* Wed Nov 05 2014 Fabian Deutsch <fabiand@redhat.com> - 0.4.2
- Move sanlock check to post-upgrade hook rhbz#1156369

* Thu Oct 23 2014 Fabian Deutsch <fabiand@redhat.com> - 0.4.1
- Add sebool handler rhbz#1150243 rhbz#1156038

* Thu Jun 12 2014 Douglas Schilling Landgraf <dougsland@redhat.com> 2.0.0
- Increase the version/release

* Fri May 17 2013 Mike Burns <mburns@redhat.com> 0.0.2
- Rename to ovirt-node-plugin-vdsm
- rebase onto ovirt-node 3.0.0 codebase
- add note about changing sshd when setting passwd
- fix password changing
- fix some requirements
- add minimization

* Fri Feb 15 2013 Mike Burns <mburns@redhat.com> 0.0.1
- initial commit
- engine_page from current ovirt-node
