'use strict';

(function (mod) {

    // A) Add service to access UI plugin API
    mod.factory('pluginApi', ['$window', function ($window) {
        return $window.parent.pluginApi('AngularTest');
    }]);

    // B) Add service to bootstrap UI plugin
    mod.factory('bootstrapService', ['pluginApi', function (pluginApi) {
        var pluginEventHandlers = {
            UiInit: function () {
                pluginApi.addMainTab('Angular Powered Tab',
                        'ngtest-tab', 'plugin/AngularTest/tab.html');
            }
        };
        return {
            initPlugin: function () {
                // Register plugin event handler functions
                pluginApi.register(pluginEventHandlers);
                // Proceed with UI plugin initialization
                pluginApi.ready();
            }
        };
    }]);

    // C) Run bootstrap service on page load
    mod.run(['bootstrapService', function (bootstrapService) {
        bootstrapService.initPlugin();
    }]);

}(
    angular.module('plugin.init', [])
));